/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.MemberInfo;
import com.ca.intertest.tools.ProtsymMessage;
import com.ca.intertest.tools.XMLFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.w3c.dom.Element;

public class Member {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private String dsn = "";
    private String name = "";
    private HashMap<String, String> attributes;
    private Calendar timestamp = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private int time = 0;
    private int date = 0;
    private boolean overwrite = false;
    private boolean monitor = false;
    private boolean statementTrace = false;
    private int selectedDate = 0;
    private int selectedTime = 0;
    private Properties properties = new Properties();

    public Member() {
        this.attributes = new HashMap();
    }

    public Member(debugFile file) {
        ResourceProperty store = file.getStore();
        this.attributes = store.getAttributes();
        this.date = store.getInt("gt_m_jul");
        this.time = store.getInt("gt_m_tim");
        this.name = file.getName();
        this.dsn = store.getString("dsn");
        this.timestamp = (Calendar)Attribute.getValue("time", store);
    }

    public Member(ProtsymMessage message, MemberInfo member) {
        this.attributes = new HashMap();
        this.dsn = message.getDSName().trim();
        this.name = member.getMember().trim();
        this.selectedDate = member.getDate();
        this.selectedTime = member.getTime();
        this.timestamp = member.getTimeStamp();
        this.attributes.put("name", this.name);
        int flag = 176;
        int lang = member.getLangFlag() & flag;
        String str = Integer.toHexString(lang);
        this.attributes.put("gt_m_lang", str);
        switch (lang) {
            case 32: {
                this.attributes.put("gt_m_cty", member.getVersionString());
                break;
            }
            case 16: {
                this.attributes.put("gt_m_avr", member.getVersionString());
                break;
            }
            case 128: {
                this.attributes.put("gt_m_plc", member.getVersionString());
            }
        }
        this.attributes.put("gt_m_xa", member.getXA());
        String timestr = null;
        if (this.timestamp != null) {
            try {
                SimpleDateFormat dfall = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
                dfall.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date dte = this.timestamp.getTime();
                timestr = dfall.format(dte);
            }
            catch (Exception exception) {}
        }
        this.attributes.put("time", timestr);
    }

    public Member(Element member) {
        this.attributes = new HashMap();
        this.dsn = member.getAttribute("dsn").trim();
        this.name = member.getAttribute("name").trim();
        String[] timestampString = member.getAttribute("time").split(" ");
        int i = 0;
        while (i < timestampString.length) {
            if (i == 0) {
                String stringYY = timestampString[i].substring(2, 4);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                try {
                    cal.setTime(sdf.parse(member.getAttribute("time")));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                int intDayOfYear = cal.get(6);
                String stringDayOfYear = Integer.toString(intDayOfYear);
                stringYY = String.valueOf(stringYY) + stringDayOfYear;
                this.selectedDate = Integer.parseInt(stringYY);
                this.timestamp = cal;
            } else {
                String tempTime = timestampString[i].replace(":", "");
                this.selectedTime = Integer.parseInt(tempTime);
            }
            ++i;
        }
        this.attributes.put("name", this.name);
        int lang = 0;
        String langFlag = member.getAttribute("gt_m_lang");
        if (langFlag.equalsIgnoreCase("0X10")) {
            lang = 16;
        } else if (langFlag.equalsIgnoreCase("0X20")) {
            lang = 32;
        } else if (langFlag.equalsIgnoreCase("0X80")) {
            lang = 128;
        }
        String langStr = Integer.toHexString(lang);
        this.attributes.put("gt_m_lang", langStr);
        switch (lang) {
            case 32: {
                this.attributes.put("gt_m_cty", member.getAttribute("version"));
                break;
            }
            case 16: {
                this.attributes.put("gt_m_avr", member.getAttribute("version"));
                break;
            }
            case 128: {
                this.attributes.put("gt_m_plc", member.getAttribute("version"));
            }
        }
        this.attributes.put("gt_m_xa", Integer.toHexString(lang & 0x40));
        String timestr = null;
        if (this.timestamp != null) {
            try {
                SimpleDateFormat dfall = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
                Date dte = this.timestamp.getTime();
                timestr = dfall.format(dte);
            }
            catch (Exception exception) {}
        }
        this.attributes.put("time", timestr);
        this.properties.put("time", member.getAttribute("time"));
        this.properties.put("gt_m_lang", member.getAttribute("gt_m_lang"));
        this.properties.put("dsn", member.getAttribute("dsn"));
        this.properties.put("name", member.getAttribute("name"));
        this.properties.put("version", member.getAttribute("version"));
    }

    public Element xmlMember(XMLFile xml) {
        Element newmember = xml.newMember(this.getName());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            newmember.setAttribute(entry.getKey(), value);
        }
        xml.setDsn(newmember, this.getDsn());
        xml.setName(newmember, this.getName());
        xml.setTimeStamp(newmember, this.getTimeStamp());
        return newmember;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Calendar getTimeStamp() {
        return this.timestamp;
    }

    public void setTimeStamp(Calendar time) {
        this.timestamp = time;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String setAttribute(String name, String value) {
        if (value != null) {
            value = value.replace("\u0000", "");
        }
        if (value == null || value.length() == 0) {
            return this.attributes.remove(name);
        }
        return this.attributes.put(name, value);
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int day) {
        this.date = day;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Calendar timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean monitor) {
        this.monitor = monitor;
    }

    public boolean isStatementTrace() {
        return this.statementTrace;
    }

    public void setStatementTrace(boolean statementTrace) {
        this.statementTrace = statementTrace;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public int getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(int date) {
        this.selectedDate = date;
    }

    public int getSelectedTime() {
        return this.selectedTime;
    }

    public void setSelectedTime(int time) {
        this.selectedTime = time;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

