/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.TreeObjectPropertySource;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class TreeObject
implements IAdaptable,
Cloneable {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final int VARIABLE = 1;
    public static final int LABEL = 2;
    public static final int STRUCTURE = 3;
    protected String name;
    protected String alternateName = null;
    protected int backingdataOffset;
    protected MFAddress backingdataAddress = MFAddress.ZERO_ADDR;
    protected int type = 0;
    protected TreeObject parent;
    protected ByteBuffer backingdata;
    protected ArrayList<TreeObject> children = new ArrayList(1);
    protected HashMap<String, String> attributes = new HashMap(1);
    protected MFAddress address = MFAddress.ZERO_ADDR;
    protected TreeObjectPropertySource propertysource = null;

    public TreeObject(String name, String type) {
        this.name = name == null ? "" : name;
        this.type = this.setType(type);
    }

    public TreeObject(Element element) {
        this.name = element.getAttribute("name");
        this.type = this.setType(element.getTagName());
        NamedNodeMap nodes = element.getAttributes();
        int i = 0;
        while (i < nodes.getLength()) {
            Attr attr = (Attr)nodes.item(i);
            this.setAttribute(attr.getName(), attr.getValue());
            ++i;
        }
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    private int setType(String typeStr) {
        if (typeStr.equals("variables")) {
            return 1;
        }
        if (typeStr.equals("pgmlabel")) {
            return 2;
        }
        if (typeStr.equals("pgmstructure")) {
            return 3;
        }
        return 0;
    }

    public void setParent(TreeObject parent) {
        if (this.parent == null) {
            this.parent = parent;
            if (parent != null && this.type == 1) {
                ByteBuffer tbuff;
                int level = (Integer)Attribute.getValue("level", this);
                int length = (Integer)Attribute.getValue("length", this);
                int evel = (Integer)Attribute.getValue("gt_evel", this);
                if (level > 1 && length > 0 && evel != 88 && evel != 66 && (tbuff = parent.getBackingdata()) != null) {
                    int offset = (Integer)Attribute.getValue("structureoffset", this);
                    offset -= ((Integer)Attribute.getValue("structureoffset", parent)).intValue();
                    try {
                        this.backingdata = ByteBuffer.wrap(tbuff.array(), offset, length);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.backingdata = null;
                    }
                }
            }
        }
    }

    public TreeObject getParent() {
        return this.parent;
    }

    public String toString() {
        String string = this.getAttribute("name");
        return string.length() > 0 ? string : this.getName();
    }

    public void addChild(TreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(TreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public void removeChildTree(TreeObject child) {
        TreeObject[] treeObjectArray = child.getChildren();
        int n = treeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject item = treeObjectArray[n2];
            child.removeChildTree(item);
            ++n2;
        }
        this.removeChild(child);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            if (this.propertysource == null) {
                this.propertysource = new TreeObjectPropertySource(this);
            }
            return this.propertysource;
        }
        return null;
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public Object getValue(String key) {
        return Attribute.getValue((String)key, (String)this.getAttribute(key));
    }

    public String getAttribute(String key) {
        String value = this.attributes.get(key);
        return value == null ? "" : value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TreeObject)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public int getType() {
        return this.type;
    }

    public ByteBuffer getBackingdata() {
        return this.backingdata;
    }

    public void setBackingdata(ByteBuffer bb) {
        this.backingdata = bb;
        if (bb == null) {
            this.setBackingdataAddress(MFAddress.ZERO_ADDR);
            this.setBackingdataOffset(0);
        }
    }

    public void nullBackingdata() {
        this.setBackingdata(null);
        this.setAttribute("isclean", "true");
        for (TreeObject element : this.children) {
            element.nullBackingdata();
        }
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAlternateName(String altname) {
        this.alternateName = altname;
    }

    public String getAlternateName() {
        return this.alternateName;
    }

    public void setBackingdataOffset(int offset) {
        this.backingdataOffset = offset;
    }

    public int getBackingdataOffset() {
        return this.backingdataOffset;
    }

    public void setKeyword(String value) {
        this.setAttribute("DATAVIEW_KEYWORD", value);
    }

    public String getKeyword() {
        String value = this.getAttribute("DATAVIEW_KEYWORD");
        return value.length() == 0 ? null : value;
    }

    protected int getOffset() {
        int offset = (Integer)Attribute.getValue("structureoffset", this);
        if ((offset -= this.getBackingdataOffset()) < 0) {
            offset = 0;
        }
        return offset;
    }

    public Object clone() throws CloneNotSupportedException {
        TreeObject newtree = null;
        newtree = (TreeObject)super.clone();
        newtree.attributes = (HashMap)this.attributes.clone();
        newtree.backingdata = null;
        newtree.backingdataAddress = MFAddress.ZERO_ADDR;
        newtree.address = MFAddress.ZERO_ADDR;
        newtree.children = new ArrayList(this.children.size());
        newtree.parent = null;
        for (TreeObject item : this.children) {
            TreeObject clone = (TreeObject)item.clone();
            clone.setParent(this);
            newtree.children.add(clone);
        }
        return newtree;
    }

    public ByteBuffer reorderBackingdata(ByteBuffer bdata) {
        int lth = 128;
        int jHigh = 0;
        byte[] bytes = new byte[4];
        ByteBuffer newBackingdata = ByteBuffer.wrap(new byte[lth]);
        int i = 0;
        while (i < lth / 2) {
            jHigh = i + lth / 2;
            ((Buffer)newBackingdata).position(i * 2);
            ((Buffer)bdata).position(jHigh);
            bdata.get(bytes);
            newBackingdata.put(bytes);
            ((Buffer)newBackingdata).position(i * 2 + 4);
            ((Buffer)bdata).position(i);
            bdata.get(bytes);
            newBackingdata.put(bytes);
            i += 4;
        }
        return newBackingdata;
    }

    public ByteBuffer restoreBackingdata(ByteBuffer bdata) {
        int lth = 128;
        int jHigh = 0;
        byte[] bytes = new byte[4];
        ByteBuffer oldBackingdata = ByteBuffer.wrap(new byte[lth]);
        int i = 0;
        while (i < lth / 2) {
            jHigh = i + lth / 2;
            ((Buffer)oldBackingdata).position(i);
            ((Buffer)bdata).position(i * 2 + 4);
            bdata.get(bytes);
            oldBackingdata.put(bytes);
            ((Buffer)oldBackingdata).position(jHigh);
            ((Buffer)bdata).position(i * 2);
            bdata.get(bytes);
            oldBackingdata.put(bytes);
            i += 4;
        }
        return oldBackingdata;
    }

    public boolean allChildrenAreIndex() {
        TreeObject[] dependents = this.getChildren();
        if (dependents.length == 0) {
            return false;
        }
        TreeObject[] treeObjectArray = dependents;
        int n = dependents.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject tree = treeObjectArray[n2];
            String ix = tree.getAttribute("gt_dstyp");
            if (!ix.equals("f0")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public MFAddress getAddress() {
        return this.address;
    }

    public void setAddress(MFAddress address) {
        this.address = address;
    }

    public MFAddress getBackingdataAddress() {
        return this.backingdataAddress;
    }

    public void setBackingdataAddress(MFAddress backingdataAddress) {
        this.backingdataAddress = backingdataAddress;
    }

    public String getHexString() {
        ByteBuffer bb = this.getBackingdata();
        if (bb != null) {
            byte[] ebytes = new byte[bb.limit()];
            ((Buffer)bb).position(0);
            bb.get(ebytes);
            String str = HexUtil.toHex((byte[])ebytes);
            return str;
        }
        return "";
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }
}

