/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.MemoryUpdate;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Numbers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.w3c.dom.Element;

public abstract class Variable
extends TreeObject {
    private static final String UNDERFLOW_FORMAT = Messages.Variable_0;
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String CORE_WORD = "Memory";
    public static final String NOT_AVAILABLE = Messages.Variable_23;
    public static final String GROUP_LEVEL = Messages.Variable_3;
    public static final String NOT_DISPLAYABLE = Messages.Variable_4;
    public static final String NOT_VARIABLE = Messages.Variable_5;
    public static final String NA = Messages.Variable_6;
    public static final String CORE = "(Memory Expression)";
    public static final String KEYWORD = Messages.Variable_9;
    public Integer baseoffset;
    private Integer datasize = null;
    protected DataType datatype = null;
    protected Integer decimalpoint = new Integer(0);
    protected Integer length = new Integer(0);
    protected Integer level = new Integer(0);
    protected String picture = null;
    protected StorageType storagetype = null;
    protected boolean isVarying = false;

    public Variable(Element element) throws ITException {
        super(element);
        if (this.getType() != 1) {
            throw new ITException(Messages.Variable_10);
        }
        this.length = (Integer)Attribute.getValue((String)"length", (Element)element);
        this.baseoffset = (Integer)Attribute.getValue((String)"structureoffset", (Element)element);
        this.level = (Integer)Attribute.getValue((String)"level", (Element)element);
    }

    public int getDatasize() {
        if (this.datasize == null) {
            this.setDatasize();
        }
        return this.datasize;
    }

    public int getEditSize() {
        int size = this.getDatasize();
        switch (this.datatype) {
            case SIGNED: 
            case UNSIGNED: {
                return size + 2;
            }
        }
        return size;
    }

    public DataType getDatatype() {
        if (this.datatype == null) {
            this.setDatatype();
        }
        return this.datatype;
    }

    public int getDecimalpoint() {
        return this.decimalpoint;
    }

    public abstract String getDisplayValue() throws Exception;

    public String getValue(byte[] ebytes) throws Exception {
        this.setDatasize();
        if (ebytes == null) {
            return "";
        }
        switch (this.datatype) {
            case SIGNED: 
            case UNSIGNED: {
                BigDecimal decimal;
                switch (this.storagetype) {
                    case PACK: {
                        decimal = new BigDecimal(Numbers.unpack((byte[])ebytes));
                        break;
                    }
                    case DISPLAY: 
                    case DISPLAY_SIGNED_LEFT: 
                    case DISPLAY_SIGNED_SEPARATE: 
                    case DISPLAY_SIGNED_SEPARATE_LEFT: {
                        decimal = Numbers.formatDisplayNumber((byte[])ebytes);
                        break;
                    }
                    default: {
                        decimal = new BigDecimal(new BigInteger(ebytes));
                    }
                }
                if (this.decimalpoint != 0) {
                    decimal = decimal.movePointLeft(this.decimalpoint);
                }
                String result = decimal.toPlainString();
                if (this.datatype == DataType.SIGNED && decimal.signum() == 1) {
                    return "+" + result;
                }
                return result;
            }
            case INDEX: {
                BigDecimal idxDecimal = new BigDecimal(new BigInteger(ebytes));
                int denominator = (Integer)Attribute.getValue("gt_fsiz", this) + 1;
                Integer val = idxDecimal.intValue() / denominator + 1;
                return val.toString();
            }
        }
        if (this.decimalpoint != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(HexUtil.toString((byte[])ebytes, (boolean)true));
            sb.insert(sb.length() - this.decimalpoint, '.');
            return sb.toString();
        }
        String value = this.varyCheck(HexUtil.toString((byte[])ebytes, (boolean)true), true);
        return value;
    }

    public abstract String varyCheck(String var1, boolean var2);

    public String getEditValue() throws Exception {
        return this.getValue(this.getData());
    }

    public String getHexValue(byte[] bytes) {
        if (bytes == null) {
            return NOT_AVAILABLE;
        }
        return this.length < 9 ? HexUtil.toHex((byte[])bytes, (int)this.length) : HexUtil.toHex((byte[])bytes);
    }

    public String getHexValue() {
        return this.getHexValue(this.getData());
    }

    public byte[] getData() {
        if (this.backingdata != null) {
            try {
                ((Buffer)this.backingdata).position(this.getOffset());
                int bblength = this.length;
                if (bblength > this.backingdata.remaining()) {
                    bblength = this.backingdata.remaining();
                    Logger.loggit(4, String.format(UNDERFLOW_FORMAT, this.getName()));
                }
                byte[] bytes = new byte[bblength];
                this.backingdata.get(bytes);
                return bytes;
            }
            catch (Exception e) {
                Logger.loggit(e);
                return null;
            }
        }
        return null;
    }

    public int getLength() {
        return this.length;
    }

    public int getLenth() {
        return this.length;
    }

    public String getPicture() {
        if (this.picture == null) {
            this.picture = ((String)Attribute.getValue("gt_pic", this)).toUpperCase();
        }
        return this.picture;
    }

    public StorageType getStoragetype() {
        return this.storagetype;
    }

    public abstract boolean canEditDisplay();

    public abstract boolean canEditHex();

    public boolean updateHexValue(debugSession session, String hexvalue) {
        try {
            if (this.validateHexValue(hexvalue)) {
                byte[] newvalue;
                String str = this.checkRestoreOrder(session, hexvalue);
                if (str != null) {
                    hexvalue = str;
                }
                if ((newvalue = HexUtil.HextoBytes((String)hexvalue)).length < this.length) {
                    newvalue = HexUtil.sizeBytes((byte[])newvalue, (int)this.length);
                }
                MemoryUpdate memory = new MemoryUpdate(session);
                memory.sendMemoryUpdateMessage(HexUtil.toHex((byte[])newvalue, (int)0), HexUtil.toHex((byte[])this.getData(), (int)0), this.address);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return true;
    }

    public String checkRestoreOrder(debugSession session, String value) {
        if (this.level == 1 && "REGS".equals(this.getKeyword()) && session.isBatch() && value.length() == 256) {
            byte[] ebytes = new byte[128];
            HexUtil.HextoBytes((String)value, (byte[])ebytes);
            ByteBuffer bb = ByteBuffer.wrap(ebytes);
            return HexUtil.toHex((byte[])this.restoreBackingdata(bb).array(), (int)256);
        }
        return null;
    }

    public boolean updateValue(debugSession session, String value) throws Exception {
        if (this.validateValue(value)) {
            return this.updateHexValue(session, HexUtil.toHex((byte[])this.getBytesFromString(value, this.getData()), (int)0));
        }
        return false;
    }

    public boolean validateHexValue(String hexvalue) throws Exception {
        byte[] bytes = HexUtil.HextoBytes((String)hexvalue);
        if (bytes != null && bytes.length <= this.length) {
            return true;
        }
        throw new ITException(Messages.Variable_16);
    }

    public boolean validateValue(String value) throws Exception {
        String str;
        if (value == null) {
            throw new ITException(Messages.Variable_17);
        }
        try {
            str = this.getDisplayValue();
        }
        catch (Exception exception) {
            str = "";
        }
        if (value.equals(str)) {
            return true;
        }
        switch (this.datatype) {
            case SIGNED: 
            case UNSIGNED: {
                BigDecimal result = Numbers.formatNumber((String)value);
                boolean valid = Numbers.validateNumber((BigDecimal)result, (int)this.decimalpoint, (int)this.getDatasize(), (this.datatype == DataType.SIGNED ? 1 : 0) != 0);
                if (valid && this.storagetype == StorageType.BIN) {
                    result = new BigDecimal(result.unscaledValue());
                    switch (this.length) {
                        case 1: {
                            result.byteValueExact();
                            break;
                        }
                        case 2: {
                            result.shortValueExact();
                            break;
                        }
                        case 4: {
                            result.intValueExact();
                            break;
                        }
                        default: {
                            result.longValueExact();
                        }
                    }
                }
                return valid;
            }
        }
        if (HexUtil.rightTrim((String)value).length() > this.getDatasize()) {
            throw new ITException(Messages.Variable_19);
        }
        return true;
    }

    public byte[] getBytesFromString(String value, byte[] inbytes) throws Exception {
        byte[] bytes = null;
        this.validateValue(value);
        boolean signed = this.datatype == DataType.SIGNED;
        block0 : switch (this.datatype) {
            case INDEX: {
                int multiplier = (Integer)Attribute.getValue("gt_fsiz", this) + 1;
                Integer idx = Integer.valueOf(value) - 1;
                idx = idx * multiplier;
                bytes = HexUtil.HextoBytes((String)HexUtil.toHex((int)idx));
                break;
            }
            case SIGNED: 
            case UNSIGNED: {
                BigDecimal result = Numbers.formatNumber((String)value);
                result = result.setScale(this.decimalpoint);
                result.setScale(this.decimalpoint);
                BigInteger integer = result.unscaledValue();
                switch (this.storagetype) {
                    case PACK: {
                        bytes = Numbers.pack((BigInteger)integer, (int)this.length, (boolean)signed);
                        break block0;
                    }
                    case DISPLAY: {
                        bytes = Numbers.buildDisplayNumber((BigInteger)integer, (int)this.length, (boolean)true);
                        break block0;
                    }
                    case DISPLAY_SIGNED_LEFT: {
                        bytes = Numbers.buildDisplayNumber((BigInteger)integer, (int)this.length, (boolean)false);
                        break block0;
                    }
                    case DISPLAY_SIGNED_SEPARATE: {
                        bytes = Numbers.buildDisplayNumberSeparate((BigInteger)integer, (int)(this.length - 1), (boolean)true);
                        break block0;
                    }
                    case DISPLAY_SIGNED_SEPARATE_LEFT: {
                        bytes = Numbers.buildDisplayNumberSeparate((BigInteger)integer, (int)(this.length - 1), (boolean)false);
                        break block0;
                    }
                    case BIN: {
                        String hexstr;
                        String str = HexUtil.toHex((byte[])integer.toByteArray());
                        char ch = value.charAt(0);
                        int lth = str.length() / 2;
                        String pad = "00";
                        if (ch == '-') {
                            pad = "FF";
                        }
                        if (lth < inbytes.length) {
                            StringBuffer sb = new StringBuffer();
                            int i = inbytes.length;
                            while (i > lth) {
                                sb.append(pad);
                                --i;
                            }
                            hexstr = String.valueOf(sb.toString()) + str;
                        } else {
                            hexstr = str;
                        }
                        bytes = HexUtil.HextoBytes((String)hexstr);
                        break block0;
                    }
                }
                bytes = HexUtil.sizeBytes((byte[])integer.toByteArray(), (int)this.length);
                break;
            }
            default: {
                String string = !this.isVarying ? HexUtil.spaceFill((String)value, (int)this.length) : this.varyCheck(value, false);
                if (inbytes == null) {
                    inbytes = this.getData();
                }
                HexUtil.StringtoBytes((String)string, (byte[])inbytes);
                bytes = inbytes;
            }
        }
        return bytes;
    }

    @Override
    protected int getOffset() {
        int offset = this.baseoffset;
        return (offset -= this.getBackingdataOffset()) < 0 ? 0 : offset;
    }

    protected void setDatasize() {
        if (this.datatype == null) {
            this.setDatatype();
        }
        this.decimalpoint = new Integer(0);
        switch (this.datatype) {
            case ALPHA: {
                this.decimalpoint = this.getSigFigRight();
            }
            default: {
                this.datasize = new Integer(this.length);
                break;
            }
            case INDEX: 
            case POINTER: {
                this.datasize = Numbers.IntSize;
                break;
            }
            case SIGNED: 
            case UNSIGNED: {
                block5 : switch (this.storagetype) {
                    case BIN: {
                        switch (this.length) {
                            case 1: {
                                this.datasize = Numbers.ByteSize;
                                break block5;
                            }
                            case 2: {
                                this.datasize = Numbers.ShortSize;
                                break block5;
                            }
                            case 4: {
                                this.datasize = Numbers.IntSize;
                                break block5;
                            }
                        }
                        this.datasize = Numbers.LongSize;
                        break;
                    }
                    case PACK: {
                        this.datasize = this.length * 2 - 1;
                        break;
                    }
                    case DISPLAY_SIGNED_SEPARATE: 
                    case DISPLAY_SIGNED_SEPARATE_LEFT: {
                        this.datasize = this.length - 1;
                        break;
                    }
                    default: {
                        this.datasize = this.length;
                    }
                }
                this.decimalpoint = this.getSigFigRight();
            }
        }
    }

    protected abstract int getSigFigRight();

    protected abstract void setDatatype();

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static enum DataType {
        ALPHA,
        ARRAY,
        GROUP,
        INDEX,
        POINTER,
        SIGNED,
        UNSIGNED,
        FLOAT,
        GRAPHIC,
        BIT,
        UNKNOWN;

    }

    public static enum StorageType {
        CHAR,
        BIN,
        PACK,
        HEX,
        INTERNAL,
        EXTERNAL,
        DISPLAY,
        DISPLAY_SIGNED_LEFT,
        DISPLAY_SIGNED_SEPARATE,
        DISPLAY_SIGNED_SEPARATE_LEFT;

    }
}

