/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.tools.BacktraceLogMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLTraceUtils {
    private static Document document;
    private static NodeList programList;

    public static String loadTraceData(String filename, debugSession session) {
        int length;
        NodeList statementList;
        ArrayList<String> lineList;
        block8: {
            if (filename == null || filename.isEmpty()) {
                return null;
            }
            lineList = new ArrayList<String>();
            File file = new File(filename);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
            session.clearTracelogs();
            programList = document.getElementsByTagName("ProgramName");
            statementList = document.getElementsByTagName("Statement");
            length = programList.getLength();
            if (programList != null && statementList != null && length > 0) break block8;
            return null;
        }
        try {
            int i = 0;
            while (i < length) {
                if (programList.item(i) != null && statementList.item(i) != null) {
                    String programName = programList.item(i).getTextContent();
                    String statement = statementList.item(i).getTextContent();
                    BacktraceLogMessage dummyLog = new BacktraceLogMessage();
                    BacktraceLogMessage.TraceLogRecord dummyRecord = new BacktraceLogMessage.TraceLogRecord(dummyLog);
                    dummyRecord.program = programName;
                    dummyRecord.firstStatement = Integer.parseInt(statement);
                    session.addRecordToTracelog(dummyRecord);
                    lineList.add(String.valueOf(programName) + " " + statement);
                }
                ++i;
            }
            session.setLinelistTracelog(lineList);
            return programList.item(0).getTextContent();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
            IT_ErrorDialog.openError(0, "Error", "Could not open file, incorrect file format", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveTraceData(File file, debugSession session) {
        int i = 1;
        try {
            ArrayList<BacktraceLogMessage.TraceLogRecord> traceLogList = session.getTracelog();
            if (traceLogList == null) {
                return;
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("Records");
            doc.appendChild(rootElement);
            for (BacktraceLogMessage.TraceLogRecord record : traceLogList) {
                Element staff = doc.createElement("Order");
                rootElement.appendChild(staff);
                Attr attr = doc.createAttribute("id");
                attr.setValue(Integer.toString(i++));
                staff.setAttributeNode(attr);
                Element firstname = doc.createElement("ProgramName");
                firstname.appendChild(doc.createTextNode(record.program));
                staff.appendChild(firstname);
                Element lastname = doc.createElement("Statement");
                lastname.appendChild(doc.createTextNode(Integer.toString(record.firstStatement)));
                staff.appendChild(lastname);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            transformer.transform(source, result);
            System.out.println("Done Saving Trace Data");
        }
        catch (TransformerException tfe) {
            tfe.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static Set<String> getProgramName() {
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
        programList = document.getElementsByTagName("ProgramName");
        int i = 0;
        while (i < programList.getLength()) {
            String name = programList.item(i).getTextContent();
            nameSet.add(name);
            ++i;
        }
        return nameSet;
    }
}

