/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.WSConnection;
import com.ca.intertest.tools.DebugMessage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DebugCICSSessionJob
extends Job {
    private debugSession session;
    private WSConnection connection;

    public DebugCICSSessionJob(String name, debugSession session, WSConnection connection) {
        super(name);
        this.session = session;
        this.connection = connection;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            int ticks = this.session.getChildren().length + 1;
            monitor.beginTask(Messages.DebugCICSSessionJob_0, ticks);
            this.session.setDebug();
            this.session.postSnapshot(null, false);
            this.session.buildBreakpointQueue();
            monitor.worked(1);
            monitor.setTaskName(Messages.DebugCICSSessionJob_1);
            this.session.post(monitor);
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)new InitMessage(this.session));
            debugEvent event = new debugEvent((Object)cvmi, null);
            this.session.fireDebugMessageListeners(event);
        }
        catch (Exception e) {
            return new Status(4, Messages.StartDebugAction_Title, Messages.StartDebugAction_Reason_text, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        super.canceling();
        this.connection.notifyClient();
    }
}

