/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.SynchSymbolic2;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.IWebSocketClient;
import com.ca.intertest.server.IntertestWebSocketClient;
import com.ca.intertest.server.ServiceConnection;
import com.ca.intertest.tools.BackStepMessage;
import com.ca.intertest.tools.BreakMessage;
import com.ca.intertest.tools.DSECT;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.EndTaskMessage;
import com.ca.intertest.tools.ExecuteMessage;
import com.ca.intertest.tools.IStatusMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.SynchSymbolicMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import com.ca.intertest.tools.TerminateProgramMessage;
import java.io.IOException;
import java.util.Formatter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class DebugTalker
implements Runnable,
IWebSocketClient {
    static final String cacopyright = "Copyright ? 2017 CA";
    private static final int TIMEOUT = 1000;
    private boolean more = true;
    private debugSession session = null;
    private debugFile debugfile;
    private debugFile prior_debugfile;
    private BreakMessage breakmessage;
    private BreakpointMarker bpmarker;
    private boolean waiting = true;
    private CVMO breakpointCVMO = null;
    private static final Debug debug = Debug.getInstance();
    private boolean goodbyeSent = false;
    private String connectionID = Messages.DebugTalker_0;
    final int count = 0;
    final int error = 0;
    boolean displayWindow = true;
    private IntertestWebSocketClient client = null;
    private boolean lastMessage = false;

    public DebugTalker() {
        Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
    }

    public DebugTalker(CVMO cvmo) {
        this();
        this.breakpointCVMO = cvmo;
    }

    public DebugTalker(debugSession session) {
        this();
        this.session = session;
    }

    @Override
    public void setClient(IntertestWebSocketClient client) {
        this.client = client;
        this.connectionID = client.getSessionId();
    }

    private void readFirstPacket() {
        try {
            this.lastMessage = false;
            this.waiting = false;
            this.displayWindow = true;
            if (this.breakpointCVMO != null) {
                Connection.processStatusMessages(null, this.breakpointCVMO);
                this.bpmarker = null;
                Display display = Display.getDefault();
                DebugMessage[] messages = this.breakpointCVMO.getMessages();
                int count = 0;
                while (count < messages.length) {
                    DebugMessage msg = messages[count];
                    switch (msg.getMessageID()) {
                        case 1: {
                            this.breakmessage = (BreakMessage)msg;
                            this.setupSession(this.breakmessage.getSessionID());
                            if (this.session != null) {
                                if (this.session.isBatch()) {
                                    boolean neverstopped = true;
                                    for (debugFile item : this.session.getMonitored(true)) {
                                        if (!item.isEntered()) continue;
                                        neverstopped = false;
                                        break;
                                    }
                                    if (neverstopped && this.breakmessage.getSubmessageID() == 6) {
                                        this.displayWindow = false;
                                    }
                                }
                                Logger.loggit(0, String.format(Messages.DebugTalker_33, this.session.getName(), this.breakmessage.getText()));
                                this.session.setTalker(this);
                                final debugEvent event = new debugEvent((Object)this.breakpointCVMO, this);
                                String progid = String.valueOf(this.breakmessage.getProgram()) + ".intertest";
                                this.debugfile = this.getFile(progid, true, false, this.breakmessage.getDate(), this.breakmessage.getTime(), this.breakmessage.getDSName(), this.breakmessage.getLongText());
                                this.session.setMemoryUpdatePassword("");
                                if (this.debugfile != null) {
                                    boolean stop = true;
                                    if (this.session.isBatch()) {
                                        if (!this.debugfile.isEntered()) {
                                            if (!(this.session.isFirstModule() || this.breakmessage.getSubmessageID() != 1 && this.breakmessage.getSubmessageID() != 4)) {
                                                stop = this.debugfile.hasInitialBreakpoint();
                                                this.session.fireDebugMessageListenersForVisualDebugger(event);
                                            }
                                            this.debugfile.setEntered(true);
                                            this.session.addBreakpoints(this.debugfile);
                                            this.session.post(null);
                                        } else if (this.breakmessage.getSubmessageID() == 4) {
                                            if (this.breakmessage.getBreakpointID() == 128L) {
                                                stop = this.debugfile.hasInitialBreakpoint();
                                            }
                                            this.session.fireDebugMessageListenersForVisualDebugger(event);
                                        }
                                    } else {
                                        boolean statementTraceForAutomaticallyAddedPrograms;
                                        this.debugfile.setEntered(true);
                                        if (!this.debugfile.isManuallyAddedProgram() && (statementTraceForAutomaticallyAddedPrograms = this.session.isDefaultStatementTraceForAutomaticallyAddedPrograms()) != this.debugfile.isStatementTrace()) {
                                            this.debugfile.setStatementTrace(statementTraceForAutomaticallyAddedPrograms);
                                        }
                                    }
                                    switch (this.breakmessage.getType()) {
                                        case 4: {
                                            String text;
                                            if (!this.session.isBatch() || !(text = this.breakmessage.getLongText()).equals(BreakMessage.names[4])) break;
                                            this.breakmessage.setText(BreakMessage.names[1]);
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            String text;
                                            long ID = this.breakmessage.getBreakpointID();
                                            if (ID == 0L) break;
                                            this.bpmarker = this.debugfile.getBreakpointMarkerbyID(ID);
                                            if (this.bpmarker == null || (text = this.bpmarker.getAttribute("message").toString()) == null || text.length() <= 0) break;
                                            this.breakmessage.setText(text);
                                        }
                                    }
                                    if (this.breakmessage.isDummyBreakpoint()) {
                                        stop = false;
                                        this.session.fireDebugMessageListenersDummy(event);
                                    }
                                    if (stop) {
                                        if (display != null) {
                                            display.syncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                                    Shell shell = window.getShell();
                                                    shell.setMinimized(false);
                                                    shell.forceActive();
                                                    shell.forceFocus();
                                                    if (DebugTalker.this.breakmessage != null && DebugTalker.this.breakmessage.getSubmessageID() == 6 && DebugTalker.this.displayWindow) {
                                                        Status status = new Status(4, "com.ca.intertest", 32, Messages.DebugTalker_7, null);
                                                        ErrorDialog.openError((Shell)window.getShell(), (String)Messages.DebugTalker_8, (String)DebugTalker.this.breakmessage.getText(), (IStatus)status);
                                                    }
                                                    try {
                                                        IWorkbenchPage page = window.getActivePage();
                                                        page.showView("com.ca.intertest.ui.views.debug");
                                                        if (DebugTalker.this.debugfile != null) {
                                                            page.openEditor((IEditorInput)new FileEditorInput((IFile)DebugTalker.this.debugfile.getResource()), "com.ca.intertest.ui.lister");
                                                        } else {
                                                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.DebugTalker_9, (String)String.format(Messages.DebugTalker_10, DebugTalker.this.breakmessage.getProgram()));
                                                        }
                                                    }
                                                    catch (PartInitException partInitException) {}
                                                }
                                            });
                                        }
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                DebugTalker.this.session.fireDebugMessageListeners(event);
                                                DebugTalker.this.debugfile.fireDebugMessageListeners(event);
                                            }
                                        });
                                    } else {
                                        ExecuteMessage message = new ExecuteMessage();
                                        message.setMessageID((short)10);
                                        message.setProgram(this.breakmessage.getProgram());
                                        message.setStatement(this.breakmessage.getStatement());
                                        this.processExecute(message);
                                    }
                                } else {
                                    this.session.fireDebugMessageListeners(event);
                                }
                            } else {
                                Logger.loggit(8, Messages.DebugTalker_11);
                            }
                            Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
                            return;
                        }
                        case 45: {
                            if (this.session.isBatch()) {
                                SynchronizeMessage synchronizeMessage = (SynchronizeMessage)msg;
                                this.session.setUID(synchronizeMessage.getSessionID());
                                this.setSynchMessageBatch(synchronizeMessage);
                            }
                            return;
                        }
                        case 4: {
                            boolean warn;
                            boolean notify = true;
                            boolean monitored = false;
                            final EndTaskMessage endtaskmessage = (EndTaskMessage)msg;
                            this.setupSession(endtaskmessage.getSessionID());
                            Logger.loggit(0, String.format(Messages.DebugTalker_12, this.connectionID));
                            if (this.session != null) {
                                Object[] files;
                                this.session.setTalker(this);
                                this.session.setMemoryUpdatePassword("");
                                for (debugFile item : this.session.getMonitored(true)) {
                                    if (!item.isEntered()) continue;
                                    monitored = true;
                                    break;
                                }
                                this.more = false;
                                this.session.endSession();
                                CVMO tempcvmo = new CVMO();
                                tempcvmo.addMessage(msg);
                                debugEvent event = new debugEvent((Object)tempcvmo, this);
                                Object[] objectArray = files = this.session.getChildren();
                                int n = files.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object item = objectArray[n2];
                                    ((debugFile)item).fireDebugMessageListeners(event);
                                    ++n2;
                                }
                                String value = this.session.getStore().getString("settingsNotifyEOJ");
                                notify = value == null || value.length() == 0 ? true : Boolean.parseBoolean(value);
                            }
                            if (this.breakpointCVMO.getErrorLevel() > 0) {
                                Connection.displayError(this.breakpointCVMO, Messages.DebugTalker_14);
                            }
                            boolean bl = warn = !monitored;
                            if ((warn || notify || this.breakpointCVMO.getErrorLevel() > 0) && display != null) {
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                        window.getShell().forceActive();
                                        window.getShell().forceFocus();
                                        String rc_text = endtaskmessage.getReturncode() == 65535 ? String.valueOf(IConstants.LINEFEED) + IConstants.LINEFEED + endtaskmessage.getAbendMessage() : String.format(Messages.DebugTalker_15, endtaskmessage.getReturncode());
                                        if (warn) {
                                            MessageDialog.openWarning((Shell)window.getShell(), (String)Messages.DebugTalker_16, (String)(String.valueOf(Messages.DebugTalker_17) + rc_text));
                                        } else {
                                            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.DebugTalker_16, (String)(String.valueOf(Messages.DebugTalker_19) + rc_text));
                                        }
                                    }
                                });
                            }
                            Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
                            return;
                        }
                    }
                    ++count;
                }
            }
            Logger.loggit(32, Messages.DebugTalker_20);
        }
        catch (ITException iTException) {
            this.more = false;
        }
        catch (Exception e) {
            Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
            Logger.loggit(e);
            this.more = false;
            this.waiting = false;
        }
        if (this.session != null && this.session.isBatch()) {
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)new EndTaskMessage());
            debugEvent event = new debugEvent((Object)cvmi, this);
            this.session.fireDebugMessageListeners(event);
        }
    }

    private void setupSession(Integer sessionID) {
        if (this.session == null) {
            this.session = debug.getSession(sessionID);
        }
        if (this.session.getTalker() == null || this.session.getTalker().equals(this)) {
            return;
        }
        Logger.loggit(0, Messages.DebugTalker_21);
        while (this.session.getTalker() != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Logger.loggit(0, Messages.DebugTalker_22);
    }

    @Override
    public void run() {
        while (this.more) {
            if (this.isWaiting()) {
                this.readFirstPacket();
            }
            try {
                Thread.sleep(1000L);
                if (this.client != null && this.client.isConnected() || this.lastMessage) continue;
                this.more = false;
            }
            catch (InterruptedException interruptedException) {
                this.more = false;
            }
        }
        this.Shutdown();
        if (this.isWaiting() || this.isActive()) {
            this.sayGoodbye();
        }
        Logger.logPacket(this, DebugTalker.class, new Throwable(), this.connectionID);
    }

    private CVMI sayGoodbye() {
        CVMI cvmi = null;
        if (this.session != null && !this.goodbyeSent) {
            this.Shutdown();
            this.goodbyeSent = true;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)Messages.DebugTalker_25, (String)Messages.DebugTalker_26);
                }
            });
            if (this.session.isBatch()) {
                this.session.suspendSession();
            } else {
                FileServer server = this.session.getServer();
                ServiceConnection connection = new ServiceConnection(server);
                boolean active = connection.isActive();
                connection.disconnect();
                if (!active) {
                    this.session.suspendSession();
                } else {
                    cvmi = new CVMI();
                    try {
                        TerminateProgramMessage message = new TerminateProgramMessage();
                        message.setProgram(this.getBreakmessage().getProgram());
                        cvmi.addMessage((DebugMessage)message);
                        this.notifyExecute(cvmi);
                    }
                    catch (ITException e) {
                        Logger.loggit(e);
                    }
                }
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            try {
                IViewPart view = page.showView("com.ca.intertest.ui.views.debug");
                if (view instanceof IShowInTarget) {
                    ShowInContext context = new ShowInContext((Object)this.debugfile, null);
                    ((IShowInTarget)view).show(context);
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        return cvmi;
    }

    private debugFile getFile(String progid, boolean monitor, boolean post, int date, int time, String DSN, String reasonText) {
        debugFile file = null;
        if (DSN == null || DSN.length() == 0) {
            DSN = this.getDSN(progid);
        }
        if (DSN.length() != 0 && (file = this.session.getFile(progid)) != null && file.equals(this.prior_debugfile)) {
            return this.prior_debugfile;
        }
        if (file == null) {
            this.prior_debugfile = this.session.refreshFile(progid, DSN, true, post, true, date, time, reasonText);
        } else {
            ResourceProperty store = file.getStore();
            int filedate = (Integer)Attribute.getValue("gt_m_jul", store);
            int filetime = (Integer)Attribute.getValue("gt_m_tim", store);
            if (filedate == date && filetime == time) {
                file.setMonitor(true);
                this.prior_debugfile = file;
            } else {
                this.prior_debugfile = this.session.refreshFile(progid, DSN, true, true, post, date, time, reasonText);
            }
        }
        return this.prior_debugfile;
    }

    private String getDSN(String progid) {
        CVMO cvmo;
        block7: {
            CVMI cvmi = new CVMI();
            SynchSymbolicMessage sychrequest = new SynchSymbolicMessage();
            sychrequest.setSubmessageID((short)5);
            sychrequest.setProgram(progid);
            cvmi.addMessage((DebugMessage)sychrequest);
            cvmo = this.process(cvmi);
            if (cvmo.getErrorLevel() == 0) break block7;
            Connection.displayError(cvmo, Messages.DebugTalker_1);
            return "";
        }
        try {
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage message = debugMessageArray[n2];
                if (message.getMessageID() == 45) {
                    SynchronizeMessage.SynchProtsym prot;
                    SynchronizeMessage synchmsg = (SynchronizeMessage)message;
                    Logger.loggit(0, String.format("Synchronize %s in %s", synchmsg.getProgram(), this.session.getName()));
                    if (synchmsg.getProtsyms().size() == 1 && (prot = (SynchronizeMessage.SynchProtsym)synchmsg.getProtsyms().get(0)).isExact()) {
                        return prot.getDSN();
                    }
                    break;
                }
                ++n2;
            }
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return "";
    }

    public void Shutdown() {
        if (this.session != null && this.session.isBatch()) {
            ((debugBatchSession)this.session).setSToken(null);
        }
        Logger.loggit(0, String.format(Messages.DebugTalker_27, this.connectionID));
        try {
            try {
                if (this.client != null && this.client.isConnected()) {
                    this.client.disconnect();
                }
            }
            catch (IOException iOException) {
                this.more = false;
                this.waiting = false;
                this.client = null;
            }
        }
        finally {
            this.more = false;
            this.waiting = false;
            this.client = null;
        }
    }

    public synchronized void processExecute(ExecuteMessage message) {
        this._processExecute((DebugMessage)message);
    }

    public synchronized void processExecute(BackStepMessage message) {
        this._processExecute((DebugMessage)message);
    }

    private synchronized void _processExecute(DebugMessage message) {
        CVMI cvmi = new CVMI();
        cvmi.addMessage(message);
        this.processExecute(cvmi);
    }

    public synchronized void processExecute(CVMI cvmi) {
        IStatusMessage statusMsg;
        String text;
        int ix;
        DebugMessage cvmoMsg;
        DebugMessage cvmiMsg;
        CVMO cvmo = new CVMO();
        if (this.isWaiting()) {
            Logger.loggit(8, Messages.DebugTalker_29);
        }
        try {
            short msgId = cvmi.getLastMessage().getMessageID();
            switch (msgId) {
                case 9: 
                case 17: 
                case 22: {
                    this.client.processNonBlocking(cvmi);
                    break;
                }
                default: {
                    if (this.session.isBatch()) {
                        this.client.setMessagetrap();
                    }
                    cvmo = this.client.processBlocking(cvmi);
                    this.lastMessage = true;
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            cvmi = this.sayGoodbye();
            this.Shutdown();
        }
        if (cvmo.getErrorLevel() != 0 && this.session != null) {
            cvmi = this.sayGoodbye();
        }
        if ((cvmiMsg = cvmi.getMessage(1)) instanceof ExecuteMessage && cvmiMsg.getSubmessageID() != 0 && (cvmoMsg = cvmo.getMessage(1)) instanceof IStatusMessage && (ix = (text = (statusMsg = (IStatusMessage)cvmoMsg).getMessage()).indexOf(":")) != -1) {
            text = text.substring(ix + 1).trim();
            MessageDialog.openWarning(null, (String)"Step Warning", (String)text);
            return;
        }
        if (this.session.isCICS()) {
            this.Shutdown();
        }
        this.breakmessage = null;
        this.notifyExecute(cvmi);
        if (this.session.isBatch()) {
            cvmo.deleteStatusMessage();
            this.breakpointCVMO = cvmo;
            DebugMessage msg = cvmi.getMessage(1);
            switch (msg.getMessageID()) {
                case 9: 
                case 17: 
                case 22: {
                    this.Shutdown();
                    break;
                }
                default: {
                    this.waiting = true;
                }
            }
        }
    }

    private void notifyExecute(CVMI cvmi) {
        debugEvent event = new debugEvent((Object)cvmi, this);
        this.session.fireDebugMessageListeners(event);
        if (this.debugfile != null) {
            this.debugfile.fireDebugMessageListeners(event);
        }
    }

    public synchronized CVMO process(CVMI cvmi) throws Exception {
        if (cvmi == null || cvmi.size() == 0) {
            return null;
        }
        Logger.DisplayPacket((DSECT)cvmi, new Throwable());
        CVMO cvmo = null;
        try {
            cvmo = this.client.processBlocking(cvmi);
            Connection.processStatusMessages(cvmi, cvmo);
            return cvmo;
        }
        catch (Exception e) {
            this.process(this.sayGoodbye());
            throw e;
        }
    }

    public boolean isActive() {
        return this.client != null && this.client.isConnected() && this.more && this.breakmessage != null;
    }

    public int getBreakType() {
        return this.breakmessage == null ? -1 : (int)this.breakmessage.getSubmessageID();
    }

    public debugFile getDebugfile() {
        return this.debugfile;
    }

    public BreakMessage getBreakmessage() {
        return this.breakmessage;
    }

    public synchronized boolean isWaiting() {
        return this.waiting;
    }

    public BreakpointMarker getBpmarker() {
        return this.bpmarker;
    }

    public String toString() {
        Formatter format = new Formatter();
        format.format(Messages.DebugTalker_30, super.toString(), this.client == null ? Messages.DebugTalker_31 : Messages.DebugTalker_18);
        if (this.session != null) {
            format.format(Messages.DebugTalker_32, this.session.getName(), this.session.getUID());
        }
        String result = format.toString();
        format.close();
        return result;
    }

    public CVMO getBreakpointCVMO() {
        return this.breakpointCVMO;
    }

    public void setBreakpointCVMO(CVMO breakpointCVMO) {
        this.breakpointCVMO = breakpointCVMO;
    }

    private void setSynchMessageBatch(SynchronizeMessage snm) {
        String errorMsg = null;
        SynchSymbolic2 synch = null;
        try {
            synch = new SynchSymbolic2(snm, this.session, null);
        }
        catch (ITException e) {
            e.printStackTrace();
        }
        CVMI synchFileCVMI = synch.synchronizeFile(errorMsg);
        this.session.getConnection().process(synchFileCVMI);
    }
}

