/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.ExecutionCountsMessage;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.RequestBreakpointMessage;
import com.ca.intertest.debug.SetBacktraceMessage;
import com.ca.intertest.debug.StatusMessage;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.SETBKPMessage;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

abstract class QueueBreakpoints
implements IDebugListener,
IPropertyChangeListener {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    protected static final int RBP = 1;
    protected static final int WATCH = 2;
    protected static final int LINE = 3;
    protected static final int CBP = 4;
    protected static final int MON_OPTION = 5;
    protected final ArrayList<BreakpointMarker> bkpts = new ArrayList();
    protected static final HashMap<String, Integer> markerlist = new HashMap(5);
    protected final ArrayList<debugFile> monitors = new ArrayList();
    protected final ArrayList<ExecutionCountsMessage> counts = new ArrayList();
    protected final ArrayList<SetBacktraceMessage> traces = new ArrayList();
    protected final ArrayList<SetBacktraceMessage> datamonitor = new ArrayList();
    protected final ArrayList<BreakpointMarker> rbpmap = new ArrayList();
    protected final ArrayList<BreakpointMarker> monitoroptions = new ArrayList();
    protected final debugSession session;
    protected boolean setStepAfter = false;

    static {
        markerlist.put("com.ca.intertest.breakpoint.rbp", new Integer(1));
        markerlist.put("com.ca.intertest.breakpoint.watch", new Integer(2));
        markerlist.put("com.ca.intertest.breakpoint.unconditional", new Integer(3));
        markerlist.put("com.ca.intertest.breakpoint.conditional", new Integer(4));
        markerlist.put("com.ca.intertest.monitor", new Integer(5));
    }

    QueueBreakpoints(debugSession session) {
        this.session = session;
        session.addDebugListener(this);
        session.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source;
        if (!this.session.isDebugging()) {
            this.rbpmap.clear();
            this.bkpts.clear();
            this.monitors.clear();
            this.setStepAfter = false;
            return;
        }
        if ("step_after".equals(event.getProperty())) {
            this.setStepAfter = true;
        }
        if ((source = event.getSource()) == null || !(source instanceof IDebug)) {
            return;
        }
        IDebug idebug = (IDebug)source;
        if (!this.session.equals(idebug.getSession())) {
            return;
        }
        if (idebug instanceof debugFile && this.session.getFile(idebug.getResource()) == null) {
            return;
        }
        Integer markertype = markerlist.get(event.getProperty());
        if (markertype == null) {
            return;
        }
        IMarker marker = (IMarker)event.getNewValue();
        try {
            if (marker != null && marker.exists()) {
                this.addBreakpoint(marker);
                this.post(null);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
    }

    @Override
    public void debugEventOccured(debugEvent event) {
        if (!this.session.isDebugging()) {
            this.rbpmap.clear();
            this.bkpts.clear();
            this.monitors.clear();
            return;
        }
        if (event.getSource() instanceof CVMO) {
            try {
                this.post(null);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    protected synchronized void addBreakpoint(IMarker marker) throws Exception {
        Integer type;
        if (!this.session.isDebugging()) {
            this.rbpmap.clear();
            this.bkpts.clear();
            this.monitors.clear();
            this.monitoroptions.clear();
            return;
        }
        if (!marker.exists()) {
            throw new ITException(Messages.QueueBreakpoints_0);
        }
        IResource res = marker.getResource();
        IDebug debugit = Debug.getInstance().getResource(res);
        if (debugit == null) {
            return;
        }
        if (debugit instanceof debugFile) {
            debugFile debugfile = (debugFile)debugit;
            if (!debugfile.isMonitor()) {
                return;
            }
            if (this.session.isBatch() && !debugfile.isEntered()) {
                return;
            }
        }
        if ((type = markerlist.get(marker.getType())) == null) {
            return;
        }
        BreakpointMarker bkptmarker = debugit.addBreakpointMarker(marker);
        if (type == 1) {
            this.rbpmap.add(bkptmarker);
        } else if (type == 5) {
            this.monitoroptions.add(bkptmarker);
        } else {
            this.bkpts.add(bkptmarker);
        }
    }

    protected void addBreakpoints(debugFile file) {
        try {
            IMarker marker;
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = file.getResource().findMarkers("com.ca.intertest.breakpoint", true, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                if (marker.exists() && marker.getAttribute("BREAKPOINT_ENABLED", false)) {
                    try {
                        this.addBreakpoint(marker);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
                ++n2;
            }
            iMarkerArray = markers = file.getResource().findMarkers("com.ca.intertest.monitor", true, 0);
            n = markers.length;
            n2 = 0;
            while (n2 < n) {
                marker = iMarkerArray[n2];
                if (marker.exists() && marker.getAttribute("BREAKPOINT_ENABLED", false)) {
                    try {
                        this.addBreakpoint(marker);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.loggit(e);
        }
    }

    protected void clearBreakpoints(debugFile file) {
        BreakpointMarker[] breakpointMarkerArray = file.getBreakpointmarkers();
        int n = breakpointMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BreakpointMarker breakpoint = breakpointMarkerArray[n2];
            breakpoint.setBreakpointID(0L);
            ++n2;
        }
    }

    protected void addMonitor(debugFile file) throws Exception {
        this.addMonitor(file, false);
    }

    public abstract void addExecutionCount(IDebug var1, boolean var2, short var3) throws Exception;

    public abstract void addDataMonitor(IDebug var1, boolean var2) throws Exception;

    public abstract void addStatementTrace(IDebug var1, boolean var2) throws Exception;

    protected void addMonitor(debugFile file, boolean force) throws Exception {
        if (!this.session.isDebugging() && !force) {
            this.rbpmap.clear();
            this.bkpts.clear();
            this.monitors.clear();
            this.counts.clear();
            this.datamonitor.clear();
            this.traces.clear();
            return;
        }
        this.monitors.add(file);
    }

    public void removeMonitor(debugFile file) {
        this.monitors.remove(file);
    }

    public abstract void buildMonitoredList(CVMI var1);

    protected abstract void buildMessages(CVMI var1);

    protected abstract void post(IProgressMonitor var1) throws Exception;

    protected boolean postbreakpoints(CVMI cvmi, CVMO cvmo) {
        int count = 0;
        if (cvmo != null) {
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage message = debugMessageArray[n2];
                try {
                    Object msgobj;
                    DebugMessage cvmimessage = null;
                    cvmimessage = message instanceof StatusMessage ? cvmi.getMessage(((StatusMessage)message).getRequestseqno()) : cvmi.getMessage(message.getSequencenumber());
                    BreakpointMarker breakpoint = null;
                    if (cvmimessage != null && (msgobj = cvmimessage.getObject()) instanceof BreakpointMarker) {
                        breakpoint = (BreakpointMarker)msgobj;
                    }
                    if (breakpoint != null) {
                        switch (message.getMessageID()) {
                            case 6: {
                                SETBKPMessage msg = (SETBKPMessage)message;
                                breakpoint.setBreakpointID(msg.getBreakpointID());
                                breakpoint.setValid(true);
                                break;
                            }
                            case 18: {
                                StatusMessage status = (StatusMessage)message;
                                short result = status.getStatus();
                                breakpoint.setValid(result == 0);
                                if (result != 0) {
                                    breakpoint.setErrorText(status.getMessage());
                                    ++count;
                                    break;
                                }
                                if (!(cvmimessage instanceof RequestBreakpointMessage)) break;
                                RequestBreakpointMessage rbpmsg = (RequestBreakpointMessage)cvmimessage;
                                if (rbpmsg.isEnabled()) {
                                    breakpoint.setBreakpointID(rbpmsg.getBreakpointID());
                                    break;
                                }
                                breakpoint.setBreakpointID(0L);
                            }
                        }
                        IDebug file = Debug.getInstance().getResource(breakpoint.getResource());
                        if (file != null) {
                            file.firePropertyChangeListeners(new PropertyChangeEvent((Object)breakpoint, breakpoint.getType(), (Object)breakpoint.getMarker(), (Object)breakpoint.getMarker()));
                        }
                    }
                }
                catch (Exception e) {
                    Logger.loggit(e);
                    cvmo.setErrorLevel(32);
                    cvmo.setErrorMessage(HexUtil.getErrorText((Throwable)e));
                }
                ++n2;
            }
            this.session.putSnapshot();
        }
        return count != 0;
    }

    public boolean isSetStepAfter() {
        return this.setStepAfter;
    }

    public void setSetStepAfter(boolean setStepAfter) {
        this.setStepAfter = setStepAfter;
    }
}

