/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Messages;
import com.ca.intertest.dialogs.IntertestDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CoreExprNameDialog
extends IntertestDialog {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private String title;
    private Text exprNameText;
    private String exprName;
    private Group viewGroup = null;
    private Button dataRadioButton = null;
    private Button sessionRadioButton = null;
    private String viewName = "";
    private Label message;

    public CoreExprNameDialog(Shell parentShell) {
        super(parentShell);
    }

    public CoreExprNameDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void init(String expr) {
        this.CONTEXT_ID = "coreDumpPage";
        this.title = String.valueOf(Messages.CoreExprNameDialog_3) + expr;
        this.exprName = "";
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Label label = new Label(composite, 0);
        label.setText(Messages.CoreExprNameDialog_5);
        label.setLayoutData((Object)new GridData(16384, 0, false, false));
        this.exprNameText = new Text(composite, 2048);
        this.exprNameText.setText("");
        gridData = new GridData(16384, 0, false, false);
        gridData.minimumWidth = this.convertWidthInCharsToPixels(10);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        this.exprNameText.setTextLimit(40);
        this.exprNameText.setLayoutData((Object)gridData);
        this.exprNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CoreExprNameDialog.this.updateButtons();
            }
        });
        if (this.viewName.length() == 0) {
            this.createViewGroup(composite);
        }
        this.message = new Label(composite, 1);
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        this.message.setLayoutData((Object)gridData);
        this.message.setText("");
        this.updateButtons();
        return composite;
    }

    private boolean updateButtons() {
        Button button;
        boolean result = true;
        if (this.exprNameText.getText().length() == 0) {
            this.message.setText(Messages.CoreExprNameDialog_8);
            result = false;
        } else if (this.sessionRadioButton == null) {
            result = true;
        } else if (!this.sessionRadioButton.getSelection() && !this.dataRadioButton.getSelection()) {
            this.message.setText(Messages.CoreExprNameDialog_9);
            result = false;
        }
        if (result && this.message.getText().length() > 0) {
            this.message.setText("");
        }
        if ((button = this.getButton(0)) != null) {
            this.getButton(0).setEnabled(result);
            int width = this.convertWidthInCharsToPixels(Math.max(40, this.exprNameText.getText().length()));
            this.exprNameText.setSize(this.exprNameText.computeSize(width, -1));
            this.message.setSize(this.message.computeSize(-1, -1));
            Composite composite = this.exprNameText.getParent().getParent();
            composite.setSize(composite.computeSize(-1, -1));
        }
        return result;
    }

    private void createViewGroup(Composite composite) {
        this.viewGroup = new Group(composite, 0);
        this.viewGroup.setText(Messages.CoreExprNameDialog_11);
        this.viewGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        this.viewGroup.setLayoutData((Object)gridData);
        this.dataRadioButton = new Button((Composite)this.viewGroup, 16);
        this.dataRadioButton.setText(Messages.CoreExprNameDialog_12);
        this.dataRadioButton.setSelection(true);
        gridData = new GridData(4, 2, true, false, 1, 1);
        this.dataRadioButton.setLayoutData((Object)gridData);
        this.sessionRadioButton = new Button((Composite)this.viewGroup, 16);
        this.sessionRadioButton.setText(Messages.CoreExprNameDialog_13);
        this.sessionRadioButton.setSelection(false);
        gridData = new GridData(4, 2, true, false, 1, 1);
        this.sessionRadioButton.setLayoutData((Object)gridData);
    }

    protected void okPressed() {
        if (this.updateButtons()) {
            this.exprName = this.exprNameText.getText();
            if (this.dataRadioButton != null) {
                this.viewName = "com.ca.intertest.ui.views.sessionview";
                if (this.dataRadioButton.getSelection()) {
                    this.viewName = "com.ca.intertest.ui.views.dataview";
                }
            }
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public String getExprName() {
        return this.exprName;
    }

    public String getView() {
        return this.viewName;
    }

    public void setView(String view) {
        this.viewName = view == null ? "" : view;
    }
}

