/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.dialogs.IntertestDialog;
import com.ca.intertest.dialogs.MRUCombo;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CoreFindDialog
extends IntertestDialog
implements SelectionListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private final IPreferenceStore store = IntertestPlugin.getConfigurationPreferences();
    private Shell sShell = null;
    private Label searchLabel = null;
    private Label nullLabel = null;
    private Group directionGroup = null;
    private Button nextRadioButton = null;
    private Button prevRadioButton = null;
    private Label rangeLabel = null;
    private Text rangeText = null;
    private Group columnGroup = null;
    private Button hexRadioButton = null;
    private Button charRadioButton = null;
    private IDialogSettings settings;
    private MRUCombo FindString;
    private Combo combo;
    private String title;
    private String sSearchText = "";
    private int iRangeText = 0;
    private String sMsg = "";
    private boolean goFlag = false;
    public int direction = 0;
    public int type = 0;
    private static final String SEARCHSTRING = "core_find_string";
    private static final String RANGE = "core_find_range";
    private static final String TYPE = "core_find_type";
    private static final String DIRECTION = "core_find_direction";

    public CoreFindDialog(Shell parentShell) {
        super(parentShell);
    }

    public CoreFindDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        this.sShell = newShell;
    }

    public void init() {
        this.CONTEXT_ID = "coreDumpPage";
        this.title = Messages.CoreFindDialog_4;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.settings = this.getDialogSettings();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 4, true, true));
        this.searchLabel = new Label(composite, 0);
        this.searchLabel.setText(Messages.CoreFindDialog_5);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 120;
        this.searchLabel.setLayoutData((Object)gridData);
        this.FindString = new MRUCombo(composite, 4, SEARCHSTRING);
        this.combo = this.FindString.getCombo();
        this.combo.setTextLimit(44);
        TextUtil.setWidth(this.FindString.getCombo(), 20, 44);
        gridData = new GridData(32);
        gridData.horizontalSpan = 4;
        gridData.widthHint = 200;
        String str = this.settings.get(SEARCHSTRING);
        int index = str == null ? -1 : this.combo.indexOf(str);
        this.combo.select(index);
        this.combo.setLayoutData((Object)gridData);
        this.createDirectionGroup(composite);
        this.doNullLabel(composite);
        this.doNullLabel(composite);
        this.createColumnGroup(composite);
        this.doNullLabel(composite);
        this.doNullLabel(composite);
        this.rangeLabel = new Label(composite, 0);
        this.rangeLabel.setText(Messages.CoreFindDialog_6);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 120;
        this.rangeLabel.setLayoutData((Object)gridData);
        this.rangeText = new Text(composite, 2048);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 76;
        this.rangeText.setTextLimit(8);
        str = this.settings.get(RANGE);
        if (str == null || str.length() == 0) {
            str = String.valueOf(this.store.getInt("CORE_MEMLENGTH"));
        }
        this.rangeText.setText(str);
        this.rangeText.setLayoutData((Object)gridData);
        this.rangeText.addVerifyListener((VerifyListener)new verifyDigit(false));
        this.FindString.getCombo().addSelectionListener((SelectionListener)this);
        return composite;
    }

    public void doNullLabel(Composite parent) {
        this.nullLabel = new Label(parent, 0);
        this.nullLabel.setText(" ");
        GridData gridData = new GridData(32);
        gridData.widthHint = 120;
        this.nullLabel.setLayoutData((Object)gridData);
    }

    private void createDirectionGroup(Composite composite) {
        this.directionGroup = new Group(composite, 0);
        this.directionGroup.setText(Messages.CoreFindDialog_8);
        this.directionGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.directionGroup.setLayoutData((Object)gridData);
        boolean directionFlag = this.settings.getBoolean(DIRECTION);
        this.nextRadioButton = new Button((Composite)this.directionGroup, 16);
        this.nextRadioButton.setText(Messages.CoreFindDialog_9);
        this.nextRadioButton.setSelection(!directionFlag);
        gridData = new GridData(4, 2, true, false, 1, 1);
        gridData.widthHint = 80;
        this.nextRadioButton.setLayoutData((Object)gridData);
        this.prevRadioButton = new Button((Composite)this.directionGroup, 16);
        this.prevRadioButton.setText(Messages.CoreFindDialog_10);
        this.prevRadioButton.setSelection(directionFlag);
        gridData = new GridData(4, 2, true, false, 1, 1);
        gridData.widthHint = 80;
        this.prevRadioButton.setLayoutData((Object)gridData);
    }

    private void createColumnGroup(Composite composite) {
        this.columnGroup = new Group(composite, 0);
        this.columnGroup.setText(Messages.CoreFindDialog_11);
        this.columnGroup.setLayout((Layout)new GridLayout(2, true));
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.columnGroup.setLayoutData((Object)gridData);
        boolean typeFlag = this.settings.getBoolean(TYPE);
        this.charRadioButton = new Button((Composite)this.columnGroup, 16);
        this.charRadioButton.setText(Messages.CoreFindDialog_12);
        this.charRadioButton.setSelection(!typeFlag);
        gridData = new GridData(4, 2, true, false, 1, 1);
        gridData.widthHint = 80;
        this.charRadioButton.setLayoutData((Object)gridData);
        this.hexRadioButton = new Button((Composite)this.columnGroup, 16);
        this.hexRadioButton.setText(Messages.CoreFindDialog_13);
        this.hexRadioButton.setSelection(typeFlag);
        gridData = new GridData(4, 2, true, false, 1, 1);
        gridData.widthHint = 80;
        this.hexRadioButton.setLayoutData((Object)gridData);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
    }

    protected void okPressed() {
        boolean rc = this.verifyInput();
        if (!rc) {
            MessageDialog.openWarning((Shell)this.sShell, (String)Messages.CoreFindDialog_14, (String)this.sMsg);
        } else {
            this.goFlag = true;
            this.doDirection();
            this.doType();
            this.FindString.save();
            this.settings.put(SEARCHSTRING, this.sSearchText);
            this.settings.put(RANGE, String.valueOf(this.iRangeText));
            this.settings.put(DIRECTION, !this.nextRadioButton.getSelection());
            this.settings.put(TYPE, !this.charRadioButton.getSelection());
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public void doType() {
        if (this.hexRadioButton.getSelection()) {
            this.type = 0;
        } else if (this.charRadioButton.getSelection()) {
            this.type = 1;
        }
    }

    public void doDirection() {
        if (this.nextRadioButton.getSelection()) {
            this.direction = 0;
        } else if (this.prevRadioButton.getSelection()) {
            this.direction = 1;
        }
    }

    public boolean verifyInput() {
        this.sSearchText = this.combo.getText();
        this.iRangeText = this.rangeText.getText().length() > 0 ? Integer.valueOf(this.rangeText.getText()) : 0;
        if (this.iRangeText == 0) {
            this.sMsg = Messages.CoreFindDialog_15;
            return false;
        }
        if (this.hexRadioButton.getSelection()) {
            this.sSearchText.toUpperCase();
        }
        if (this.sSearchText == "") {
            this.sMsg = Messages.CoreFindDialog_17;
            return false;
        }
        if (this.hexRadioButton.getSelection()) {
            int chkLth = this.sSearchText.length() - this.sSearchText.length() / 2 * 2;
            if (chkLth != 0) {
                this.sMsg = Messages.CoreFindDialog_18;
                return false;
            }
            return this.chkHex(this.sSearchText);
        }
        return true;
    }

    public boolean chkHex(String str) {
        String hexchars = "0123456789ABCDEF";
        boolean result = true;
        int i = 0;
        while (i < str.length()) {
            int ptr = hexchars.indexOf(str.substring(i, i + 1));
            if (ptr < 0) {
                this.sMsg = Messages.CoreFindDialog_20;
                return false;
            }
            ++i;
        }
        return result;
    }

    public boolean getGoFlag() {
        return this.goFlag;
    }

    public String getSearchString() {
        return this.sSearchText;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getType() {
        return this.type;
    }

    public int getRange() {
        return this.iRangeText;
    }
}

