/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.dialogs.JclEditDialog;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.tools.FileNameExtended;
import com.ca.intertest.tools.FileReceiveMessage;
import com.ca.intertest.tools.ITException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EditBatchJCL {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    FileNameExtended file;
    FileServer server;
    String JCLStream;
    String ErrorText;
    short status;
    boolean changed = false;
    boolean readonly = false;
    boolean submit = false;

    public EditBatchJCL(FileServer server, FileName file) {
        this.server = server;
        this.file = new FileNameExtended(file);
    }

    public void process() {
        this.getFile();
        boolean more = this.status == 0;
        while (more) {
            more = this.editFile();
            if (!more) continue;
            more = this.saveFile();
        }
    }

    private boolean saveFile() {
        boolean more = true;
        FileConnection connection = new FileConnection(this.server);
        try {
            connection.connect(true);
            this.file.setInputstream((InputStream)new ByteArrayInputStream(this.JCLStream.getBytes()));
            connection.putFile(this.file);
            if (connection.getErrorLevel() == 0) {
                this.showInfo(Messages.EditBatchJCL_0);
                more = false;
            } else {
                this.status = (short)connection.getErrorLevel();
                this.ErrorText = String.valueOf(Messages.EditBatchJCL_1) + connection.getErrorMessage();
                this.showError(this.ErrorText);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.ErrorText = String.valueOf(Messages.EditBatchJCL_2) + connection.getErrorMessage();
            this.status = (short)connection.getErrorLevel();
            this.showError(this.ErrorText);
        }
        return more;
    }

    private boolean editFile() {
        this.changed = false;
        Display display = Display.getDefault();
        if (display != null) {
            final JclEditDialog dialog = new JclEditDialog(display.getActiveShell());
            dialog.setJclStream(this.JCLStream);
            dialog.setReadonly(this.readonly);
            dialog.setSubmit(this.submit);
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    String jcl;
                    if (dialog.open() == 0 && !(jcl = dialog.getJclStream()).equals(EditBatchJCL.this.JCLStream)) {
                        EditBatchJCL.this.JCLStream = jcl;
                        EditBatchJCL.this.changed = true;
                    }
                }
            });
        }
        return this.changed;
    }

    private void getFile() {
        block7: {
            CVMO cvmo = null;
            FileConnection connection = new FileConnection(this.server);
            try {
                connection.connect(true);
                this.file.setASA(false);
                cvmo = connection.getFile(this.file);
                if (connection.getErrorLevel() == 0) {
                    DebugMessage message = cvmo.getMessage(1);
                    if (message instanceof FileReceiveMessage) {
                        FileReceiveMessage msg = (FileReceiveMessage)message;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(msg.getInputstream()));
                        StringWriter writer = new StringWriter();
                        String line = null;
                        line = reader.readLine();
                        while (line != null) {
                            writer.write(line);
                            writer.write(IConstants.LINEFEED);
                            line = reader.readLine();
                        }
                        this.JCLStream = writer.getBuffer().toString();
                        reader.close();
                        writer.close();
                        break block7;
                    }
                    this.status = (short)connection.getErrorLevel();
                    this.ErrorText = String.valueOf(Messages.EditBatchJCL_3) + connection.getErrorMessage();
                    this.showError(this.ErrorText);
                    break block7;
                }
                throw new ITException();
            }
            catch (Exception e) {
                Logger.loggit(e);
                this.ErrorText = String.valueOf(Messages.EditBatchJCL_4) + connection.getErrorMessage();
                this.status = (short)connection.getErrorLevel();
                this.showError(this.ErrorText);
            }
        }
    }

    private void showError(final String message) {
        final Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.EditBatchJCL_5, (String)message);
                }
            });
        }
    }

    private void showInfo(final String message) {
        final Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Messages.EditBatchJCL_5, (String)message);
                }
            });
        }
    }

    public short getStatus() {
        return this.status;
    }

    public String getErrorText() {
        return this.ErrorText;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(boolean submit) {
        this.submit = submit;
    }
}

