/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Structures;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IntertestDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LayoutDialog
extends IntertestDialog {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private String initStructure = " ";
    private String initProgram = "";
    protected String useProgram = "";
    protected String useStructure = "";
    protected Combo useProgramCombo;
    protected Combo useStructureCombo;
    protected ArrayList<String> structs;
    protected ArrayList<String> progs;
    protected HashMap<String, TreeObject> treeobjs;
    protected ArrayList<TreeObject> structobjs;
    protected int levelOption = 1;
    protected String version = "";
    protected String serverType = "";
    protected static final String CICS_LITERAL = "cics";
    protected static final String BATCH_LITERAL = "batch";
    protected debugSession session;

    public LayoutDialog(Shell parentShell) {
        super(parentShell);
    }

    public LayoutDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public void buildUseControls(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LayoutDialog_8);
        GridData gridData = new GridData(128);
        label.setLayoutData((Object)gridData);
        this.useProgramCombo = new Combo(parent, 524);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.useProgramCombo.setTextLimit(8);
        gridData.grabExcessHorizontalSpace = false;
        this.progs = Structures.getAvailablePrograms(this.session);
        Object[] obj = this.progs.toArray();
        Object[] programValues = new String[obj.length];
        int j = 0;
        while (j < obj.length) {
            programValues[j] = (String)obj[j];
            ++j;
        }
        Arrays.sort(programValues);
        this.useProgramCombo.add(" ");
        int i = 0;
        while (i < programValues.length) {
            this.useProgramCombo.add((String)programValues[i]);
            ++i;
        }
        this.useProgramCombo.setText(this.initProgram);
        this.useProgramCombo.setLayoutData((Object)gridData);
        this.useProgramCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayoutDialog.this.loadStructures(LayoutDialog.this.useProgramCombo.getText().trim());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LayoutDialog.this.loadStructures(LayoutDialog.this.useProgramCombo.getText().trim());
            }
        });
        label = new Label(parent, 0);
        label.setText(Messages.LayoutDialog_10);
        gridData = new GridData(128);
        label.setLayoutData((Object)gridData);
        this.useStructureCombo = new Combo(parent, 524);
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        this.useStructureCombo.setTextLimit(60);
        gridData.grabExcessHorizontalSpace = false;
        this.loadStructures(this.initProgram);
    }

    private void loadStructures(String initProgram) {
        int sel;
        String selProg = "";
        selProg = initProgram.length() == 0 ? ((sel = this.useProgramCombo.getSelectionIndex()) < 0 ? "" : this.useProgramCombo.getItem(sel)) : initProgram.trim();
        if (selProg.length() != 0) {
            this.useStructureCombo.setEnabled(true);
            this.treeobjs = Structures.getProgObjs(this.session, selProg);
            Object[] obj = Structures.getAvailableStructures(selProg, this.treeobjs, this.progs, this.levelOption).toArray();
            Object[] structureValues = new String[obj.length];
            int j = 0;
            while (j < obj.length) {
                structureValues[j] = (String)obj[j];
                ++j;
            }
            Arrays.sort(structureValues);
            this.useStructureCombo.removeAll();
            this.useStructureCombo.add(" ");
            int i = 0;
            while (i < structureValues.length) {
                this.useStructureCombo.add((String)structureValues[i]);
                ++i;
            }
        } else {
            Object[] structureValues = new String[]{this.initStructure};
            Arrays.sort(structureValues);
            int i = 0;
            while (i < structureValues.length) {
                this.useStructureCombo.add((String)structureValues[i]);
                ++i;
            }
            this.useStructureCombo.setText((String)structureValues[0]);
            this.useStructureCombo.setEnabled(false);
        }
        Composite parent = this.useStructureCombo.getParent();
        parent.setSize(parent.computeSize(-1, -1));
        Control owner = this.getDialogArea();
        if (owner != null) {
            Shell shell = this.getShell();
            shell.setSize(shell.computeSize(-1, -1));
        }
    }

    protected void setInitStructure(String initStructure) {
        this.initStructure = initStructure;
    }

    protected void setInitProgram(String initProgram) {
        this.initProgram = initProgram;
    }
}

