/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.dialogs.IntertestDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewCopyDialog
extends IntertestDialog {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private final String title = Messages.NewCopyDialog_1;
    private Text progText;
    private static final String EMPTY = "";
    private String program = "";
    private final String label = Messages.NewCopyDialog_3;
    private Text message;
    private static final String ENTER_PROGRAM_NAME = Messages.NewCopyDialog_4;

    public NewCopyDialog(Shell parentShell) {
        super(parentShell);
    }

    public NewCopyDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.CONTEXT_ID = "newCopy";
        this.getShell().setText(this.title);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Label variableLabel = new Label(composite, 0);
        variableLabel.setText(this.label);
        this.progText = new Text(composite, 2048);
        this.progText.setText(this.program);
        this.progText.setTextLimit(8);
        this.progText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.progText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewCopyDialog.this.checkText();
            }
        });
        TextUtil.setWidth(this.progText, 8, 8);
        this.message = new Text(composite, 9);
        this.message.setText(ENTER_PROGRAM_NAME);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        this.message.setLayoutData((Object)gridData);
        GC gc = new GC((Drawable)this.message);
        Point point = gc.stringExtent(ENTER_PROGRAM_NAME);
        gridData.minimumWidth = point.x;
        gridData.widthHint = point.x;
        gc.dispose();
        return composite;
    }

    protected void okPressed() {
        this.program = this.progText.getText().trim();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.program = EMPTY;
        super.cancelPressed();
    }

    public void create() {
        super.create();
        this.checkText();
    }

    public String getProgram() {
        return this.program;
    }

    private void checkText() {
        boolean enabled = true;
        String name = this.progText.getText().trim();
        if (name.length() > 0) {
            this.message.setText(EMPTY);
        } else {
            this.message.setText(ENTER_PROGRAM_NAME);
            enabled = false;
        }
        this.getButton(0).setEnabled(enabled);
    }
}

