/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveTraceDialog
extends TitleAreaDialog {
    public static final String message = "Specify a name for the trace file without the extension.";
    private Text txtFileName;
    private String fileName;
    private IProject project;

    public SaveTraceDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Save Trace");
    }

    public void create() {
        super.create();
        this.setTitle("Save project " + this.project.getName());
        this.setMessage(message, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label lbtFileName = new Label(container, 0);
        lbtFileName.setText("Trace Name");
        GridData dataFileName = new GridData();
        dataFileName.grabExcessHorizontalSpace = true;
        dataFileName.horizontalAlignment = 4;
        this.txtFileName = new Text(container, 2048);
        this.txtFileName.setLayoutData((Object)dataFileName);
        this.txtFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveTraceDialog.this.validateTraceName();
            }
        });
        return area;
    }

    private void validateTraceName() {
        this.setMessage(message, 1);
        this.setErrorMessage(null);
        String traceName = String.valueOf(this.txtFileName.getText()) + "." + "trace";
        if (this.project.findMember(traceName) != null) {
            this.setMessage("The selected name already exists in " + this.project.getName(), 2);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.fileName = this.txtFileName.getText();
    }

    protected void okPressed() {
        this.saveInput();
        String traceName = String.valueOf(this.txtFileName.getText()) + "." + "trace";
        boolean isOK = true;
        if (this.project.findMember(traceName) != null) {
            isOK = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Trace file already exists!", (String)("Selected trace file " + traceName + " already exists. The contents will be overwritten.\nDo you want to continue?"));
        }
        if (isOK) {
            super.okPressed();
        }
    }

    public String getFileName() {
        return this.fileName;
    }
}

