/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.server;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.tools.HexUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;

public class ServiceConnection
extends Connection {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private boolean active = false;
    private String statusText = Messages.ServiceConnection_1;

    public ServiceConnection(ServerElement server) {
        super(server);
        try {
            this.connect(false);
            this.active = true;
            this.statusText = Messages.ServiceConnection_2;
            this.validateUrl(server);
        }
        catch (Exception e) {
            this.active = false;
            Logger.loggit(4, this.getErrorMessage(), e);
            this.statusText = String.valueOf(Messages.ServiceConnection_3) + HexUtil.getErrorText((Throwable)e);
        }
    }

    private void validateUrl(ServerElement server) throws IOException {
        try {
            URL myURL = new URL(String.valueOf(server.getProtocol()) + "://" + server.getHostname() + ":" + server.getPort());
            if (myURL.getProtocol().equals("http")) {
                HttpURLConnection urlConnection = (HttpURLConnection)myURL.openConnection();
                urlConnection.getResponseCode();
            } else {
                HttpsURLConnection con = (HttpsURLConnection)myURL.openConnection();
                con.getResponseCode();
            }
        }
        catch (SocketException e) {
            this.active = false;
            Logger.loggit(4, Messages.ServiceConnection_HTTPErrorMessage, e);
            this.statusText = String.valueOf(Messages.ServiceConnection_3) + Messages.ServiceConnection_HTTPErrorMessage;
        }
        catch (SSLException e) {
            this.active = false;
            Logger.loggit(4, Messages.ServiceConnection_HTTPSErrorMessage, e);
            this.statusText = String.valueOf(Messages.ServiceConnection_3) + Messages.ServiceConnection_HTTPSErrorMessage;
        }
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized String getStatusText() {
        return this.statusText;
    }

    @Override
    public boolean connect(boolean logon) throws Exception {
        this.initStatus();
        if (!this.connected) {
            try {
                if (logon && !this.loggedin) {
                    this.login();
                }
                this.connected = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.connected;
    }
}

