/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.ui.views.debugtree.DebugTreeView;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.PageBookView;

public abstract class AbstractDebuggingAction
implements IViewActionDelegate {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected TreeViewer viewer;
    protected IStructuredSelection selected;
    protected debugSession session = null;
    protected PageBookView book = null;

    public abstract void run(IAction var1);

    public void dispose() {
    }

    protected void refocus() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractDebuggingAction.this.viewer != null && AbstractDebuggingAction.this.selected != null) {
                    AbstractDebuggingAction.this.viewer.refresh(AbstractDebuggingAction.this.selected.getFirstElement(), true);
                    AbstractDebuggingAction.this.viewer.setSelection((ISelection)AbstractDebuggingAction.this.selected);
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        this.session = null;
        if (selection instanceof IStructuredSelection) {
            this.selected = (IStructuredSelection)selection;
            if (this.selected.size() == 1) {
                IT_TreeItem root;
                Object obj = this.selected.getFirstElement();
                if (obj instanceof IT_TreeItem && (root = ((IT_TreeItem)obj).getRoot()) != null) {
                    obj = root.getObj();
                }
                if (obj instanceof debugFile) {
                    this.session = Debug.getInstance().getSession((IResource)((IDebug)obj).getResource().getProject());
                } else if (obj instanceof HashMap) {
                    HashMap map = (HashMap)obj;
                    Object value = map.get("session");
                    if (value instanceof debugSession) {
                        this.session = (debugSession)value;
                    }
                } else {
                    this.session = obj instanceof debugSession ? (debugSession)obj : null;
                }
                if (this.session != null) {
                    enabled = this.session.isAtBreakpoint();
                }
            }
        }
        action.setEnabled(enabled);
    }

    public void init(IViewPart view) {
        if (view instanceof DebugTreeView) {
            DebugTreeView debugtreeview = (DebugTreeView)view;
            this.viewer = debugtreeview.getTreeViewer();
        } else if (view instanceof PageBookView) {
            this.book = (PageBookView)view;
        } else {
            this.viewer = null;
        }
    }
}

