/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.AbstractDataViewPageBook;
import com.ca.intertest.wizards.CoreWizard;
import com.ca.intertest.wizards.MemoryWizardDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;

public class CoreKeepItemAction
implements IViewActionDelegate {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private AbstractDataViewPageBook book = null;
    private AbstractDataViewPage page = null;
    protected Object object = null;
    private IDebug debugitem;
    protected ListerEditor editor;
    private boolean expression;

    public void init(IPage page) {
        if (page instanceof AbstractDataViewPage) {
            this.page = (AbstractDataViewPage)page;
            this.debugitem = this.page.getDebugitem();
            this.editor = this.page.getEditor();
        } else {
            page = null;
            this.debugitem = null;
            this.editor = null;
        }
    }

    public void init(IViewPart view) {
        if (view instanceof AbstractDataViewPageBook) {
            this.book = (AbstractDataViewPageBook)view;
        }
    }

    public void run(IAction action) {
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        if (!this.page.getSession().isAtBreakpoint()) {
            return;
        }
        TreeObject treeobject = (TreeObject)this.object;
        boolean exprFlag = treeobject == null ? false : treeobject.getAttribute("dataflag").equals("CORE_EXPRESSION");
        boolean kw = treeobject == null ? false : treeobject.getAttribute("dataflag").equals("DATAVIEW_KEYWORD");
        CoreWizard wizard = new CoreWizard();
        if (treeobject == null) {
            wizard.init(this.editor);
        } else if (kw) {
            String str2;
            String str1;
            String[] args = treeobject.getAlternateName().split("[.]");
            if (args.length != 2) {
                str1 = "";
                str2 = "";
            } else {
                str1 = args[0];
                str2 = args[1];
            }
            wizard.initCmd(this.editor, treeobject.getAttribute("DATAVIEW_KEYWORD"), false, str1, str2, treeobject);
        } else if (treeobject.getType() == 1 || exprFlag) {
            if (!exprFlag) {
                int stmt = (Integer)Attribute.getValue("statementnumber", treeobject);
                wizard.initVar(this.editor, treeobject, stmt);
            } else {
                wizard.initCmd(this.editor, treeobject.getAlternateName(), false);
            }
        }
        MemoryWizardDialog dialog = new MemoryWizardDialog(this.page.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection == null) {
            action.setEnabled(false);
            return;
        }
        boolean enabled = false;
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        this.object = null;
        if (this.page != null && this.page.getSession().isAtBreakpoint()) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() == 1) {
                Object obj = sel.getFirstElement();
                if (obj instanceof TreeObject) {
                    TreeObject treeobject = (TreeObject)obj;
                    this.expression = treeobject.getAttribute("dataflag").equals("CORE_EXPRESSION");
                    if (this.expression || treeobject.getType() == 1) {
                        enabled = true;
                        this.object = treeobject;
                    }
                }
            } else if (sel.isEmpty()) {
                this.object = null;
                enabled = true;
            }
        }
        if (enabled && this.page != null && !(this.debugitem instanceof debugFile)) {
            enabled = false;
            this.object = null;
        }
        action.setEnabled(enabled);
    }
}

