/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.XMLTraceUtils;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.SaveTraceDialog;
import com.ca.intertest.ui.actions.AbstractDebuggingAction;
import com.ca.intertest.ui.views.backtrace.BacktracePage;
import com.ca.intertest.ui.views.backtrace.BacktracePageBook;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPage;

public class SaveTraceDataAction
extends AbstractDebuggingAction {
    private IViewPart insideView;
    private Shell shell;
    IConsoleView viewer;

    public void saveTraceData() {
        this.shell = this.insideView.getViewSite().getShell();
        SaveTraceDialog dialog = new SaveTraceDialog(this.shell, this.getProject());
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        String filename = dialog.getFileName();
        File file = new File(String.valueOf(this.getProject().getLocation().toString()) + File.separator + filename + "." + "trace");
        XMLTraceUtils.saveTraceData(file, this.session);
        try {
            this.getProject().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run(IAction action) {
        this.saveTraceData();
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        debugFile debugfile = null;
        this.session = null;
        if (this.book instanceof BacktracePageBook) {
            IPage currentpage = this.book.getCurrentPage();
            if (currentpage instanceof BacktracePage) {
                this.session = ((BacktracePage)currentpage).getSession();
            }
        } else if (selection instanceof IStructuredSelection) {
            this.selected = (IStructuredSelection)selection;
            Object obj = this.selected.getFirstElement();
            if (obj instanceof IT_TreeItem) {
                if ((obj = ((IT_TreeItem)obj).getObj()) instanceof debugFile) {
                    debugfile = (debugFile)obj;
                    this.session = debugfile.getSession();
                }
                if (obj instanceof debugSession) {
                    this.session = (debugSession)obj;
                }
            }
        }
        if (this.session != null && this.session.getTracelog().size() != 0) {
            enabled = true;
        }
        action.setEnabled(enabled);
    }

    @Override
    public void init(IViewPart view) {
        super.init(view);
        this.insideView = view;
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.session.getName());
    }
}

