/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.actions;

import com.ca.intertest.debug.debugFile;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.AbstractDataViewPageBook;
import com.ca.intertest.wizards.MemoryWizardDialog;
import com.ca.intertest.wizards.StorageWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;

public class StorageRegisterItemAction
implements IViewActionDelegate {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private AbstractDataViewPageBook book = null;
    private AbstractDataViewPage page = null;
    private debugFile debugitem;
    protected ListerEditor editor;

    public void init(IPage page) {
        if (page instanceof AbstractDataViewPage) {
            this.page = (AbstractDataViewPage)page;
            this.debugitem = (debugFile)this.page.getDebugitem();
            this.editor = this.page.getEditor();
        } else {
            page = null;
            this.debugitem = null;
            this.editor = null;
        }
    }

    public void init(IViewPart view) {
        if (view instanceof AbstractDataViewPageBook) {
            this.book = (AbstractDataViewPageBook)view;
        }
    }

    public void run(IAction action) {
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        if (!this.page.getSession().isAtBreakpoint()) {
            return;
        }
        StorageWizard wizard = new StorageWizard();
        wizard.init(this.editor);
        MemoryWizardDialog dialog = new MemoryWizardDialog(this.page.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = false;
        if (this.book != null) {
            this.init(this.book.getCurrentPage());
        }
        if (this.debugitem != null && this.debugitem.isMonitor() && this.page != null && this.page.getSession().isAtBreakpoint() && this.page.getSession().isCICS()) {
            enabled = true;
            if (this.page != null && !(this.debugitem instanceof debugFile)) {
                enabled = false;
            }
        }
        action.setEnabled(enabled);
    }
}

