/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.lister.util;

import com.ca.intertest.common.IConstants;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.lister.util.IListerTokenScanner;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IToken;

public abstract class AbstractPartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension,
IDocumentPartitionerExtension2,
IDocumentPartitionerExtension3 {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected String[] legalContentTypes = TextUtilities.copy((String[])IConstants.SOURCE_CONTENT_TYPES);
    protected IListerTokenScanner scanner;
    protected String positionCategory = "__source_code_category";
    protected IDocument document;
    protected int firstLine;
    protected int lastLine;
    private ListerEditor listerEditor;

    public ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computePartitioning(offset, length, false);
    }

    public void connect(IDocument document) {
        this.connect(document, false);
    }

    public void connect(IDocument document, boolean delayInitialization) {
        this.document = document;
        this.initializeCategory(this.positionCategory);
    }

    public void connect(IDocument document, boolean delayInitialization, ListerEditor editor) {
        this.listerEditor = editor;
        this.connect(document, delayInitialization);
    }

    public String getContentType(int offset) {
        return null;
    }

    public String[] getLegalContentTypes() {
        return this.legalContentTypes;
    }

    public void setLegalContentTypes(String[] types) {
        this.legalContentTypes = TextUtilities.copy((String[])types);
    }

    public ITypedRegion getPartition(int offset) {
        return new TypedRegion(0, offset, "__comment");
    }

    public String[] getManagingPositionCategories() {
        return new String[]{this.positionCategory};
    }

    public String getContentType(int offset, boolean preferOpenPartitions) {
        return "__code";
    }

    public ITypedRegion getPartition(int offset, boolean preferOpenPartitions) {
        return new TypedRegion(0, offset, "__comment");
    }

    public ITypedRegion[] computePartitioning(int offset, int length, boolean includeZeroLengthPartitions) {
        TypedPosition tp = null;
        ArrayList<TypedRegion> list = new ArrayList<TypedRegion>();
        Position[] positions = null;
        try {
            positions = this.getPositions(this.positionCategory);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        int i = 0;
        while (i < positions.length) {
            tp = (TypedPosition)positions[i];
            list.add(new TypedRegion(tp.getOffset(), tp.getLength(), tp.getType()));
            ++i;
        }
        if (list.isEmpty()) {
            list.add(new TypedRegion(offset, length, "__other"));
        }
        TypedRegion[] result = new TypedRegion[list.size()];
        list.toArray(result);
        return result;
    }

    private void initializeCategory(String category) {
        this.document.addPositionCategory(category);
        try {
            this.firstLine = this.listerEditor.getStore().getInt("firststatement");
            this.lastLine = this.listerEditor.getStore().getInt("laststatement");
            IRegion first = this.document.getLineInformation(this.firstLine - 1);
            IRegion last = this.document.getLineInformation(this.lastLine - 1);
            int offset = first.getOffset();
            int end = last.getOffset() + last.getLength();
            int length = end - offset;
            this.document.addPosition(category, (Position)new TypedPosition(offset, length, "__code"));
            this.initializeSections("__source_sections_category");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {}
    }

    protected boolean isValidContentType(IToken token) {
        String contentType = this.getTokenContentType(token);
        int i = 0;
        while (i < this.legalContentTypes.length) {
            if (this.legalContentTypes[i] == contentType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getTokenContentType(IToken token) {
        Object obj = token.getData();
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public void disconnect() {
        try {
            if (this.document.containsPositionCategory("__source_code_category")) {
                this.document.removePositionCategory("__source_code_category");
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return false;
    }

    protected final Position[] getPositions(String category) throws BadPositionCategoryException {
        return this.document.getPositions(category);
    }

    public IRegion documentChanged2(DocumentEvent event) {
        return null;
    }

    public void startRewriteSession(DocumentRewriteSession session) throws IllegalStateException {
    }

    public void stopRewriteSession(DocumentRewriteSession session) {
    }

    public DocumentRewriteSession getActiveRewriteSession() {
        return null;
    }

    public void setLineBoundary(int first, int last) {
        this.firstLine = first;
        this.lastLine = last;
    }

    public ListerEditor getLister() {
        return this.listerEditor;
    }

    protected abstract void initializeSections(String var1);

    public String getSourceSection(int offset) {
        TypedPosition typePos = null;
        try {
            Position[] posits = this.document.getPositions("__source_sections_category");
            int i = 0;
            while (i < posits.length) {
                typePos = (TypedPosition)posits[i];
                int low = typePos.getOffset();
                int high = low + typePos.getLength();
                if (low <= offset && offset <= high) {
                    return typePos.getType();
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return null;
    }
}

