/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.backtrace;

import com.ca.intertest.common.IViewConnector;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugCICSSession;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BacktraceLogMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IScanSource;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.backtrace.BacktracePageBook;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;

public class BacktracePage
extends Page
implements IPageBookViewPage,
IAdaptable,
IDebugListener,
ISelectionListener,
IViewConnector {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private TableViewer viewer;
    private static final Debug debug = Debug.getInstance();
    private debugSession session = null;
    private Table table;
    private Control control;
    private String description = "";
    private BacktracePageBook pagebook;
    private Color oldcolor = null;
    ImageDescriptor id = null;
    private int currentIP = 0;
    private final AnnotationPreferenceLookup lookup = new AnnotationPreferenceLookup();

    public BacktracePage(IProject project) {
        if (project != null) {
            this.session = debug.getSession((IResource)project);
        }
        debug.addItemToViewsList(this);
    }

    public void createControl(Composite parent) {
        this.session.addDebugListener(this);
        this.table = new Table(parent, 66308);
        int i = 0;
        while (i < BacktracePageBook.labels.length) {
            TableColumn column = new TableColumn(this.table, BacktracePageBook.styles[i]);
            column.setText(BacktracePageBook.labels[i]);
            column.setMoveable(true);
            column.setResizable(true);
            column.setData((Object)new Integer(i));
            column.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    Table table;
                    if (BacktracePage.this.viewer != null && !(table = BacktracePage.this.viewer.getTable()).isDisposed()) {
                        BacktracePage.this.pagebook.setOrder(table.getColumnOrder());
                    }
                }

                public void controlResized(ControlEvent e) {
                    TableColumn column = (TableColumn)e.getSource();
                    if (!column.isDisposed()) {
                        Integer id = (Integer)column.getData();
                        ((BacktracePage)BacktracePage.this).pagebook.getWidth()[id.intValue()] = column.getWidth();
                    }
                }
            });
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new BacktraceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BacktraceLabelProvider());
        this.reSize();
        if (this.session.isAtBreakpoint()) {
            CVMO initialCVMO = this.session.getTalker().getBreakpointCVMO();
            this.viewer.setInput((Object)initialCVMO);
            this.setCursor();
        } else {
            this.viewer.setInput((Object)this.session);
        }
        this.control = this.viewer.getControl();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new Separator("com.ca.intertest.ui.views.backtrace"));
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.control);
        this.control.setMenu(menu);
        try {
            this.getSite().registerContextMenu("com.ca.intertest.ui.views.backtrace", menuMgr, (ISelectionProvider)this.viewer);
        }
        catch (Exception exception) {}
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.table.setFont(JFaceResources.getTextFont());
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.pagebook.setContentDescription(this.description);
    }

    public void reSize() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setColumnOrder(this.pagebook.getOrder());
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                Integer colid = (Integer)column.getData();
                column.setWidth(this.pagebook.getWidth()[colid]);
                ++n2;
            }
        }
        this.pagebook.setContentDescription(this.description);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public BacktracePageBook getPagebook() {
        return this.pagebook;
    }

    public void setPagebook(BacktracePageBook pagebook) {
        this.pagebook = pagebook;
    }

    @Override
    public void debugEventOccured(final debugEvent event) {
        Display display = Display.getDefault();
        if (display != null && !this.viewer.getControl().isDisposed()) {
            try {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (BacktracePage.this.pagebook.isActive()) {
                            Object object = event.getSource();
                            if (object instanceof CVMO) {
                                BacktracePage.this.processBreakpoint(event);
                            } else if (object instanceof CVMI) {
                                BacktracePage.this.processExecute(event);
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }

    private void processExecute(debugEvent event) {
        CVMI cvmi = (CVMI)((Object)event.getSource());
        DebugMessage[] debugMessageArray = cvmi.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 26: {
                    this.viewer.setInput(null);
                    this.viewer.refresh();
                    break;
                }
                case 15: {
                    if (this.currentIP <= 0 || this.oldcolor == null) break;
                    int ix = this.currentIP - 1;
                    this.table.getItem(ix).setBackground(this.oldcolor);
                    Object element = this.viewer.getElementAt(ix);
                    this.viewer.refresh(element, true, true);
                    break;
                }
            }
            ++n2;
        }
    }

    public void refreshViewer() {
        this.viewer.refresh();
    }

    private void processBreakpoint(debugEvent event) {
        CVMO cvmo = (CVMO)((Object)event.getSource());
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 1: {
                    int type = this.session.getTalker().getBreakType();
                    switch (type) {
                        case 10: 
                        case 11: {
                            break;
                        }
                        default: {
                            this.viewer.setInput((Object)cvmo);
                        }
                    }
                    this.setCursor();
                    return;
                }
            }
            ++n2;
        }
    }

    private void setCursor() {
        this.currentIP = this.session.getCurrentIP();
        if (this.currentIP > 0) {
            int ix = this.currentIP - 1;
            AnnotationPreference ap = this.lookup.getAnnotationPreference("com.ca.intertest.lister.pointer");
            this.id = ap.getImageDescriptor();
            RGB rgb = ap.getColorPreferenceValue();
            try {
                TableItem item = this.table.getItem(ix);
                this.oldcolor = item.getBackground();
                item.setBackground(new Color((Device)Display.getDefault(), rgb));
                Object element = this.viewer.getElementAt(ix);
                this.viewer.refresh(element, true, true);
                this.id = null;
                this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
            }
            catch (IllegalArgumentException e) {
                Logger.loggit(e);
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!part.equals((Object)this.pagebook)) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof BacktraceLogMessage.TraceLogRecord)) {
            return;
        }
        BacktraceLogMessage.TraceLogRecord record = (BacktraceLogMessage.TraceLogRecord)obj;
        debugFile debugfile = this.session.getFile(record.program);
        IEditorPart ed = null;
        try {
            ed = this.getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)debugfile.getResource()), "com.ca.intertest.ui.lister");
        }
        catch (PartInitException e) {
            Logger.loggit(e);
            return;
        }
        ListerEditor editor = (ListerEditor)ed;
        IScanSource scansource = editor.getScansource();
        IDocument document = editor.getDocument();
        try {
            IRegion region = document.getLineInformation(record.linenumber);
            int srcStart = scansource.getSourceOffset();
            int maxwidth = scansource.getSourceLength();
            int regionwidth = region.getLength() - srcStart;
            if (maxwidth > regionwidth) {
                maxwidth = regionwidth;
            }
            editor.selectAndReveal(region.getOffset() + srcStart, maxwidth);
        }
        catch (BadLocationException e) {
            Logger.loggit(e);
        }
    }

    public debugSession getSession() {
        return this.session;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void refresh(debugSession session) {
        this.session = session;
        this.viewer.refresh();
    }

    public void saveLastSessionNameInWorkspace() {
        String pathToWorkspaces = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().replace("/", "\\");
        try {
            PrintWriter writer = new PrintWriter(String.valueOf(pathToWorkspaces) + "//name.session");
            writer.write(this.session.getName());
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private final class BacktraceContentProvider
    implements IStructuredContentProvider {
        private BacktraceContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CVMO || inputElement instanceof BacktracePage || inputElement instanceof debugCICSSession || inputElement instanceof debugBatchSession) {
                BacktracePage.this.currentIP = BacktracePage.this.session.getCurrentIP();
                ArrayList<BacktraceLogMessage.TraceLogRecord> tracelog = BacktracePage.this.session.getTracelog();
                String program = "";
                Outline outline = null;
                IEditorPart editor = null;
                IDocument document = null;
                for (BacktraceLogMessage.TraceLogRecord record : tracelog) {
                    if (!program.equals(record.program)) {
                        program = record.program;
                        debugFile debugfile = BacktracePage.this.session.getFile(program);
                        if (debugfile == null) {
                            editor = null;
                        } else {
                            FileEditorInput editorInput = new FileEditorInput((IFile)debugfile.getResource());
                            editor = this.findEditorWithoutRestore((IEditorInput)editorInput);
                        }
                        if (!(editor instanceof ListerEditor)) {
                            editor = null;
                            document = null;
                            try {
                                outline = Outline.getInstance(debugfile);
                            }
                            catch (ITException iTException) {
                                outline = null;
                                document = null;
                            }
                        } else {
                            outline = ((ListerEditor)editor).getOutline();
                            document = ((ListerEditor)editor).getDocument();
                        }
                    }
                    if (outline == null) continue;
                    record.linenumber = outline.getLineNumber(record.firstStatement);
                    if (document == null) continue;
                    try {
                        IRegion region = document.getLineInformation(record.linenumber - 1);
                        String line = document.get(region.getOffset(), region.getLength());
                        record.text = HexUtil.rightTrim((String)line);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                return tracelog.toArray(new BacktraceLogMessage.TraceLogRecord[tracelog.size()]);
            }
            return new Object[0];
        }

        private IEditorPart findEditorWithoutRestore(IEditorInput editorInput) {
            IEditorReference[] editorRefs;
            IWorkbenchPage wp = BacktracePage.this.getSite().getPage();
            IEditorReference[] iEditorReferenceArray = editorRefs = wp.getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                try {
                    if (editorRef.getEditorInput().equals(editorInput)) {
                        return editorRef.getEditor(false);
                    }
                }
                catch (PartInitException e) {
                    Logger.loggit(e);
                }
                ++n2;
            }
            return null;
        }

        public void dispose() {
        }
    }

    private class BacktraceLabelProvider
    implements ITableLabelProvider {
        private BacktraceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && BacktracePage.this.id != null) {
                return BacktracePage.this.id.createImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            BacktraceLogMessage.TraceLogRecord item = (BacktraceLogMessage.TraceLogRecord)element;
            switch (columnIndex) {
                case 0: {
                    return item.program;
                }
                case 1: {
                    if (item.number < 2) {
                        return String.format("%06d", item.firstStatement);
                    }
                    return String.format("%06d.%d", item.firstStatement, item.number);
                }
                case 2: {
                    return item.text == null ? Messages.BacktracePage_7 : item.text;
                }
            }
            return item.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

