/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.MemoryUpdate;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.verifyHexFixed;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.ui.views.data.AbstractDataViewPage;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import com.ca.intertest.ui.views.data.RegisterViewData;
import com.ca.intertest.ui.views.data.RegisterViewPageBook;
import com.ca.intertest.ui.views.data.RegisterViewRow;
import com.ca.intertest.ui.views.data.ViewData;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class RegisterViewPage
extends AbstractDataViewPage {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String EMPTY = " ";
    public static final int EXPAND_LEVEL = 1;

    public RegisterViewPage(IDocumentProvider listerDocumentProvider, ListerEditor listerEditor, int pgmlang) {
        super(listerDocumentProvider, listerEditor, pgmlang);
    }

    protected RegisterViewPage() {
    }

    @Override
    protected String getViewID() {
        return "com.ca.intertest.ui.views.registerview";
    }

    @Override
    public ViewData getcontentProvider() {
        if (this.contentprovider == null) {
            this.contentprovider = new RegisterViewData(this.getDebugitem().getResource(), this);
        }
        return this.contentprovider;
    }

    @Override
    public void createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 68354);
        Tree tree = this.viewer.getTree();
        tree.setFont(JFaceResources.getTextFont());
        TreeViewerFocusCellManager mgr = new TreeViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 2 || event.eventType == 1 && (event.keyCode == 13 || event.character == ' ');
            }
        };
        TreeViewerEditor.create((TreeViewer)this.viewer, (SWTFocusCellManager)mgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        String[] labels = new String[]{"Registers", EMPTY, EMPTY, EMPTY, EMPTY};
        int[] styles = new int[]{16385, 16384, 16384, 16384, 16384};
        int columnIndex = 0;
        while (columnIndex < labels.length) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new RegisterTextColumnLabelProvider(columnIndex));
                    column.setEditingSupport((EditingSupport)new BasicEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                default: {
                    column.setLabelProvider((CellLabelProvider)new HexCellsColumnLabelProvider(columnIndex));
                    column.setEditingSupport((EditingSupport)new HexCellsEditingSupport((ColumnViewer)this.viewer, this.session, this.debugfile, columnIndex));
                }
            }
            column.getColumn().setText(labels[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData("column_width", (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(false);
            column.getColumn().addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    e.doit = false;
                }

                public void widgetSelected(SelectionEvent e) {
                    e.doit = false;
                }
            });
            column.getColumn().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    TreeColumn column = (TreeColumn)e.getSource();
                    if (!column.isDisposed()) {
                        Integer id = (Integer)column.getData("column_width");
                        RegisterViewPage.this.pagebook.getWidth()[id.intValue()] = column.getWidth();
                    }
                }
            });
            ++columnIndex;
        }
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setContentProvider((IContentProvider)this.getcontentProvider());
        this.viewer.setColumnProperties(labels);
        this.reSize();
        this.control = this.viewer.getControl();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.viewer.setInput((Object)this.getSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.activateContext();
        this.viewer.expandToLevel(1);
    }

    public void setPagebook(RegisterViewPageBook pagebook) {
        this.pagebook = pagebook;
    }

    @Override
    protected String[] getContextList() {
        return new String[]{"com.ca.intertest.ui.views.registerview", "CICS", "BATCH"};
    }

    @Override
    public void reSize() {
        super.reSize();
        if (this.isViewerControlAvailable()) {
            this.getcontentProvider();
            if (!this.contentprovider.isRefreshed()) {
                this.viewer.setInput((Object)this.getSite());
            }
        }
    }

    public class HexCellsColumnLabelProvider
    extends ColumnLabelProvider {
        private int cellIX;

        public HexCellsColumnLabelProvider(int columnIndex) {
            this.cellIX = columnIndex - 1;
        }

        public String getText(Object element) {
            TreeObject tree;
            if (element instanceof TreeObject && !(tree = (TreeObject)element).hasChildren()) {
                RegisterViewRow row = new RegisterViewRow(tree);
                return row.getCellString(this.cellIX);
            }
            return RegisterViewPage.EMPTY;
        }
    }

    public class HexCellsEditingSupport
    extends BasicEditingSupport {
        protected final int cellIX;

        public HexCellsEditingSupport(ColumnViewer viewer, debugSession session, debugFile debugfile, int columnIndex) {
            super(viewer, session, debugfile, columnIndex);
            this.cellIX = columnIndex - 1;
        }

        @Override
        protected boolean canEdit(Object element) {
            if (this.isBackTraceStop()) {
                return false;
            }
            if (this.session.isBatch() && this.debugfile.getLanguage() != 16) {
                return false;
            }
            if (!this.debugfile.isMonitor()) {
                return false;
            }
            if (this.session.isAtBreakpoint() && element instanceof TreeObject) {
                TreeObject tree = (TreeObject)element;
                if (tree.hasChildren()) {
                    return false;
                }
                if (tree.getName().equals("PSW")) {
                    return false;
                }
                return new RegisterViewRow(tree).canEditDisplay(this.cellIX);
            }
            return false;
        }

        @Override
        protected CellEditor getCellEditor(Object element) {
            TextCellEditor celleditor = new TextCellEditor((Composite)RegisterViewPage.this.viewer.getTree());
            RegisterViewPage.this.viewer.getControl().getMenu();
            celleditor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    return null;
                }
            });
            Text text = (Text)celleditor.getControl();
            text.setMenu(RegisterViewPage.this.viewer.getControl().getMenu());
            text.addVerifyListener((VerifyListener)new verifyHexFixed());
            text.setTextLimit(this.getValue(element).toString().length());
            this.setEditorFont((CellEditor)celleditor);
            return celleditor;
        }

        @Override
        protected Object getValue(Object element) {
            return new RegisterViewRow((TreeObject)element).getCellString(this.cellIX);
        }

        @Override
        protected void setValue(Object element, Object value) {
            if (value == null || value.equals(this.getValue(element))) {
                return;
            }
            TreeObject treeobject = (TreeObject)element;
            RegisterViewRow row = new RegisterViewRow(treeobject);
            byte[] oldvalue = row.getCellData(this.cellIX);
            byte[] newvalue = HexUtil.HextoBytes((String)value.toString());
            row.setCellData(newvalue, this.cellIX);
            MemoryUpdate memory = new MemoryUpdate(this.session);
            if (oldvalue.length == 4) {
                memory.sendMemoryUpdateMessage(HexUtil.toHex((byte[])newvalue, (int)0), HexUtil.toHex((byte[])oldvalue, (int)0), row.getCellAddress(this.cellIX, 0, this.session));
            } else if (oldvalue.length == 8) {
                String lowNewValue = ((String)value).substring(9);
                String highNewValue = ((String)value).substring(0, 8);
                String lowOldValue = HexUtil.toHex((byte[])oldvalue, (int)0).substring(8);
                String highOldValue = HexUtil.toHex((byte[])oldvalue, (int)0).substring(0, 8);
                if (!lowOldValue.equals(lowNewValue)) {
                    memory.sendMemoryUpdateMessage(lowNewValue, lowOldValue, row.getCellAddress(this.cellIX, 1, this.session));
                }
                if (!memory.isError() && !highOldValue.equals(highNewValue)) {
                    memory.sendMemoryUpdateMessage(highNewValue, highOldValue, row.getCellAddress(this.cellIX, 2, this.session));
                }
            } else {
                String newValue1 = ((String)value).substring(0, 8);
                String newValue2 = ((String)value).substring(9, 17);
                String newValue3 = ((String)value).substring(18, 26);
                String newValue4 = ((String)value).substring(27);
                String oldValue1 = HexUtil.toHex((byte[])oldvalue, (int)0).substring(0, 8);
                String oldValue2 = HexUtil.toHex((byte[])oldvalue, (int)0).substring(8, 16);
                String oldValue3 = HexUtil.toHex((byte[])oldvalue, (int)0).substring(16, 24);
                String oldValue4 = HexUtil.toHex((byte[])oldvalue, (int)0).substring(24);
                if (!oldValue1.equals(newValue1)) {
                    memory.sendMemoryUpdateMessage(newValue1, oldValue1, row.getCellAddress(this.cellIX, 11, this.session));
                }
                if (!memory.isError() && !oldValue2.equals(newValue2)) {
                    memory.sendMemoryUpdateMessage(newValue2, oldValue2, row.getCellAddress(this.cellIX, 12, this.session));
                }
                if (!memory.isError() && !oldValue3.equals(newValue3)) {
                    memory.sendMemoryUpdateMessage(newValue3, oldValue3, row.getCellAddress(this.cellIX, 13, this.session));
                }
                if (!memory.isError() && !oldValue4.equals(newValue4)) {
                    memory.sendMemoryUpdateMessage(newValue4, oldValue4, row.getCellAddress(this.cellIX, 14, this.session));
                }
            }
            if (memory.isError()) {
                row.setCellData(oldvalue, this.cellIX);
            }
        }
    }

    public class RegisterTextColumnLabelProvider
    extends ColumnLabelProvider {
        int idx;

        public RegisterTextColumnLabelProvider(int columnIndex) {
            this.idx = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof TreeObject) {
                TreeObject tree = (TreeObject)element;
                return tree.getName();
            }
            return RegisterViewPage.EMPTY;
        }
    }
}

