/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.data;

import com.ca.intertest.common.MemoryRequest;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.Variable;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class RegisterViewRow {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    public static final int CELL_IX_OFFSET = 2;
    public static final int CELL_LENGTH = 4;
    private boolean genregs = false;
    public static final int MAX_LENGTH = 16;
    private final MFAddress address;
    private final ByteBuffer databuffer;
    private final int offset;
    private int cellWords = 1;
    private int rowNum;
    private TreeObject treeobject;

    public RegisterViewRow(TreeObject tree) {
        this.treeobject = tree;
        int stride = Integer.parseInt(tree.getAttribute("stride"));
        this.offset = Integer.parseInt(tree.getAttribute("offset"));
        this.address = tree.getAddress();
        this.databuffer = tree.getBackingdata();
        this.setCellWords(stride / 4);
        this.rowNum = this.offset / (16 * this.cellWords);
        TreeObject parent = tree.getParent();
        if (parent != null && this.cellWords == 2) {
            this.genregs = "REGS".equals(parent.getName());
        }
    }

    public boolean canEditDisplay(int columnIndex) {
        if (this.databuffer == null) {
            return false;
        }
        return ((Buffer)this.databuffer).position(this.offset).remaining() >= 4 * this.cellWords;
    }

    public MFAddress getCellAddress(int colnum, int type, debugSession session) {
        boolean isBatchRegs = MemoryRequest.isBatchRegs(this.treeobject, session);
        if (this.genregs && type == 0) {
            type = 1;
        }
        long off = 0L;
        switch (type) {
            case 0: {
                off = this.rowNum * 16 + colnum * 4;
                break;
            }
            case 1: {
                if (isBatchRegs) {
                    off = this.rowNum * 16 + colnum * 4;
                    break;
                }
                off = this.rowNum * 32 + colnum * 8 + 4;
                break;
            }
            case 2: {
                if (isBatchRegs) {
                    off = this.rowNum * 16 + colnum * 4 + 64;
                    break;
                }
                off = this.rowNum * 32 + colnum * 8;
                break;
            }
            case 11: {
                off = this.rowNum * 64 + colnum * 16;
                break;
            }
            case 12: {
                off = this.rowNum * 64 + colnum * 16 + 4;
                break;
            }
            case 13: {
                off = this.rowNum * 64 + colnum * 16 + 8;
                break;
            }
            case 14: {
                off = this.rowNum * 64 + colnum * 16 + 12;
            }
        }
        return this.address.add(off);
    }

    public byte[] getCellData(int cellIX) {
        if (this.databuffer == null || this.databuffer.limit() == 0) {
            return null;
        }
        try {
            ((Buffer)this.databuffer).position(this.getCellBufferOffset(cellIX));
        }
        catch (Exception exception) {
            return new byte[0];
        }
        int size = Math.min(this.databuffer.remaining(), 4 * (this.genregs ? 1 : this.cellWords));
        byte[] data = new byte[size];
        this.databuffer.get(data);
        return data;
    }

    public String getCellString(int cellIX) {
        byte[] data = this.getCellData(cellIX);
        if (data == null) {
            return Variable.NOT_AVAILABLE;
        }
        return HexUtil.toHex((byte[])data, (int)4, (char)'_');
    }

    public int getLength() {
        int result = ((Buffer)this.databuffer).position(this.offset).remaining();
        return result;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getRowData() {
        ((Buffer)this.databuffer).position(this.offset);
        byte[] data = new byte[this.databuffer.remaining()];
        this.databuffer.get(data);
        return data;
    }

    public void setCellData(byte[] data, int cellIX) {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            ((Buffer)this.databuffer).position(this.getCellBufferOffset(cellIX));
            this.databuffer.put(data);
        }
        catch (Exception exception) {}
    }

    public void setRowData(byte[] value) {
        if (value == null) {
            return;
        }
        ((Buffer)this.databuffer).position(this.offset);
        this.databuffer.put(value);
    }

    public void setRowData(String value) {
        if (value == null) {
            return;
        }
        try {
            ((Buffer)this.databuffer).position(this.offset);
            byte[] data = this.getRowData();
            boolean changed = HexUtil.StringtoBytes((String)value, (byte[])data);
            if (changed) {
                this.setRowData(data);
            }
        }
        catch (Exception exception) {}
    }

    public String toString() {
        String string = String.format("%s (%d)-%s", this.address.toString(), this.offset, HexUtil.toHex((byte[])this.getRowData(), (int)0));
        return string;
    }

    private void setCellWords(int wordcount) {
        if (wordcount == 1 || wordcount == 2 || wordcount == 4) {
            this.cellWords = wordcount;
        }
    }

    public int getCellBufferOffset(int cellIX) {
        return this.offset + cellIX * 4 * this.cellWords + (this.genregs ? 4 : 0);
    }
}

