/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.ui.views.server;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.ui.actions.UpdateServerAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ServerView
extends ViewPart
implements IPropertyChangeListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String DESCRIPTION_TEXT = Messages.ServerView_0;
    public static final String ID = "com.ca.intertest.ui.views.serverview";
    private TableViewer viewer;
    private ServerList servers;
    private static final String COL_ORDER = "column_order";
    private static final String COL_WIDTH = "column_width";
    private static final String COL_COUNT = "column_count";
    private static final int SERVER_STATUS = 0;
    private static final int SERVER_NAME = 1;
    private static final int SERVER_HOST = 2;
    private static final int SERVER_PORT = 3;
    private static final int SERVER_USER = 4;
    private static final int SERVER_TYPE = 5;
    private static final int SERVER_DEFAULT = 6;
    private static final int DELAY_TIME = 50;
    private static final String[] labels = new String[]{Messages.ServerView_status, Messages.ServerView_name, Messages.ServerView_host, Messages.ServerView_port, Messages.ServerView_userid, Messages.ServerView_type, Messages.ServerView_default};
    private static final int[] styles = new int[]{0x1000000, 16384, 16384, 131072, 16384, 16384, 16384};
    private static final int[] Column_width = new int[]{10, 20, 20, 6, 8, 12, 6};
    private int[] order;
    private static final String CONTEXT_HELP_ID = "com.ca.intertest.serversview";
    private int[] width;

    public ServerView() {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        this.order = nArray;
        this.width = null;
    }

    public void createPartControl(Composite parent) {
        this.checkWidth((Control)parent);
        this.servers = ServerList.getInstance();
        this.viewer = new TableViewer(parent, 66306);
        Table table = this.viewer.getTable();
        int i = 0;
        while (i < labels.length) {
            TableColumn column = new TableColumn(table, styles[i]);
            column.setText(labels[i]);
            column.setWidth(this.width[i]);
            column.setMoveable(true);
            column.setResizable(true);
            ++i;
        }
        table.setColumnOrder(this.order);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider(this.servers));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        ITCellmodifier cellModifier = new ITCellmodifier();
        CellEditor[] cellEditors = new CellEditor[table.getColumnCount()];
        cellEditors[1] = new TextCellEditor((Composite)table);
        cellEditors[3] = new TextCellEditor((Composite)table);
        Text text = (Text)cellEditors[3].getControl();
        text.addVerifyListener((VerifyListener)new verifyDigit(false));
        cellEditors[2] = new TextCellEditor((Composite)table);
        cellEditors[4] = new TextCellEditor((Composite)table);
        this.viewer.setCellEditors(cellEditors);
        this.viewer.setCellModifier((ICellModifier)cellModifier);
        this.viewer.setColumnProperties(labels);
        this.viewer.setInput((Object)this.servers);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookDoubleClickAction();
        this.registerContextMenu();
        this.setTitleToolTip(DESCRIPTION_TEXT);
        this.setContentDescription(DESCRIPTION_TEXT);
        this.servers.addPropertyChangeListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
    }

    private void registerContextMenu() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.add((IContributionItem)new Separator("com.ca.intertest.viewcontribution.server"));
        manager.add((IContributionItem)new Separator("com.ca.intertest.viewcontribution.serveradmin"));
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        UpdateServerAction listener = new UpdateServerAction();
        listener.init((IViewPart)this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)listener);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void saveState(IMemento memento) {
        Table table = this.viewer.getTable();
        memento.putInteger(COL_COUNT, table.getColumnCount());
        StringBuilder colstring = new StringBuilder();
        int[] nArray = table.getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int item = nArray[n2];
            colstring.append(String.format("%d;", item));
            ++n2;
        }
        colstring.setLength(colstring.length() - 1);
        memento.putString(COL_ORDER, colstring.toString());
        TableColumn[] columns = table.getColumns();
        colstring = new StringBuilder();
        TableColumn[] tableColumnArray = columns;
        int n3 = columns.length;
        n = 0;
        while (n < n3) {
            TableColumn col = tableColumnArray[n];
            colstring.append(String.format("%d;", col.getWidth()));
            ++n;
        }
        colstring.setLength(colstring.length() - 1);
        memento.putString(COL_WIDTH, colstring.toString());
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            Integer count = memento.getInteger(COL_COUNT);
            if (count == null) {
                count = labels.length;
            }
            if (count == labels.length) {
                int i;
                String colstring = memento.getString(COL_ORDER);
                if (colstring != null) {
                    String[] colorder = colstring.split(";");
                    this.order = new int[colorder.length];
                    i = 0;
                    while (i < colorder.length) {
                        this.order[i] = Integer.parseInt(colorder[i]);
                        ++i;
                    }
                }
                if ((colstring = memento.getString(COL_WIDTH)) != null) {
                    String[] colwidth = colstring.split(";");
                    this.width = new int[colwidth.length];
                    i = 0;
                    while (i < colwidth.length) {
                        this.width[i] = Integer.parseInt(colwidth[i]);
                        ++i;
                    }
                }
            }
        }
        super.init(site, memento);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void checkWidth(Control parent) {
        if (this.width == null && parent != null) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[Column_width.length];
            int j = 0;
            while (j < Column_width.length) {
                this.width[j] = Column_width[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event != null) {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            String property = event.getProperty();
            final Object source = event.getSource();
            if (source instanceof ServerElement && "Name".equals(property)) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!workbench.isClosing() && ServerView.this.viewer != null && !ServerView.this.viewer.getControl().isDisposed()) {
                            ServerView.this.viewer.refresh();
                            ServerView.this.viewer.setSelection((ISelection)new StructuredSelection(source));
                            ServerView.this.viewer.getTable().showSelection();
                        }
                    }
                });
                return;
            }
            if (source instanceof ServerElement && "StatusText".equals(property)) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!workbench.isClosing() && ServerView.this.viewer != null && !ServerView.this.viewer.getControl().isDisposed()) {
                            ServerView.this.viewer.refresh(source);
                        }
                    }
                });
                return;
            }
        }
    }

    private final class ITCellmodifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            switch (this.getColumn(property)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            switch (this.getColumn(property)) {
                case 3: {
                    return Integer.toString(((ServerElement)element).getPort());
                }
                case 2: {
                    return ((ServerElement)element).getHostname();
                }
                case 4: {
                    return ((ServerElement)element).getUser();
                }
                case 1: {
                    return ((ServerElement)element).getName();
                }
                case 6: {
                    if (((ServerElement)element).isDefaultserver()) {
                        return "Yes";
                    }
                    return "";
                }
            }
            return element.toString();
        }

        public void modify(Object element, String property, Object value) {
            ServerElement server = (ServerElement)((TableItem)element).getData();
            String name = value.toString().trim();
            switch (this.getColumn(property)) {
                case 3: {
                    if (name.length() == 0) break;
                    try {
                        int port = Integer.parseInt(name);
                        if (port == server.getPort() || port < 0 || port > 65535) break;
                        server.setPort(port);
                        server.checkStatus(50L);
                    }
                    catch (NumberFormatException e) {
                        Logger.loggit(e);
                    }
                    break;
                }
                case 1: {
                    if (name.length() == 0 || name.equals(server.getName())) break;
                    server.setName(name);
                    break;
                }
                case 2: {
                    if (name.length() == 0 || name.equals(server.getHostname())) break;
                    server.setHostname(name);
                    server.checkStatus(50L);
                    break;
                }
                case 4: {
                    if (name.equals(server.getUser())) break;
                    server.setUser(name);
                    server.checkStatus(50L);
                    break;
                }
                case 6: {
                    if (name.equalsIgnoreCase("Y") || name.equalsIgnoreCase("YES")) {
                        server.setDefaultserver(true);
                        break;
                    }
                    server.setDefaultserver(false);
                    break;
                }
            }
        }

        private int getColumn(String property) {
            int i = labels.length - 1;
            while (i > -1) {
                if (labels[i].equals(property)) {
                    return i;
                }
                --i;
            }
            return -1;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ServerElement element1 = (ServerElement)e1;
            ServerElement element2 = (ServerElement)e2;
            return element1.compareTo(element2);
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        private IPropertyChangeListener changelistener;
        private ServerList servers;

        public ViewContentProvider(ServerList servers) {
            this.servers = servers;
            this.changelistener = new IPropertyChangeListener(){

                public void propertyChange(final PropertyChangeEvent event) {
                    if (event == null) {
                        return;
                    }
                    String property = event.getProperty();
                    Display display = ServerView.this.viewer.getControl().getDisplay();
                    if (display.isDisposed()) {
                        return;
                    }
                    if (property.equalsIgnoreCase(Messages.ServerView_Status)) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ServerView.this.viewer.refresh(event.getSource());
                            }
                        });
                    } else if (property.equals(ServerView.ID)) {
                        if (event.getOldValue() != null && event.getNewValue() == null) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ServerView.this.viewer.remove(event.getOldValue());
                                }
                            });
                        } else if (event.getOldValue() == null && event.getNewValue() != null) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ServerView.this.viewer.add(event.getNewValue());
                                    ServerView.this.viewer.setSelection((ISelection)new StructuredSelection(event.getNewValue()));
                                    ServerView.this.viewer.getTable().showSelection();
                                }
                            });
                        }
                    } else if (event.getOldValue() != event.getNewValue() && event.getOldValue() != null) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ServerView.this.viewer.refresh(event.getSource());
                            }
                        });
                    }
                }
            };
            servers.addPropertyChangeListener(this.changelistener);
            for (ServerElement item : servers.getServerElements()) {
                item.addPropertyChangeListener(this.changelistener);
                item.checkStatus(50L);
            }
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
            this.servers.removeChangeListener(this.changelistener);
            for (ServerElement item : this.servers.getServerElements()) {
                item.removePropertyChangeListener(this.changelistener);
            }
        }

        public Object[] getElements(Object parent) {
            return this.servers.getServerElements().toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ServerElement element = (ServerElement)obj;
            switch (index) {
                case 0: {
                    return element.getStatusText();
                }
                case 1: {
                    return element.getName();
                }
                case 2: {
                    return element.getHostname();
                }
                case 3: {
                    return Integer.toString(element.getPort());
                }
                case 4: {
                    return element.getUser();
                }
                case 5: {
                    return Messages.ServerView_intertest_server;
                }
                case 6: {
                    if (element.isDefaultserver()) {
                        return "Yes";
                    }
                    return "";
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                default: 
            }
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

