/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.TextUtil;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.verifyDigit;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.wizards.AbstractBreakpointWizard;
import com.ca.intertest.wizards.CICSLineBreakpointWizard;
import com.ca.intertest.wizards.ConditionalBreakpointPage;
import com.ca.intertest.wizards.IBreakpointPage;
import com.ca.intertest.wizards.ParagraphsBreakpointPage;
import com.ca.intertest.wizards.UnconditionalBreakpointPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractBreakpointPage
extends WizardPage
implements IBreakpointPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected static final String[] constants = IConstants.COBOL_CONSTANTS;
    protected static final String[] keywords = IConstants.CICS_CBP_COREKEYWORDS;
    protected static final String[] literals = IConstants.LITERALS;
    protected static final String[] operators = IConstants.OPERATOR_TEXTS;
    protected static final String[] registers = IConstants.CICS_CBP_REGISTERS;
    private static final String TITLE_FORMAT = Messages.AbstractBreakpointPage_0;
    private static final String TITLE_FORMAT_LINE = String.valueOf(TITLE_FORMAT) + Messages.AbstractBreakpointPage_1;
    protected Map<String, Object> attributes;
    protected Button checkDropMonitor = null;
    protected Button chkStopAfter = null;
    protected Button checkNewBP = null;
    protected String mrkrType;
    protected Group radiobuttons;
    protected Text textSkip = null;
    protected Button thisbutton = null;
    protected AbstractBreakpointWizard wizard;
    protected WizardDialog wizarddialog;
    protected static final String SAVED_IX = Messages.AbstractBreakpointPage_2;
    protected static final String SAVED_ARRAY = Messages.AbstractBreakpointPage_3;
    protected static final String SAVED_STRING = Messages.AbstractBreakpointPage_4;
    protected static final String SAVED_UPPERCASE = Messages.AbstractBreakpointPage_5;
    protected static final int COMBO_STYLE = 2816;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.abstractBreakpointPage";

    protected AbstractBreakpointPage(AbstractBreakpointWizard wizard, String pageName, String mrkrType) {
        this(pageName, String.format(wizard.isGlobal() ? TITLE_FORMAT : TITLE_FORMAT_LINE, pageName, wizard.getDebugfile().getName(), wizard.getStmtNumber()), null);
        this.wizard = wizard;
        this.attributes = wizard.getAttributes();
    }

    private AbstractBreakpointPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.radiobuttons = new Group(composite, 0);
        layout = new GridLayout(this.wizard.getBreakpointpages().length, false);
        this.radiobuttons.setLayout((Layout)layout);
        this.radiobuttons.setText(Messages.AbstractBreakpointPage_7);
        AbstractBreakpointPage[] abstractBreakpointPageArray = this.wizard.getBreakpointpages();
        int n = abstractBreakpointPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBreakpointPage item = abstractBreakpointPageArray[n2];
            Button radio = new Button((Composite)this.radiobuttons, 16);
            radio.setText(item.getName());
            if (this == item) {
                radio.setSelection(this == item);
                this.thisbutton = radio;
            } else {
                radio.setSelection(false);
            }
            radio.setData((Object)item);
            radio.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    if (button.getSelection()) {
                        AbstractBreakpointPage newpage = (AbstractBreakpointPage)button.getData();
                        if (newpage != AbstractBreakpointPage.this) {
                            WizardDialog wizarddialog = (WizardDialog)AbstractBreakpointPage.this.getContainer();
                            wizarddialog.showPage((IWizardPage)newpage);
                        }
                        return;
                    }
                }
            });
            ++n2;
        }
        Composite options = new Composite(composite, 0);
        layout = new GridLayout(1, false);
        options.setLayout((Layout)layout);
        this.setOptions(options);
        this.setFixedOptions(options);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.abstractBreakpointPage");
        this.setControl((Control)composite);
        this.notifyButton(this.thisbutton);
    }

    protected void notifyButton(Button button) {
        Event event = new Event();
        event.widget = button;
        button.notifyListeners(13, event);
    }

    public abstract String getName();

    public boolean isPageComplete() {
        if (this.textSkip == null) {
            return true;
        }
        String string = this.textSkip.getText();
        if (string.length() > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages.AbstractBreakpointPage_8);
                return false;
            }
        }
        this.showLocation();
        this.setErrorMessage(null);
        return true;
    }

    public abstract BreakpointMessage performFinish();

    public void setVisible(boolean visible) {
        if (visible && this.thisbutton != null) {
            this.preLoadOptions();
            Control[] controlArray = this.radiobuttons.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control item = controlArray[n2];
                if (item instanceof Button) {
                    ((Button)item).setSelection(item == this.thisbutton);
                    this.notifyButton(this.thisbutton);
                }
                ++n2;
            }
        }
        super.setVisible(visible);
        this.showLocation();
    }

    protected void showLocation() {
        if (!this.wizard.isGlobal()) {
            this.setDescription(this.getLocation());
        }
    }

    protected void addConstants(ArrayList<String> items) {
        String[] stringArray = constants;
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            items.add(item);
            ++n2;
        }
    }

    protected void addCoreKeywords(ArrayList<String> items) {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            items.add(item);
            ++n2;
        }
    }

    protected void addLiterals(ArrayList<String> items) {
        String[] stringArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            items.add(item);
            ++n2;
        }
    }

    protected void addRegisters(ArrayList<String> items) {
        String[] stringArray = registers;
        int n = registers.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            items.add(item);
            ++n2;
        }
    }

    protected void addSortedVariables(ArrayList<String> items) {
        items.addAll(this.wizard.getVariableNames());
        Collections.sort(items);
    }

    protected String[] getSortedVariables() {
        ArrayList<String> itemsList = new ArrayList<String>();
        this.addSortedVariables(itemsList);
        return itemsList.toArray(new String[itemsList.size()]);
    }

    protected String[] getLeftItems() {
        ArrayList<String> itemsList = new ArrayList<String>();
        this.addSortedVariables(itemsList);
        if (this.wizard.isCICS()) {
            this.addCoreKeywords(itemsList);
            this.addRegisters(itemsList);
        }
        return itemsList.toArray(new String[itemsList.size()]);
    }

    protected String getLocation() {
        Map<String, Object> attributes = this.wizard.getAttributes();
        String format = Messages.AbstractBreakpointPage_10;
        String stmt = (String)attributes.get("source");
        if (stmt == null) {
            stmt = "";
            attributes.put("source", stmt);
        }
        return String.format(format, this.wizard.getStmtNumber(), stmt);
    }

    protected String getMarkerMessage(String type) {
        StringBuilder msg = new StringBuilder(String.valueOf(type) + ": ");
        msg.append(this.wizard.getDebugfile().getName());
        Object stmnt = this.attributes.get("stmtNumber");
        if (stmnt != null) {
            msg.append(" [Statement: " + this.attributes.get("stmtNumber").toString() + "]");
        }
        msg.append(" - " + this.attributes.get("source"));
        this.attributes.put("message", msg.toString());
        return msg.toString();
    }

    protected String[] getRightItems() {
        ArrayList<String> itemsList = new ArrayList<String>();
        if (this.wizard.isCICS()) {
            this.addLiterals(itemsList);
            this.addCoreKeywords(itemsList);
            this.addRegisters(itemsList);
        } else {
            if (itemsList.isEmpty()) {
                itemsList.add(Messages.AbstractBreakpointPage_16);
            }
            this.addSortedVariables(itemsList);
            String[] stringArray = IConstants.COBOL_CONSTANTS;
            int n = IConstants.COBOL_CONSTANTS.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                itemsList.add(str);
                ++n2;
            }
            itemsList.add("X'hex'");
        }
        String[] items = new String[itemsList.size()];
        itemsList.toArray(items);
        return items;
    }

    protected int getSelectionIndex(Combo combo, String variable) {
        String upper = null;
        int ix = -1;
        if (variable == null) {
            return ix;
        }
        ix = combo.indexOf(variable);
        if (ix >= 0) {
            return ix;
        }
        upper = variable.toUpperCase();
        ix = combo.indexOf(upper);
        if (ix < 0) {
            combo.setText(variable);
        }
        return ix;
    }

    protected int matchItem(String[] items) {
        int ix = 0;
        String source = (String)this.attributes.get("source");
        if (source == null) {
            return ix;
        }
        String var = null;
        String[] parts = source.split("[\\s.]");
        List<String> names = this.wizard.getVariableNames();
        String upperCase = null;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            upperCase = part.toUpperCase();
            if (names.contains(upperCase)) {
                var = part;
                break;
            }
            ++n2;
        }
        if (var != null) {
            int i = 0;
            while (i < items.length) {
                if (upperCase.endsWith(items[i])) {
                    return i;
                }
                ++i;
            }
        }
        return ix;
    }

    protected void setFixedOptions(Composite options) {
        GridData gridData = new GridData(0, 0, false, false);
        gridData.verticalAlignment = 0x1000000;
        Group optGroup = new Group(options, 0);
        optGroup.setLayoutData((Object)gridData);
        optGroup.setLayout((Layout)new GridLayout(3, false));
        optGroup.setText(Messages.AbstractBreakpointPage_18);
        this.chkStopAfter = new Button((Composite)optGroup, 32);
        gridData = new GridData(0, 0, false, false);
        gridData.verticalAlignment = 0x1000000;
        this.chkStopAfter.setLayoutData((Object)gridData);
        this.chkStopAfter.setSelection(false);
        this.chkStopAfter.setText(Messages.AbstractBreakpointPage_19);
        if (this instanceof UnconditionalBreakpointPage) {
            Label labelSkip = new Label((Composite)optGroup, 0);
            gridData = new GridData(0, 0, false, false);
            gridData.verticalAlignment = 0x1000000;
            gridData.horizontalAlignment = 0x1000008;
            labelSkip.setLayoutData((Object)gridData);
            labelSkip.setText(Messages.AbstractBreakpointPage_20);
            this.textSkip = new Text((Composite)optGroup, 2048);
            gridData = new GridData(0, 0, false, false);
            gridData.horizontalAlignment = 0x1000008;
            gridData.verticalAlignment = 0x1000000;
            this.textSkip.setLayoutData((Object)gridData);
            this.textSkip.setTextLimit(8);
            this.textSkip.setText("0");
            this.textSkip.addVerifyListener((VerifyListener)new verifyDigit(false));
            TextUtil.setWidth(this.textSkip, 4, 4);
        }
        if (this.wizard.isCICS()) {
            if (!(this instanceof ParagraphsBreakpointPage) && !(this instanceof UnconditionalBreakpointPage)) {
                this.checkDropMonitor = new Button((Composite)optGroup, 32);
                this.checkDropMonitor.setLayoutData((Object)new GridData(4, 0, false, false));
                this.checkDropMonitor.setSelection(false);
                this.checkDropMonitor.setText(Messages.AbstractBreakpointPage_22);
                gridData = new GridData(0, 0, false, false);
                gridData.horizontalSpan = 3;
                this.checkDropMonitor.setLayoutData((Object)gridData);
            }
            if (this.wizard instanceof CICSLineBreakpointWizard) {
                boolean showNewBP = false;
                boolean cbpExists = ((CICSLineBreakpointWizard)this.wizard).isCbpExists();
                boolean ubpExists = ((CICSLineBreakpointWizard)this.wizard).isUbpExists();
                if (this instanceof ConditionalBreakpointPage) {
                    showNewBP = cbpExists || ubpExists;
                } else if (ubpExists) {
                    showNewBP = false;
                } else if (cbpExists && !ubpExists) {
                    showNewBP = true;
                }
                if (showNewBP) {
                    this.checkNewBP = new Button((Composite)optGroup, 32);
                    this.checkNewBP.setLayoutData((Object)new GridData(4, 0, false, false));
                    this.checkNewBP.setText(Messages.AbstractBreakpointPage_23);
                    this.checkNewBP.setSelection(false);
                }
            }
        }
    }

    protected abstract void setOptions(Composite var1);

    @Override
    public boolean canFinish() {
        return this.isPageComplete();
    }

    @Override
    public boolean getDropMonitoring() {
        return this.checkDropMonitor.getSelection();
    }

    @Override
    public Integer getSkipCount() {
        if (this.textSkip == null) {
            return 0;
        }
        try {
            return Integer.decode(this.textSkip.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return new Integer(0);
        }
    }

    @Override
    public boolean getStopAfter() {
        return this.chkStopAfter.getSelection();
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    protected void setComboData(SelectionEvent e, Combo varCombo) {
        Button button = (Button)e.getSource();
        if (button.getSelection()) {
            varCombo.setItems((String[])button.getData(SAVED_ARRAY));
            try {
                int ix = (Integer)button.getData(SAVED_IX);
                if (ix < 0) {
                    String result = (String)button.getData(SAVED_STRING);
                    varCombo.setText(result);
                }
                varCombo.select(ix);
            }
            catch (NumberFormatException numberFormatException) {
                varCombo.select(0);
            }
        } else {
            int ix = varCombo.getSelectionIndex();
            if (ix < 0) {
                String result = varCombo.getText();
                if (((Boolean)button.getData(SAVED_UPPERCASE)).booleanValue()) {
                    result = result.toUpperCase();
                }
                if ((ix = varCombo.indexOf(result)) >= 0) {
                    varCombo.select(ix);
                }
                button.setData(SAVED_STRING, (Object)result);
            }
            button.setData(SAVED_IX, (Object)new Integer(ix));
        }
    }

    public abstract void preLoad();

    public void preLoadOptions() {
        boolean stop = Boolean.parseBoolean(this.attributes.get("stop_after").toString());
        this.chkStopAfter.setSelection(stop);
        Integer skip = (Integer)this.attributes.get("skip_count");
        if (skip != null && this.textSkip != null) {
            this.textSkip.setText(skip.toString());
        }
        if (this.wizard.isCICS() && this.checkDropMonitor != null) {
            Boolean drop = (Boolean)this.attributes.get("drop_monitoring");
            if (drop != null && this.checkDropMonitor != null) {
                this.checkDropMonitor.setSelection(drop.booleanValue());
            } else {
                this.checkDropMonitor.setSelection(false);
            }
        }
    }

    protected ArrayList<TreeObject> getTreeList(String variable) {
        HashMap<String, ArrayList<TreeObject>> map = this.wizard.getEditor().getOutline().getNames();
        ArrayList<TreeObject> treeList = map.get(variable);
        if (treeList == null) {
            variable = variable.toUpperCase();
            treeList = map.get(variable);
        }
        return treeList;
    }

    protected Integer getVariableLength(String variable) {
        ArrayList<TreeObject> treeList = this.getTreeList(variable);
        if (treeList == null) {
            return 0;
        }
        TreeObject to = treeList.get(0);
        return (Integer)Attribute.getValue("length", to);
    }

    protected boolean isConstant(String constant) {
        String[] stringArray = constants;
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(constant)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void performBaseFinish() {
        if (this.chkStopAfter != null) {
            this.attributes.put("stop_after", this.chkStopAfter.getSelection());
        } else {
            this.attributes.put("stop_after", false);
        }
        String skip = null;
        if (this.textSkip != null) {
            skip = this.textSkip.getText();
            if (skip == null || skip.length() <= 0) {
                skip = "0";
            }
        } else {
            skip = "0";
        }
        this.attributes.put("skip_count", Integer.parseInt(skip));
        if (this.wizard.isCICS() && this.checkDropMonitor != null) {
            this.attributes.put("drop_monitoring", this.checkDropMonitor.getSelection());
        }
    }

    protected int getArrayIndex(String[] items, String var) {
        int ix = 0;
        int i = 0;
        while (i < items.length) {
            if (var.equals(items[i])) {
                ix = i;
                break;
            }
            ++i;
        }
        return ix;
    }

    public boolean isNewBP() {
        if (this.checkNewBP != null) {
            return this.checkNewBP.getSelection();
        }
        return false;
    }
}

