/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.debugCICSSession;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.wizards.AbstractSettingsPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CICSSettingsPage
extends AbstractSettingsPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Text CICSUser;
    private Text TermID;
    private Text CICSApplID;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.cicsSettingsPage";

    public CICSSettingsPage(String pageName) {
        super(pageName);
    }

    public CICSSettingsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.startCreateControl(parent);
        Group serverGroup2 = new Group(composite, 0);
        serverGroup2.setLayout((Layout)new GridLayout());
        serverGroup2.setLayoutData((Object)new GridData(4, 0, true, false));
        serverGroup2.setText(Messages.CICSSettingsPage_1);
        debugCICSSession wizardCICSSession = (debugCICSSession)this.wizard.getSession();
        this.CICSApplID = new Text((Composite)serverGroup2, 2060);
        this.CICSApplID.setLayoutData((Object)new GridData(4, 4, true, false));
        this.CICSApplID.setText(wizardCICSSession.getApplID());
        if (wizardCICSSession.isDebugging()) {
            this.CICSApplID.setEnabled(false);
        } else {
            this.CICSApplID.setEnabled(true);
            this.CICSApplID.setEditable(true);
        }
        this.CICSApplID.addModifyListener(this.modifylistener);
        this.CICSApplID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CICSSettingsPage.this.setErrorMessage(null);
            }
        });
        this.createSettings(composite);
        this.setOptions(composite);
        this.endCreateControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.cicsSettingsPage");
    }

    @Override
    public void saveSetupGroup() {
        this.wizard.setApplID(this.CICSApplID.getText());
        String userid = this.CICSUser.getText().trim();
        if (userid.length() == 0) {
            userid = ".ANY";
        }
        this.wizard.put("userid", userid);
        String termid = this.TermID.getText().trim();
        if (termid.length() == 0) {
            termid = ".ANY";
        }
        this.wizard.put("termid", termid);
    }

    @Override
    protected boolean validatePage() {
        if (this.CICSApplID.getText() == null || this.CICSApplID.getText().isEmpty()) {
            this.setMessage(Messages.CICSSettingsPage_5, 2);
            return false;
        }
        boolean ok = super.validatePage();
        if (ok && this.session.isDebugging()) {
            this.setMessage(Messages.CICSSettingsPage_6, 1);
        }
        return ok;
    }

    @Override
    protected boolean validateSubmit() {
        if (this.CICSApplID.getText() == null || this.CICSApplID.getText().isEmpty()) {
            this.setErrorMessage(Messages.CICSSettingsPage_8);
            this.CICSApplID.setFocus();
            return false;
        }
        if (!this.session.isDataMonitorOK()) {
            String msg;
            boolean found = false;
            for (debugFile file : this.session.getMonitored(true)) {
                if (!file.isStatementTrace() || !file.isDataMonitor()) continue;
                found = true;
                break;
            }
            if (found) {
                msg = Messages.CICSSettingsPage_11;
                this.setMessage(msg, 2);
            } else {
                msg = Messages.CICSSettingsPage_users_warning;
                this.setMessage(msg, 2);
            }
        }
        return super.validateSubmit();
    }

    @Override
    protected void setOptionalButtons(Composite composite) {
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(settingsGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0, true, false));
        label.setText(Messages.CICSSettingsPage_12);
        this.CICSUser = new Text(settingsGroup, 2048);
        GridData griddata = new GridData(16384, 0, false, false);
        griddata.widthHint = griddata.minimumWidth = this.convertWidthInCharsToPixels(16);
        this.CICSUser.setLayoutData((Object)griddata);
        String userid = this.wizard.get("userid").trim();
        if (userid.length() == 0) {
            userid = ".ANY";
        }
        this.CICSUser.setText(userid);
        this.CICSUser.setTextLimit(8);
        this.CICSUser.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.CICSUser.addModifyListener(this.modifylistener);
        this.CICSUser.setEnabled(!this.session.isDebugging());
        label = new Label(settingsGroup, 0);
        label.setLayoutData((Object)new GridData(131072, 0, true, false));
        label.setText(Messages.CICSSettingsPage_14);
        this.TermID = new Text(settingsGroup, 2048);
        String termid = this.wizard.get("termid").trim();
        if (termid.length() == 0) {
            termid = ".ANY";
        }
        this.TermID.setText(termid);
        this.TermID.setTextLimit(4);
        griddata = new GridData(16384, 0, false, false);
        griddata.widthHint = griddata.minimumWidth = this.convertWidthInCharsToPixels(7);
        this.TermID.setLayoutData((Object)griddata);
        this.TermID.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.TermID.addModifyListener(this.modifylistener);
        this.TermID.setEnabled(!this.session.isDebugging());
    }

    @Override
    protected boolean isBatch() {
        return false;
    }

    @Override
    protected boolean isCICS() {
        return true;
    }

    @Override
    protected void createSettings(Composite composite) {
    }

    public boolean isPageComplete() {
        return this.validatePage() ? this.changed : false;
    }

    public String getApplID() {
        return this.CICSApplID.getText();
    }
}

