/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.MemoryUpdate;
import com.ca.intertest.common.verifyFixed;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITHexUtilException;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import com.ca.intertest.wizards.CoreDumpRow;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class CharacterCellEditingSupport
extends BasicEditingSupport {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected final debugSession session;

    public CharacterCellEditingSupport(ColumnViewer viewer, debugSession sess, debugFile debugfile, int columnIndex) {
        super(viewer, sess, debugfile, columnIndex);
        this.session = sess;
    }

    @Override
    protected boolean canEdit(Object element) {
        if (this.isBackTraceStop()) {
            return false;
        }
        return this.session.isAtBreakpoint() && element instanceof CoreDumpRow;
    }

    @Override
    protected CellEditor getCellEditor(Object element) {
        TextCellEditor dataCellEditor = new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
        dataCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                return null;
            }
        });
        Text text = (Text)dataCellEditor.getControl();
        text.setMenu(this.getViewer().getControl().getMenu());
        text.addVerifyListener((VerifyListener)new verifyFixed());
        CoreDumpRow row = (CoreDumpRow)element;
        text.setTextLimit(row.getRowData().length);
        this.setEditorFont((CellEditor)dataCellEditor);
        return dataCellEditor;
    }

    @Override
    protected Object getValue(Object element) {
        return HexUtil.toString((byte[])((CoreDumpRow)element).getRowData(), (boolean)true);
    }

    @Override
    protected void setValue(Object element, Object value) {
        if (value == null || value.equals(this.getValue(element))) {
            return;
        }
        CoreDumpRow row = (CoreDumpRow)element;
        byte[] oldvalue = row.getRowData();
        byte[] newvalue = (byte[])oldvalue.clone();
        try {
            if (HexUtil.StringtoBytes((String)value.toString(), (byte[])newvalue)) {
                String hOldvalue = HexUtil.toHex((byte[])oldvalue, (int)0);
                String hNewvalue = HexUtil.toHex((byte[])newvalue, (int)0);
                MemoryUpdate memory = new MemoryUpdate(this.session);
                memory.sendMemoryUpdateMessage(hNewvalue, hOldvalue, row.getAddress());
                if (!memory.isError()) {
                    row.setRowData(newvalue);
                }
            }
        }
        catch (ITHexUtilException e) {
            Logger.loggit(e);
        }
    }
}

