/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.MonitorMessage;
import com.ca.intertest.debug.SignonMessage;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.MRUCombo;
import com.ca.intertest.server.CICSConnection;
import com.ca.intertest.server.Connection;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.tools.CSect;
import com.ca.intertest.tools.CompositeErrorMessage;
import com.ca.intertest.tools.CompositeListMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.GetCompositeMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.StatusMessage;
import com.ca.intertest.tools.SynchSymbolicMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import com.ca.intertest.ui.views.data.BasicEditingSupport;
import com.ca.intertest.wizards.CompositeSetupWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import com.ca.intertest.wizards.NewItemWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CompositeSetupPage
extends WizardPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String COL_COUNT = "column_count";
    private static final String COL_ORDER = "column_order";
    private static final String COL_WIDTH = "column_width";
    private static final int CSECT = 0;
    private static final String CSECT_TITLE = Messages.CompositeSetupPage_5;
    private static final int MONITORNAME = 1;
    private static final String MONITORNAME_TITLE = Messages.CompositeSetupPage_6;
    private static final int OFFSET = 2;
    private static final String OFFSET_TITLE = Messages.CompositeSetupPage_7;
    private static final int LENGTH = 3;
    private static final String LENGTH_TITLE = Messages.CompositeSetupPage_8;
    private static final int LANGUAGE = 4;
    private static final String LANGUAGE_TITLE = Messages.CompositeSetupPage_9;
    private static final int COMMENT = 5;
    private static final String COMMENT_TITLE = Messages.CompositeSetupPage_10;
    private static final int[] styles = new int[]{16384, 16384, 16384, 16384, 16384, 16384};
    private static final int[] COLUMN_WIDTHS = new int[]{8, 8, 6, 6, 5, 20};
    private static final String[] labels = new String[]{CSECT_TITLE, MONITORNAME_TITLE, OFFSET_TITLE, LENGTH_TITLE, LANGUAGE_TITLE, COMMENT_TITLE};
    private CICSConnection connection;
    private ArrayList<CSect> csects;
    private debugFile file;
    private debugSession session;
    private int[] order;
    private ServerElement server;
    private IDialogSettings settings;
    private Table table;
    private CheckboxTableViewer viewer;
    private CompositeType type;
    private SignonMessage signon;
    private InitMessage initmessage;
    private SynchSymbolicMessage synchsymbol;
    private boolean post;
    private boolean oldsymsynch;
    private Shell shell;
    private IStructuredContentProvider rowData;
    Group searchGroup;
    Composite tableGroup;
    Group filterGroup;
    Composite filterButtonGroup;
    private String searchText;
    private MRUCombo searchList;
    private ArrayList<CSect> filteredCsects;
    private Button searchButton;
    private Button filterButton;
    private Button resetButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Text[] filters;
    private Label numRowsLabel;
    ArrayList<CSect> monCsects;
    private boolean isComplete;
    private boolean isMultiCsectSupportProblem;
    private boolean isFilterProblem;
    private boolean tryingAgain;
    private boolean resetComments;
    private int selectionIndex;
    private int columnIndex;
    private int topIndex;
    private TableViewerColumn[] tableViewerColumns;
    private boolean isSymbolicCheck;
    private boolean symbolicCheckPassed;
    private static final String CONTEXT_HELP_ID = "com.ca.intertest.compositesetup";
    private int[] width;

    protected CompositeSetupPage(String pageName) {
        super(pageName);
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        this.order = nArray;
        this.settings = null;
        this.synchsymbol = null;
        this.post = false;
        this.oldsymsynch = Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/option/oldsymsynch"));
        this.monCsects = new ArrayList();
        this.tryingAgain = false;
        this.resetComments = true;
        this.selectionIndex = 0;
        this.columnIndex = -1;
        this.topIndex = 0;
        this.isSymbolicCheck = false;
        this.symbolicCheckPassed = false;
        this.width = null;
    }

    public boolean cancel() {
        this.saveWidgetValues();
        return true;
    }

    public int countNames(String data) {
        if (data == null || data.length() == 0) {
            return 0;
        }
        int count = 0;
        for (CSect csect : this.csects) {
            if (!this.monCsects.contains(csect) || !csect.getMonitorName().equals(data)) continue;
            ++count;
        }
        return count;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.shell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.restoreWidgetValues();
        this.checkWidth(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.server = this.file.getSession().getServer();
        this.connection = new CICSConnection(this.server, this.session);
        this.connection.setFile(this.file);
        try {
            this.signon = new SignonMessage(this.server);
            this.initmessage = new InitMessage(this.session);
            this.buildRegular(composite);
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.viewer = null;
        }
        if (this.tryingAgain) {
            return;
        }
        if (this.viewer == null) {
            StyledText text = new StyledText(parent, 0);
            text.setText(Messages.CompositeSetupPage_11);
            this.setControl((Control)text);
        } else {
            this.setControl(this.viewer.getControl());
        }
    }

    private void buildRegular(Composite parent) throws Exception {
        int n;
        CVMO cvmo = new CVMO();
        this.connection = (CICSConnection)this.session.getConnection();
        this.connection.connect(false);
        String fileName = this.file.getName();
        if (this.connection.getErrorLevel() == 0) {
            CVMI cvmi = new CVMI();
            cvmi.addMessage((DebugMessage)this.signon);
            cvmi.addMessage((DebugMessage)this.initmessage);
            cvmi.addMessage((DebugMessage)new GetCompositeMessage(fileName));
            cvmo = this.connection.process(cvmi);
        }
        if (this.connection.getErrorLevel() != 0) {
            String mainProgramName = "";
            int rc = 1;
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n2 = debugMessageArray.length;
            n = 0;
            while (n < n2) {
                DebugMessage msg = debugMessageArray[n];
                switch (msg.getMessageID()) {
                    case 18: {
                        String status = ((StatusMessage)msg).getMessage();
                        if (!status.equalsIgnoreCase("COMPOSITE REQUEST FAILED")) break;
                        CSect cs = new CSect();
                        cs.setMonitorName(fileName);
                        this.checkForSymbolics(cs);
                        if (this.symbolicCheckPassed) {
                            NewItemWizard wizard = new NewItemWizard(true);
                            wizard.init(this.session);
                            IntertestWizardDialog dialog = new IntertestWizardDialog(this.shell, (IWizard)wizard);
                            dialog.create();
                            rc = dialog.open();
                            if (rc != 0) break;
                            mainProgramName = wizard.getProgramName();
                            break;
                        }
                        rc = 1;
                    }
                }
                if (mainProgramName.length() > 0) break;
                ++n;
            }
            if (rc == 1) {
                this.tryingAgain = false;
                throw new ITException(String.format(Messages.CompositeSetupPage_12, this.connection.getErrorLevel(), this.connection.getErrorMessage()));
            }
            if (rc == 0) {
                this.tryingAgain = true;
                this.setComposite(mainProgramName);
                return;
            }
        }
        Object nextcvmo = null;
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        n = debugMessageArray.length;
        int n3 = 0;
        block10: while (n3 < n) {
            DebugMessage msg = debugMessageArray[n3];
            switch (msg.getMessageID()) {
                case 41: {
                    this.csects = ((CompositeListMessage)msg).getCSects();
                    if (this.csects.size() <= 0) break block10;
                    this.setAllEdit(true);
                    this.csects.get(0).setMainProgram(true);
                    for (CSect cs : this.csects) {
                        if (cs.getMonitorName().trim().length() == 0) {
                            cs.setComment(String.format(Messages.CompositeSetupPage_17, new Object[0]));
                        } else if (cs.isMainProgram()) {
                            this.checkForSymbolics(cs);
                        }
                        if (!cs.getComment().equals("")) continue;
                        this.monCsects.add(cs);
                    }
                    this.buildTable(parent);
                    break block10;
                }
                default: {
                    ++n3;
                }
            }
        }
        if (nextcvmo != null) {
            cvmo = nextcvmo;
            debugMessageArray = cvmo.getMessages();
            n = debugMessageArray.length;
            n3 = 0;
            block12: while (n3 < n) {
                DebugMessage msg = debugMessageArray[n3];
                switch (msg.getMessageID()) {
                    case 41: {
                        this.csects = ((CompositeListMessage)msg).getCSects();
                        if (this.csects.size() <= 0) break block12;
                        if (this.synchsymbol != null) {
                            CSect csect = this.csects.get(0);
                            csect.setDDName(this.synchsymbol.getDDName());
                            csect.setDSN(this.synchsymbol.getDSN());
                            csect.setDate(this.synchsymbol.getDate());
                            csect.setTime(this.synchsymbol.getTime());
                        }
                        this.setAllEdit(true);
                        this.buildTable(parent);
                        break block12;
                    }
                    default: {
                        ++n3;
                    }
                }
            }
        }
        this.connection.terminateCICSSession();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean finish() {
        this.setMessage(Messages.CompositeSetupPage_13);
        CVMO cvmo = null;
        GetCompositeMessage composite = null;
        boolean more = true;
        while (more) {
            CVMI cvmi = new CVMI();
            try {
                block21: {
                    this.connection = (CICSConnection)this.session.getConnection();
                    this.connection.connect(false);
                    try {
                        cvmi.addMessage((DebugMessage)this.signon);
                        cvmi.addMessage((DebugMessage)this.initmessage);
                        if (this.monCsects.size() == 1 && this.monCsects.get(0).isMainProgram()) {
                            MonitorMessage monMsg = new MonitorMessage(this.file);
                            monMsg.setEnabled(true);
                            cvmi.addMessage((DebugMessage)monMsg);
                            break block21;
                        }
                        if (this.monCsects.size() > 0) {
                            composite = new GetCompositeMessage(this.file.getName());
                            this.sortCsectsByLinkOrder(this.monCsects);
                            composite.setCSects(this.monCsects);
                            composite.setSubmessageID((short)1);
                            cvmi.addMessage((DebugMessage)composite);
                        }
                    }
                    catch (ITException iTException) {
                        return false;
                    }
                }
                if (cvmi.getLastMessage().getMessageID() == 40) {
                    cvmo = this.connection.processComposite(cvmi);
                    this.connection.resetMonitorNames();
                } else {
                    cvmo = this.connection.process(cvmi);
                }
                if (cvmo.getErrorLevel() != 0) {
                    Connection.displayError(cvmo, Messages.CompositeSetupPage_14);
                    return false;
                }
                more = false;
                DebugMessage[] debugMessageArray = cvmo.getMessages();
                int n = debugMessageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugMessage message = debugMessageArray[n2];
                    if (message.getMessageID() == 42) {
                        more = true;
                        this.connection.terminateCICSSession();
                        CompositeErrorMessage msg = (CompositeErrorMessage)message;
                        String prog = msg.getCSECT();
                        CSect csect = this.getCSect(prog);
                        if (csect == null) {
                            this.getContainer().updateButtons();
                            return false;
                        }
                        switch (msg.getSubmessageID()) {
                            case 1: {
                                csect.setComment(String.format(Messages.CompositeSetupPage_15, new Object[0]));
                                this.viewer.refresh((Object)csect, true);
                                this.getContainer().updateButtons();
                                return false;
                            }
                            case 2: {
                                csect.setComment(String.format(Messages.CompositeSetupPage_16, new Object[0]));
                                this.viewer.refresh((Object)csect, true);
                                this.getContainer().updateButtons();
                                return false;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.loggit(e);
                return false;
            }
        }
        this.setMessage(Messages.CompositeSetupPage_34);
        this.setMessage(Messages.CompositeSetupPage_19);
        String prefix = this.file.getPrefix();
        ArrayList<debugFile> existing = new ArrayList<debugFile>();
        Object[] objectArray = this.session.getChildren();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object obj = objectArray[n3];
            debugFile item = (debugFile)obj;
            if (item.getName().startsWith(prefix)) {
                existing.add(item);
            }
            ++n3;
        }
        this.setMessage(Messages.CompositeSetupPage_20);
        for (CSect item : this.monCsects) {
            if (item.getMonitorName().trim().length() <= 0 || item.getMonitorName().trim().equals("+")) continue;
            this.getsynchroInfo(item);
        }
        Symbolics runit = new Symbolics(existing, this);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runit);
        for (debugFile item : existing) {
            item.setMonitor(false, false);
        }
        this.saveWidgetValues();
        return true;
    }

    private void getsynchroInfo(CSect csect) {
        if (csect.isSymbolSynched()) {
            return;
        }
        csect.setSymbolSynched(false);
        CVMO cvmo = null;
        CVMI cvmi = new CVMI();
        String loadmodule = this.file.getName();
        try {
            String progname;
            this.connection = (CICSConnection)this.session.getConnection();
            this.connection.connect(false);
            try {
                cvmi.addMessage((DebugMessage)this.signon);
                SynchSymbolicMessage sychrequest = new SynchSymbolicMessage();
                if (this.isSymbolicCheck) {
                    sychrequest.setSubmessageID((short)4);
                } else {
                    sychrequest.setSubmessageID((short)5);
                }
                progname = csect.getMonitorName().trim();
                if (progname == null || progname.equals("")) {
                    this.symbolicCheckPassed = false;
                    return;
                }
                if (!progname.equalsIgnoreCase(loadmodule)) {
                    progname = String.valueOf(loadmodule) + "_" + progname;
                }
                sychrequest.setProgram(progname);
                cvmi.addMessage((DebugMessage)sychrequest);
            }
            catch (ITException iTException) {
                return;
            }
            cvmo = this.connection.process(cvmi);
            if (cvmo.getErrorLevel() != 0) {
                if (this.isSymbolicCheck) {
                    this.tryingAgain = true;
                    this.symbolicCheckPassed = false;
                    return;
                }
                Connection.displayError(cvmo, Messages.CompositeSetupPage_35);
                return;
            }
            DebugMessage[] debugMessageArray = cvmo.getMessages();
            int n = debugMessageArray.length;
            int n2 = 0;
            while (n2 < n) {
                DebugMessage message = debugMessageArray[n2];
                if (message.getMessageID() == 45) {
                    SynchronizeMessage.SynchProtsym prot;
                    SynchronizeMessage synchmsg = (SynchronizeMessage)message;
                    Logger.loggit(0, String.format(Messages.CompositeSetupPage_37, synchmsg.getProgram(), this.session.getName()));
                    if (this.isSymbolicCheck) {
                        if (synchmsg.getProtsyms().size() == 0) {
                            this.symbolicCheckPassed = false;
                        } else {
                            for (SynchronizeMessage.SynchProtsym prot2 : synchmsg.getProtsyms()) {
                                if (prot2.getDSN().equals(Messages.CompositeSetupPage_18)) {
                                    this.symbolicCheckPassed = false;
                                    return;
                                }
                                if (prot2.getDSN().trim().length() <= 0) continue;
                                this.symbolicCheckPassed = true;
                                return;
                            }
                            this.symbolicCheckPassed = false;
                        }
                        return;
                    }
                    if (synchmsg.getProtsyms().size() == 1 && (prot = (SynchronizeMessage.SynchProtsym)synchmsg.getProtsyms().get(0)).isExact()) {
                        this.session.refreshFile(progname, prot.getDSN(), true, false, false, prot.getDate(), prot.getTime(), "CompositeSetupPage");
                        csect.setDSN(prot.getDSN());
                        csect.setDate(synchmsg.getDate());
                        csect.setTime(synchmsg.getTime());
                    }
                    csect.setSymbolSynched(true);
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            return;
        }
    }

    public debugFile getFile() {
        return this.file;
    }

    public boolean isPageComplete() {
        if (this.tryingAgain) {
            return false;
        }
        if (this.csects == null || this.csects.size() < 2) {
            this.type = CompositeType.STANDARD;
            this.setMessage(Messages.CompositeSetupPage_22, 2);
            return false;
        }
        if (this.isFilterProblem) {
            return false;
        }
        this.isComplete = true;
        this.isMultiCsectSupportProblem = false;
        this.topIndex = -1;
        int i = 0;
        while (i < this.csects.size()) {
            CSect element = this.csects.get(i);
            if (this.resetComments && (element.getComment().equals(Messages.CompositeSetupPage_25) || element.getComment().equals(Messages.CompositeSetupPage_26))) {
                element.setComment("");
            }
            if (this.monCsects.contains(element)) {
                if (!element.getComment().equals("")) {
                    this.isComplete = false;
                } else if (element.getMonitorName().trim().length() > 0) {
                    if (element.getMonitorName().trim().equals("+")) {
                        if (!this.isMultiCsectAsmProgram(i)) {
                            element.setComment(String.format(Messages.CompositeSetupPage_25, new Object[0]));
                        }
                        if (this.isMultiCsectSupportProblem) {
                            this.isComplete = false;
                        }
                    } else if (element.getLanguage() == '?') {
                        element.setComment(String.format(Messages.CompositeSetupPage_38, new Object[0]));
                    }
                } else {
                    element.setComment(String.format(Messages.CompositeSetupPage_39, new Object[0]));
                }
                if (element.getComment().length() > 0) {
                    this.type = CompositeType.STANDARD;
                    this.setMessage(String.format(Messages.CompositeSetupPage_23, new Object[0]), 3);
                    this.viewer.refresh(true);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
                    this.isComplete = false;
                    if (this.topIndex == -1) {
                        this.topIndex = this.filteredCsects.contains(element) ? this.filteredCsects.indexOf(element) : i;
                    }
                }
            }
            ++i;
        }
        this.viewer.refresh(true);
        this.resetComments = true;
        if (!this.isComplete) {
            if (this.isMultiCsectSupportProblem) {
                this.doClickResetButton();
            }
            if (this.topIndex >= 0) {
                this.viewer.getTable().setTopIndex(this.topIndex);
                this.viewer.refresh();
            }
            return false;
        }
        this.setMessage(Messages.CompositeSetupPage_24, 0);
        return super.isPageComplete();
    }

    public void setFile(debugFile file) {
        this.file = file;
        this.session = file.getSession();
    }

    private void buildTable(Composite parent) {
        int charwidth;
        int wHint;
        if (this.settings == null) {
            this.restoreWidgetValues();
        }
        this.searchText = this.settings.get("composite");
        if (this.searchText == null) {
            this.searchText = "";
        }
        this.searchGroup = new Group(parent, 16);
        this.searchGroup.setText("Search");
        this.searchGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1, 2, false, false, 1, 1);
        this.searchGroup.setLayoutData((Object)gridData);
        this.searchList = new MRUCombo((Composite)this.searchGroup, 2052, "COMPOSITE");
        Combo searchCombo = this.searchList.getCombo();
        gridData = (GridData)searchCombo.getLayoutData();
        int searchWidth = Math.max(searchCombo.getText().length(), 20);
        String[] stringArray = searchCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            searchWidth = Math.max(searchWidth, item.length());
            ++n2;
        }
        gridData.widthHint = wHint = this.convertWidthInCharsToPixels(searchWidth);
        gridData.minimumWidth = wHint;
        searchCombo.setSize(searchCombo.computeSize(searchWidth, -1));
        searchCombo.setTextLimit(20);
        searchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        searchCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    CompositeSetupPage.this.doClickSearchButton();
                    CompositeSetupPage.this.searchButton.setFocus();
                }
            }
        });
        this.searchButton = new Button((Composite)this.searchGroup, 8);
        this.searchButton.setText("Search");
        gridData = new GridData(1);
        this.searchButton.setLayoutData((Object)gridData);
        this.searchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CompositeSetupPage.this.doClickSearchButton();
                CompositeSetupPage.this.searchButton.setFocus();
            }
        });
        this.createSpacer(parent);
        this.filterGroup = new Group(parent, 0);
        this.filterGroup.setText("Filter");
        this.filterGroup.setLayout((Layout)new GridLayout(6, false));
        gridData = new GridData(4, 2, false, false, 1, 1);
        this.filterGroup.setLayoutData((Object)gridData);
        int i = 0;
        while (i < labels.length) {
            Label filterLabel = new Label((Composite)this.filterGroup, 0x1000000);
            filterLabel.setText(labels[i]);
            ++i;
        }
        GC gc = new GC((Drawable)parent);
        try {
            charwidth = gc.getCharWidth('W');
        }
        finally {
            gc.dispose();
        }
        this.filters = new Text[labels.length];
        int i2 = 0;
        while (i2 < labels.length) {
            Text filterTextbox = new Text((Composite)this.filterGroup, 0);
            gridData = new GridData(1);
            gridData.widthHint = charwidth * COLUMN_WIDTHS[i2];
            filterTextbox.setLayoutData((Object)gridData);
            if (i2 == 2 || i2 == 3) {
                filterTextbox.setTextLimit(COLUMN_WIDTHS[i2] + 2);
            } else if (i2 == 5) {
                filterTextbox.setTextLimit(Text.LIMIT);
            } else {
                filterTextbox.setTextLimit(COLUMN_WIDTHS[i2]);
            }
            filterTextbox.setText("*");
            filterTextbox.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        e.doit = false;
                        CompositeSetupPage.this.doClickFilterButton();
                    }
                }
            });
            this.filters[i2] = filterTextbox;
            ++i2;
        }
        this.filterButtonGroup = new Composite((Composite)this.filterGroup, 0);
        this.filterButtonGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(4, 2, false, false, 1, 1);
        this.filterButtonGroup.setLayoutData((Object)gridData);
        this.filterButton = new Button(this.filterButtonGroup, 8);
        this.filterButton.setText("Filter");
        gridData = new GridData(1);
        this.filterButton.setLayoutData((Object)gridData);
        this.filterButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CompositeSetupPage.this.doClickFilterButton();
            }
        });
        this.resetButton = new Button(this.filterButtonGroup, 8);
        this.resetButton.setText("Reset");
        gridData = new GridData(16384);
        this.resetButton.setLayoutData((Object)gridData);
        this.resetButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CompositeSetupPage.this.doClickResetButton();
                CompositeSetupPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Table table = new Table(parent, 68386);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CompositeSetupPage.this.resetComments = true;
                if (event.getChecked()) {
                    if (!CompositeSetupPage.this.monCsects.contains(event.getElement())) {
                        CompositeSetupPage.this.monCsects.add((CSect)event.getElement());
                    }
                    CompositeSetupPage.this.addMonitorName(((CSect)event.getElement()).getMonitorName().trim());
                } else if (!event.getChecked()) {
                    if (CompositeSetupPage.this.monCsects.contains(event.getElement())) {
                        CompositeSetupPage.this.monCsects.remove(event.getElement());
                    }
                    CompositeSetupPage.this.subtractMonitorName(((CSect)event.getElement()).getMonitorName().trim());
                    if (!((CSect)event.getElement()).getComment().equals(Messages.CompositeSetupPage_17)) {
                        ((CSect)event.getElement()).setComment("");
                    }
                }
                CompositeSetupPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompositeSetupPage.this.selectionIndex = 0;
                CompositeSetupPage.this.columnIndex = -1;
                ISelection selection = event.getSelection();
                if (!selection.isEmpty()) {
                    int i = 0;
                    while (i < CompositeSetupPage.this.filteredCsects.size()) {
                        String selectionString = selection.toString();
                        selectionString = selectionString.substring(1, selectionString.length() - 1);
                        if (((CSect)CompositeSetupPage.this.filteredCsects.get(i)).toString().equals(selectionString)) {
                            CompositeSetupPage.this.selectionIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        Composite buttongroup = new Composite(parent, 0);
        GridLayout buttonlayout = new GridLayout(3, false);
        buttongroup.setLayout((Layout)buttonlayout);
        this.selectAllButton = new Button(buttongroup, 8);
        this.selectAllButton.setText(Messages.ImportListingPage_30);
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < CompositeSetupPage.this.filteredCsects.size()) {
                    CompositeSetupPage.this.viewer.setChecked(CompositeSetupPage.this.filteredCsects.get(i), true);
                    if (!CompositeSetupPage.this.monCsects.contains(CompositeSetupPage.this.filteredCsects.get(i))) {
                        CompositeSetupPage.this.monCsects.add((CSect)CompositeSetupPage.this.filteredCsects.get(i));
                    }
                    CompositeSetupPage.this.addMonitorName(((CSect)CompositeSetupPage.this.filteredCsects.get(i)).getMonitorName());
                    ++i;
                }
                CompositeSetupPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.deselectAllButton = new Button(buttongroup, 8);
        this.deselectAllButton.setText(Messages.ImportListingPage_31);
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < CompositeSetupPage.this.filteredCsects.size()) {
                    CompositeSetupPage.this.viewer.setChecked(CompositeSetupPage.this.filteredCsects.get(i), false);
                    if (CompositeSetupPage.this.monCsects.contains(CompositeSetupPage.this.filteredCsects.get(i))) {
                        CompositeSetupPage.this.monCsects.remove(CompositeSetupPage.this.filteredCsects.get(i));
                    }
                    CompositeSetupPage.this.subtractMonitorName(((CSect)CompositeSetupPage.this.filteredCsects.get(i)).getMonitorName());
                    ((CSect)CompositeSetupPage.this.filteredCsects.get(i)).setComment("");
                    ++i;
                }
                CompositeSetupPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Composite rowInfoGroup = new Composite(parent, 0);
        rowInfoGroup.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(131072, 2, false, false, 1, 1);
        this.numRowsLabel = new Label(rowInfoGroup, 131072);
        this.numRowsLabel.setText("Number of rows: " + this.csects.size());
        this.rowData = new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((ArrayList)inputElement).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.rowData);
        this.viewer.setColumnProperties(labels);
        TableViewerFocusCellManager mgr = new TableViewerFocusCellManager((TableViewer)this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && (event.keyCode == 13 || event.character == ' ') || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)mgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.tableViewerColumns = new TableViewerColumn[labels.length];
        int[] widthOffsets = new int[]{18, 13, 13, 13, 13, 13};
        int i3 = 0;
        while (i3 < labels.length) {
            TableViewerColumn column = new TableViewerColumn((TableViewer)this.viewer, styles[i3]);
            column.setEditingSupport((EditingSupport)new EditColumn((ColumnViewer)this.viewer, this.session, this.file, i3));
            column.setLabelProvider((CellLabelProvider)new CompositeColumnLabelPRovider(i3));
            TableColumn col = column.getColumn();
            col.setText(labels[i3]);
            if (i3 == 5) {
                col.setResizable(true);
            } else {
                col.setResizable(false);
            }
            col.setWidth(charwidth * COLUMN_WIDTHS[i3] + widthOffsets[i3]);
            col.setMoveable(false);
            this.tableViewerColumns[i3] = column;
            ++i3;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.performCsectFilter();
        this.createColumnSorter();
    }

    private void createColumnSorter() {
        if (this.viewer != null) {
            this.table = this.viewer.getTable();
            if (this.table != null && !this.table.isDisposed()) {
                TableColumn[] tableColumnArray = this.table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TableColumn col = (TableColumn)e.widget;
                            Table t = col.getParent();
                            if (col.equals(t.getSortColumn())) {
                                t.setSortDirection(t.getSortDirection() == 128 ? 1024 : 128);
                            } else {
                                t.setSortColumn(col);
                                t.setSortDirection(128);
                            }
                            CompositeSetupPage.this.sortOnColumn(col);
                        }
                    });
                    ++n2;
                }
            }
        }
    }

    private void sortOnColumn(TableColumn column) {
        if (column != null) {
            String columnName = column.getText();
            if (columnName.equalsIgnoreCase("Link Name")) {
                Collections.sort(this.filteredCsects, new Comparator<CSect>(){

                    @Override
                    public int compare(CSect r1, CSect r2) {
                        int result = r1.getCSECTName().compareToIgnoreCase(r2.getCSECTName());
                        if (result == 0 && (result = r1.getMonitorName().compareToIgnoreCase(r2.getMonitorName())) == 0 && (result = r1.getLanguageText().compareToIgnoreCase(r2.getLanguageText())) == 0 && (result = r1.getOffset().compareToIgnoreCase(r2.getOffset())) == 0 && (result = r1.getLength().compareToIgnoreCase(r2.getLength())) == 0) {
                            result = r1.getComment().compareToIgnoreCase(r2.getComment());
                        }
                        return result;
                    }
                });
            } else if (columnName.equalsIgnoreCase("Monitor Name")) {
                Collections.sort(this.filteredCsects, new Comparator<CSect>(){

                    @Override
                    public int compare(CSect r1, CSect r2) {
                        int result = r1.getMonitorName().compareToIgnoreCase(r2.getMonitorName());
                        if (result == 0 && (result = r1.getCSECTName().compareToIgnoreCase(r2.getCSECTName())) == 0 && (result = r1.getLanguageText().compareToIgnoreCase(r2.getLanguageText())) == 0 && (result = r1.getOffset().compareToIgnoreCase(r2.getOffset())) == 0 && (result = r1.getLength().compareToIgnoreCase(r2.getLength())) == 0) {
                            result = r1.getComment().compareToIgnoreCase(r2.getComment());
                        }
                        return result;
                    }
                });
            } else if (columnName.equalsIgnoreCase("Offset")) {
                Collections.sort(this.filteredCsects, new Comparator<CSect>(){

                    @Override
                    public int compare(CSect r1, CSect r2) {
                        int result = r1.getOffset().compareToIgnoreCase(r2.getOffset());
                        if (result == 0 && (result = r1.getCSECTName().compareToIgnoreCase(r2.getCSECTName())) == 0 && (result = r1.getMonitorName().compareToIgnoreCase(r2.getMonitorName())) == 0 && (result = r1.getLanguageText().compareToIgnoreCase(r2.getLanguageText())) == 0 && (result = r1.getLength().compareToIgnoreCase(r2.getLength())) == 0) {
                            result = r1.getComment().compareToIgnoreCase(r2.getComment());
                        }
                        return result;
                    }
                });
            } else if (columnName.equalsIgnoreCase("Length")) {
                Collections.sort(this.filteredCsects, new Comparator<CSect>(){

                    @Override
                    public int compare(CSect r1, CSect r2) {
                        int result = r1.getLength().compareToIgnoreCase(r2.getLength());
                        if (result == 0 && (result = r1.getCSECTName().compareToIgnoreCase(r2.getCSECTName())) == 0 && (result = r1.getMonitorName().compareToIgnoreCase(r2.getMonitorName())) == 0 && (result = r1.getLanguageText().compareToIgnoreCase(r2.getLanguageText())) == 0 && (result = r1.getOffset().compareToIgnoreCase(r2.getOffset())) == 0) {
                            result = r1.getComment().compareToIgnoreCase(r2.getComment());
                        }
                        return result;
                    }
                });
            } else if (columnName.equalsIgnoreCase("Language")) {
                Collections.sort(this.filteredCsects, new Comparator<CSect>(){

                    @Override
                    public int compare(CSect r1, CSect r2) {
                        int result = r1.getLanguageText().compareToIgnoreCase(r2.getLanguageText());
                        if (result == 0 && (result = r1.getCSECTName().compareToIgnoreCase(r2.getCSECTName())) == 0 && (result = r1.getMonitorName().compareToIgnoreCase(r2.getMonitorName())) == 0 && (result = r1.getOffset().compareToIgnoreCase(r2.getOffset())) == 0 && (result = r1.getLength().compareToIgnoreCase(r2.getLength())) == 0) {
                            result = r1.getComment().compareToIgnoreCase(r2.getComment());
                        }
                        return result;
                    }
                });
            } else if (columnName.equalsIgnoreCase("Comment")) {
                Collections.sort(this.filteredCsects, new Comparator<CSect>(){

                    @Override
                    public int compare(CSect r1, CSect r2) {
                        int result = r1.getComment().compareToIgnoreCase(r2.getComment());
                        if (result == 0 && (result = r1.getCSECTName().compareToIgnoreCase(r2.getCSECTName())) == 0 && (result = r1.getMonitorName().compareToIgnoreCase(r2.getMonitorName())) == 0 && (result = r1.getLanguageText().compareToIgnoreCase(r2.getLanguageText())) == 0 && (result = r1.getOffset().compareToIgnoreCase(r2.getOffset())) == 0) {
                            result = r1.getLength().compareToIgnoreCase(r2.getLength());
                        }
                        return result;
                    }
                });
            }
            if (this.table != null && !this.table.isDisposed() && this.table.getSortDirection() == 1024) {
                Collections.reverse(this.filteredCsects);
            }
            if (this.viewer != null) {
                this.viewer.refresh();
            }
        }
    }

    private CSect getCSect(String prog) {
        for (CSect csect : this.csects) {
            if (!csect.getCSECTName().equals(prog)) continue;
            return csect;
        }
        return null;
    }

    private void restoreWidgetValues() {
        if (this.settings == null) {
            this.settings = this.getDialogSettings();
        }
        if (this.settings != null) {
            String result;
            String name = ((Object)((Object)this)).getClass().getSimpleName();
            this.settings = this.settings.getSection(name);
            if (this.settings == null) {
                this.settings = this.getDialogSettings().addNewSection(name);
            }
            if ((result = this.settings.get(COL_COUNT)) == null) {
                return;
            }
            Integer count = Integer.valueOf(result);
            if (count == null) {
                count = this.order.length;
            }
            if (count == this.order.length) {
                int i;
                String[] strings = this.settings.getArray(COL_ORDER);
                if (strings != null) {
                    this.order = new int[strings.length];
                    i = 0;
                    while (i < strings.length) {
                        this.order[i] = Integer.parseInt(strings[i]);
                        ++i;
                    }
                }
                if ((strings = this.settings.getArray(COL_WIDTH)) != null) {
                    this.width = new int[strings.length];
                    i = 0;
                    while (i < strings.length) {
                        this.width[i] = Integer.parseInt(strings[i]);
                        ++i;
                    }
                }
            }
            if (this.settings.get("composite") == null) {
                this.settings.put("composite", "");
            }
        }
    }

    private void saveWidgetValues() {
        if (this.settings == null) {
            this.restoreWidgetValues();
        }
        if (this.settings != null && this.table != null) {
            this.order = this.table.getColumnOrder();
            this.settings.put(COL_COUNT, this.order.length);
            String[] strings = new String[this.order.length];
            int i = 0;
            while (i < this.order.length) {
                strings[i] = Integer.toString(this.order[i]);
                ++i;
            }
            this.settings.put(COL_ORDER, strings);
            strings = new String[this.order.length];
            i = 0;
            while (i < this.width.length) {
                strings[i] = Integer.toString(this.table.getColumn(i).getWidth());
                ++i;
            }
            this.settings.put(COL_WIDTH, strings);
            this.searchList.save();
            this.settings.put("composite", this.searchList.getSelected());
            return;
        }
    }

    private void saveSearchValue() {
        if (this.settings == null) {
            this.restoreWidgetValues();
        }
        if (this.settings != null && this.searchList != null) {
            this.searchList.save();
            this.settings.put("composite", this.searchList.getSelected());
            this.searchList.getCombo().add(this.searchList.getCombo().getText().trim(), 0);
            return;
        }
    }

    private void setAllEdit(boolean edit) {
        for (CSect item : this.csects) {
            item.setEdit(edit);
        }
    }

    public CompositeType getType() {
        return this.type;
    }

    public void setType(CompositeType type) {
        this.type = type;
    }

    public void setCsects(ArrayList<CSect> csects) {
        if (csects != null) {
            this.csects = csects;
            this.type = CompositeType.PRELOADED;
        }
    }

    public boolean isPost() {
        return this.post;
    }

    public void setPost(boolean post) {
        this.post = post;
    }

    private void checkWidth(Composite parent) {
        if (this.width == null && parent != null) {
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[COLUMN_WIDTHS.length];
            int j = 0;
            while (j < COLUMN_WIDTHS.length) {
                this.width[j] = COLUMN_WIDTHS[j] * CHAR_WIDTH;
                ++j;
            }
        }
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    private void performCsectFilter() {
        if (this.filteredCsects == null) {
            this.filteredCsects = new ArrayList(this.csects.size());
        } else {
            this.filteredCsects.clear();
        }
        for (CSect cs : this.csects) {
            this.filteredCsects.add(cs);
        }
        this.isFilterProblem = false;
        int filterIndex = 0;
        while (filterIndex < this.filters.length) {
            String columnFilter = this.filters[filterIndex].getText().toUpperCase().trim();
            if (columnFilter.equals(" ") || columnFilter.equals("")) {
                columnFilter = "*";
                this.filters[filterIndex].setText(columnFilter);
            }
            if (!columnFilter.equals("*")) {
                boolean isNumericFilter = false;
                char numericFilter = columnFilter.charAt(0);
                Pattern pattern = null;
                if (!(filterIndex != 2 && filterIndex != 3 || numericFilter != '<' && numericFilter != '>' && numericFilter != '=')) {
                    isNumericFilter = true;
                    columnFilter = columnFilter.substring(1).trim();
                } else {
                    int i = 0;
                    while (i < columnFilter.length()) {
                        String token = "";
                        if (columnFilter.charAt(i) == '*') {
                            token = ".*";
                        } else if (columnFilter.charAt(i) == '%') {
                            token = ".";
                        } else if (columnFilter.charAt(i) == '+') {
                            token = "[^\\s]";
                        }
                        if (!token.isEmpty()) {
                            String temp = columnFilter.substring(0, i);
                            temp = temp.concat(token);
                            columnFilter = temp = temp.concat(columnFilter.substring(i + 1));
                            i = i + token.length() - 1;
                        }
                        ++i;
                    }
                    try {
                        pattern = Pattern.compile(columnFilter);
                    }
                    catch (Exception exception) {
                        this.setMessage(String.format(Messages.CompositeSetupPage_21, new Object[0]), 3);
                        this.isFilterProblem = true;
                    }
                }
                int csectIndex = this.filteredCsects.size() - 1;
                while (csectIndex >= 0) {
                    String columnString = "";
                    switch (filterIndex) {
                        case 0: {
                            columnString = this.filteredCsects.get(csectIndex).getCSECTName();
                            break;
                        }
                        case 1: {
                            columnString = this.filteredCsects.get(csectIndex).getMonitorName();
                            break;
                        }
                        case 2: {
                            columnString = this.filteredCsects.get(csectIndex).getOffset();
                            break;
                        }
                        case 3: {
                            columnString = this.filteredCsects.get(csectIndex).getLength();
                            break;
                        }
                        case 4: {
                            columnString = this.filteredCsects.get(csectIndex).getLanguageText();
                            break;
                        }
                        case 5: {
                            columnString = this.filteredCsects.get(csectIndex).getComment();
                            break;
                        }
                    }
                    columnString = columnString.toUpperCase().trim();
                    if (isNumericFilter) {
                        try {
                            int intFilter = Integer.valueOf(columnFilter, 16);
                            int intString = Integer.valueOf(columnString, 16);
                            if (numericFilter == '<' && intFilter <= intString) {
                                this.filteredCsects.remove(csectIndex);
                            } else if (numericFilter == '>' && intFilter >= intString) {
                                this.filteredCsects.remove(csectIndex);
                            } else if (numericFilter == '=' && intFilter != intString) {
                                this.filteredCsects.remove(csectIndex);
                            }
                        }
                        catch (Exception exception) {
                            this.setMessage(String.format(Messages.CompositeSetupPage_21, new Object[0]), 3);
                            this.isFilterProblem = true;
                        }
                    } else {
                        Matcher matcher = pattern.matcher(columnString);
                        boolean isMatch = matcher.matches();
                        if (!isMatch) {
                            this.filteredCsects.remove(csectIndex);
                        }
                    }
                    --csectIndex;
                }
            }
            ++filterIndex;
        }
        this.viewer.setInput(this.filteredCsects);
        for (CSect cs : this.filteredCsects) {
            if (!this.monCsects.contains(cs)) continue;
            this.viewer.setChecked((Object)cs, true);
        }
        this.viewer.refresh();
    }

    private void sortCsectsByLinkOrder(ArrayList<CSect> unsortedCsects) {
        Collections.sort(unsortedCsects, new Comparator<CSect>(){

            @Override
            public int compare(CSect c1, CSect c2) {
                int ix1 = CompositeSetupPage.this.csects.indexOf(c1);
                int ix2 = CompositeSetupPage.this.csects.indexOf(c2);
                return ix1 - ix2;
            }
        });
    }

    private boolean isMultiCsectAsmProgram(int ix) {
        this.resetComments = true;
        boolean result = true;
        CSect element = this.csects.get(ix - 1);
        if (!this.viewer.getChecked((Object)element)) {
            element.setComment(String.format(Messages.CompositeSetupPage_26, new Object[0]));
            this.isMultiCsectSupportProblem = true;
            this.topIndex = ix - 1;
        } else if (element.getMonitorName().equals("")) {
            element.setComment(String.format(Messages.CompositeSetupPage_39, new Object[0]));
            this.isMultiCsectSupportProblem = true;
            this.topIndex = ix - 1;
        } else if (element.getMonitorName().equals("+")) {
            result = this.isMultiCsectAsmProgram(ix - 1);
        } else if (element.getLanguage() != 'A') {
            result = false;
        }
        return result;
    }

    private void doClickResetButton() {
        this.searchList.getCombo().setText("");
        int i = 0;
        while (i < this.filters.length) {
            this.filters[i].setText("*");
            ++i;
        }
        this.performCsectFilter();
        this.sortCsectsByLinkOrder(this.filteredCsects);
        this.table.setSortColumn(null);
        this.viewer.getTable().setTopIndex(0);
        this.viewer.refresh();
        this.resetComments = false;
        this.numRowsLabel.setText("Number of rows: " + this.filteredCsects.size());
        this.selectionIndex = 0;
        this.columnIndex = -1;
        this.isFilterProblem = false;
    }

    private void doClickFilterButton() {
        this.performCsectFilter();
        if (this.table != null && this.table.getSortColumn() != null) {
            this.sortOnColumn(this.table.getSortColumn());
        }
        this.viewer.refresh();
        this.resetComments = false;
        this.numRowsLabel.setText("Number of rows: " + this.filteredCsects.size());
        this.getWizard().getContainer().updateButtons();
    }

    private void doClickSearchButton() {
        String searchString = this.searchList.getCombo().getText().toUpperCase().trim();
        if (searchString != null && !searchString.equals("")) {
            this.saveSearchValue();
            this.getWizard().getContainer().updateButtons();
            boolean searchFound = false;
            boolean stopSearching = false;
            int i = this.selectionIndex;
            int j = this.columnIndex + 1;
            if (j >= labels.length) {
                j = 0;
            }
            while (true) {
                if (j < labels.length) {
                    String columnString = "";
                    switch (j) {
                        case 0: {
                            columnString = this.filteredCsects.get(i).getCSECTName();
                            break;
                        }
                        case 1: {
                            columnString = this.filteredCsects.get(i).getMonitorName();
                            break;
                        }
                        case 2: {
                            columnString = this.filteredCsects.get(i).getOffset();
                            break;
                        }
                        case 3: {
                            columnString = this.filteredCsects.get(i).getLength();
                            break;
                        }
                        case 4: {
                            columnString = this.filteredCsects.get(i).getLanguageText();
                            break;
                        }
                        case 5: {
                            columnString = this.filteredCsects.get(i).getComment();
                            break;
                        }
                    }
                    if (columnString.length() >= searchString.length() && columnString.contains(searchString)) {
                        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.filteredCsects.get(i)), true);
                        this.viewer.getTable().setTopIndex(i);
                        TableViewerColumn column = this.tableViewerColumns[j];
                        switch (j) {
                            case 0: 
                            case 2: 
                            case 3: 
                            case 5: {
                                column.setEditingSupport((EditingSupport)new EditColumn((ColumnViewer)this.viewer, this.session, this.file, j, true));
                                this.viewer.editElement((Object)this.filteredCsects.get(i), j);
                                column.setEditingSupport((EditingSupport)new EditColumn((ColumnViewer)this.viewer, this.session, this.file, j, false));
                                break;
                            }
                            case 1: 
                            case 4: {
                                this.viewer.editElement((Object)this.filteredCsects.get(i), j);
                            }
                        }
                        this.viewer.refresh();
                        this.selectionIndex = i;
                        this.columnIndex = j;
                        searchFound = true;
                    } else if (i == this.selectionIndex && j == this.columnIndex) {
                        stopSearching = true;
                    } else {
                        ++j;
                        continue;
                    }
                }
                if (searchFound) break;
                if (i + 1 == this.filteredCsects.size()) {
                    i = -1;
                }
                ++i;
                j = 0;
                if (stopSearching) break;
            }
            if (!searchFound) {
                this.setMessage(String.format(Messages.CompositeSetupPage_27, new Object[0]), 1);
            }
        }
    }

    private int setComposite(String programName) {
        debugFile file = this.session.getFile(programName);
        CompositeSetupWizard wizard = new CompositeSetupWizard(file, CompositeType.STANDARD, null, true);
        IntertestWizardDialog dialog = new IntertestWizardDialog(null, (IWizard)wizard);
        dialog.create();
        return dialog.open();
    }

    private void subtractMonitorName(String monitorName) {
        if (this.countNames(monitorName) == 1 && !monitorName.equals("+")) {
            for (CSect cs : this.csects) {
                if (!cs.getMonitorName().equals(monitorName) || cs.getComment().equals(Messages.CompositeSetupPage_17)) continue;
                cs.setComment("");
            }
        }
    }

    private void addMonitorName(String monitorName) {
        if (!monitorName.equals("+") && this.countNames(monitorName) > 1) {
            for (CSect cs : this.csects) {
                if (!this.monCsects.contains(cs) || !cs.getMonitorName().equals(monitorName) || cs.getComment().equals(Messages.CompositeSetupPage_17)) continue;
                cs.setComment(String.format(Messages.CompositeSetupPage_28, new Object[0]));
            }
        }
    }

    private void checkForSymbolics(CSect cs) {
        this.isSymbolicCheck = true;
        this.symbolicCheckPassed = false;
        this.getsynchroInfo(cs);
        if (this.tryingAgain) {
            this.getsynchroInfo(cs);
            this.tryingAgain = false;
        }
        this.isSymbolicCheck = false;
        if (!this.symbolicCheckPassed) {
            cs.setComment(String.format(Messages.CompositeSetupPage_17, new Object[0]));
        }
    }

    public class CompositeColumnLabelPRovider
    extends ColumnLabelProvider {
        int columnIndex;

        public CompositeColumnLabelPRovider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            CSect csect = (CSect)element;
            switch (this.columnIndex) {
                case 0: {
                    return csect.getCSECTName();
                }
                case 4: {
                    return csect.getLanguageText();
                }
                case 3: {
                    return csect.getLength();
                }
                case 1: {
                    return csect.getMonitorName();
                }
                case 2: {
                    return csect.getOffset();
                }
                case 5: {
                    return csect.getComment();
                }
            }
            return super.getText(element);
        }
    }

    public static enum CompositeType {
        STANDARD,
        PRELOADED;

    }

    public class EditColumn
    extends BasicEditingSupport {
        protected int columnIndex;
        protected boolean makeEditable;

        public EditColumn(ColumnViewer viewer, debugSession session, debugFile debugfile, int columnIndex) {
            super(viewer, session, debugfile, columnIndex);
            this.makeEditable = false;
            this.columnIndex = columnIndex;
        }

        public EditColumn(ColumnViewer viewer, debugSession session, debugFile debugfile, int columnIndex, boolean makeEditable) {
            super(viewer, session, debugfile, columnIndex);
            this.makeEditable = false;
            this.columnIndex = columnIndex;
            this.makeEditable = makeEditable;
        }

        @Override
        protected boolean canEdit(Object element) {
            switch (this.columnIndex) {
                case 1: 
                case 4: {
                    return true;
                }
                case 0: 
                case 2: 
                case 3: 
                case 5: {
                    if (!this.makeEditable) break;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected CellEditor getCellEditor(Object element) {
            TextCellEditor celleditor = null;
            Text text = null;
            switch (this.columnIndex) {
                case 1: {
                    celleditor = new TextCellEditor((Composite)CompositeSetupPage.this.viewer.getTable());
                    text = (Text)celleditor.getControl();
                    text.addVerifyListener((VerifyListener)new verifytoUpperCase());
                    text.setTextLimit(8);
                    text.setToolTipText(Messages.CompositeSetupPage_41);
                    break;
                }
                case 4: {
                    celleditor = new TextCellEditor((Composite)CompositeSetupPage.this.viewer.getTable());
                    text = (Text)celleditor.getControl();
                    text.addVerifyListener((VerifyListener)new verifytoUpperCase());
                    text.setTextLimit(5);
                    text.setToolTipText(Messages.CompositeSetupPage_42);
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 5: {
                    if (!this.makeEditable) break;
                    celleditor = new TextCellEditor((Composite)CompositeSetupPage.this.viewer.getTable());
                    text = (Text)celleditor.getControl();
                }
            }
            if (text != null) {
                text.setMenu(this.getViewer().getControl().getMenu());
            }
            if (celleditor != null) {
                this.setEditorFont((CellEditor)celleditor);
            }
            return celleditor;
        }

        @Override
        protected Object getValue(Object element) {
            switch (this.columnIndex) {
                case 1: {
                    return ((CSect)element).getMonitorName();
                }
                case 4: {
                    return ((CSect)element).getLanguageText();
                }
                case 0: {
                    return ((CSect)element).getCSECTName();
                }
                case 2: {
                    return ((CSect)element).getOffset();
                }
                case 3: {
                    return ((CSect)element).getLength();
                }
                case 5: {
                    return ((CSect)element).getComment();
                }
            }
            return null;
        }

        @Override
        protected void setValue(Object element, Object value) {
            String data = value.toString().trim();
            switch (this.columnIndex) {
                case 1: {
                    String oldMonitorName = ((CSect)element).getMonitorName();
                    CompositeSetupPage.this.resetComments = false;
                    ((CSect)element).setMonitorName(data);
                    ((CSect)element).setComment("");
                    CompositeSetupPage.this.subtractMonitorName(oldMonitorName);
                    CompositeSetupPage.this.addMonitorName(data);
                    if (data.equals("+")) break;
                    CompositeSetupPage.this.checkForSymbolics((CSect)element);
                    break;
                }
                case 4: {
                    if (((CSect)element).getComment().equals(Messages.CompositeSetupPage_38)) {
                        ((CSect)element).setComment("");
                    }
                    ((CSect)element).setLanguage(value.toString());
                    break;
                }
                default: {
                    return;
                }
            }
            CompositeSetupPage.this.viewer.refresh(element, true);
            CompositeSetupPage.this.getContainer().updateButtons();
        }
    }

    private final class Symbolics
    implements Runnable {
        private final ArrayList<debugFile> existing;
        private CompositeSetupPage page;

        private Symbolics(ArrayList<debugFile> existing, CompositeSetupPage page) {
            this.existing = existing;
            this.page = page;
        }

        @Override
        public void run() {
            if (CompositeSetupPage.this.csects.size() > 0) {
                boolean first = true;
                String module = CompositeSetupPage.this.file.getName();
                this.page.setMessage(Messages.CompositeSetupPage_0);
                for (CSect csect : CompositeSetupPage.this.csects) {
                    String monitored = csect.getMonitorName().trim();
                    if (monitored.length() == 0) {
                        if (!first) continue;
                        first = false;
                        continue;
                    }
                    debugFile csectfile = null;
                    String progid = first && module.equals(csect.getMonitorName()) ? monitored : String.valueOf(module) + "_" + monitored;
                    csectfile = CompositeSetupPage.this.oldsymsynch ? CompositeSetupPage.this.session.refreshFile(progid, csect.getDSN(), true, false, true, csect.getDate(), csect.getTime()) : CompositeSetupPage.this.session.getFile(progid);
                    if (csectfile != null) {
                        csectfile.getStore().setValue("csect", csect.getCSECTName());
                        csectfile.getStore().setValue("csect_ddname", csect.getDDName());
                        csectfile.getStore().setValue("csect_length", csect.getLength());
                        csectfile.getStore().setValue("csect_offset", csect.getOffset());
                        try {
                            int ix;
                            CompositeSetupPage.this.session.addBreakpoints(csectfile);
                            ResourceProperty store = csectfile.getStore();
                            if (store.getBoolean("execution_count")) {
                                CompositeSetupPage.this.session.addExecutionCount(csectfile, true, (short)1);
                            }
                            if (store.getBoolean("back_trace")) {
                                CompositeSetupPage.this.session.addStatementTrace(csectfile, true);
                                if (store.getBoolean("data_monitor")) {
                                    CompositeSetupPage.this.session.addDataMonitor(csectfile, true);
                                }
                            }
                            if ((ix = this.existing.indexOf(csectfile)) >= 0) {
                                this.existing.remove(ix);
                            }
                        }
                        catch (Exception e) {
                            Logger.loggit(e);
                        }
                    }
                    first = false;
                }
                CompositeSetupPage.this.file.setMonitor(true, false);
                if (CompositeSetupPage.this.post) {
                    try {
                        CompositeSetupPage.this.session.post(null);
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                    }
                }
            }
        }
    }
}

