/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.ASMVariable;
import com.ca.intertest.common.CobolVariable;
import com.ca.intertest.common.Expressions;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.MRUList;
import com.ca.intertest.common.MemoryRequest;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.Outline;
import com.ca.intertest.common.PLIVariable;
import com.ca.intertest.common.TreeObject;
import com.ca.intertest.common.decorator;
import com.ca.intertest.common.verifyHexFixed;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.CoreExprDumpDialog;
import com.ca.intertest.dialogs.CoreExprNameDialog;
import com.ca.intertest.dialogs.CoreExprStructDialog;
import com.ca.intertest.dialogs.CoreFindDialog;
import com.ca.intertest.dialogs.CoreTextDialog;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MFAddress;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.intertest.wizards.AddressOffsetEditingSupport;
import com.ca.intertest.wizards.CharacterCellEditingSupport;
import com.ca.intertest.wizards.CoreAddrColumnLabelProvider;
import com.ca.intertest.wizards.CoreCellsColumnLabelProvider;
import com.ca.intertest.wizards.CoreCharsColumnLabelProvider;
import com.ca.intertest.wizards.CoreDumpRowList;
import com.ca.intertest.wizards.CoreStructurePage;
import com.ca.intertest.wizards.HexCellsEditingSupport;
import com.ca.intertest.wizards.IMemoryWizard;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CoreDumpPage
extends WizardPage
implements Listener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String ADDRESS_COLUMN = Messages.CoreDumpPage_2;
    private static final String CHARACTER_COLUMN = Messages.CoreDumpPage_3;
    private static final String COL_WIDTH = Messages.CoreDumpPage_4;
    private static final int[] column_width = new int[]{10, 10, 10, 10, 10, 10, 20};
    private static final Debug debug = Debug.getInstance();
    private static final String HEX_0_COLUMN = Messages.CoreDumpPage_5;
    private static final String HEX_1_COLUMN = Messages.CoreDumpPage_6;
    private static final String HEX_2_COLUMN = Messages.CoreDumpPage_7;
    private static final String HEX_3_COLUMN = Messages.CoreDumpPage_8;
    private static final int LEFT = 4;
    private static final String OFFSET_COLUMN = Messages.CoreDumpPage_9;
    private static final String[] columnNames = new String[]{ADDRESS_COLUMN, OFFSET_COLUMN, HEX_0_COLUMN, HEX_1_COLUMN, HEX_2_COLUMN, HEX_3_COLUMN, CHARACTER_COLUMN};
    private static final int[] styles = new int[]{16384, 16384, 16384, 16384, 16384, 16384, 16384};
    private Button addrButton = null;
    private Composite addressgroup;
    private Composite expressiongroup;
    private Composite variablegroup;
    private Text addrText = null;
    private Text aletText = null;
    private HashMap<String, String> attributes;
    private Button branchPush;
    private TreeObject structureTreeObject = null;
    private String pgmstruct = null;
    private Button builderPush;
    private TreeObject cmdTreeObject;
    private int datalength = 0;
    private ListerEditor editor;
    private boolean enablePost = false;
    private Button exprButton = null;
    private String exprCmd = "";
    private Combo exprCombo;
    private String[] exprList = new String[50];
    private String exprName;
    private Button fetchPush;
    private GridData gridData;
    private Group group;
    private int initFlag;
    private String initMode = "";
    private String initProgram = "";
    private String initStructure = "";
    private TreeObject initTreeObject;
    private boolean isEightByte = false;
    private Object[] keys;
    private int lang;
    private Text lthText;
    private HashMap<String, ArrayList<TreeObject>> names;
    private Button nextPush;
    private int offset = 0;
    private Text offsetText;
    private Text layoutName;
    private Outline outline;
    private String postCmd;
    private Button postPush;
    private Button prevPush;
    private String progid = "";
    private String requestCmd = "";
    private int requestlength = 0;
    private IResource resource;
    private CoreDumpRowList rowList;
    private Button searchPush;
    private debugSession session;
    private debugFile debugfile;
    private String sMsg = "";
    private MFAddress startAddr = MFAddress.ZERO_ADDR;
    private int stmt = 0;
    private final IPreferenceStore store = IntertestPlugin.getConfigurationPreferences();
    private TableViewer tableViewer;
    private String thisTitle;
    private TreeObject treeobject;
    private Button varButton = null;
    private Combo varCombo;
    private String varName = "";
    private int[] width = null;
    private Button layoutPush;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.coreDumpPage";

    public CoreDumpPage(String pageName) {
        super(pageName);
    }

    public boolean canFlipToNextPage() {
        return this.rowList.size() != 0;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.initializeDialogUnits((Control)composite);
        this.createRequestGroup(composite);
        this.createTable(composite);
        this.initialChecks();
        this.setControl((Control)composite);
        ((WizardDialog)this.getContainer()).addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() == CoreDumpPage.this) {
                    CoreDumpPage.this.getShell().setDefaultButton(CoreDumpPage.this.fetchPush);
                    CoreDumpPage.this.initialChecks();
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.coreDumpPage");
    }

    public IWizardPage getNextPage() {
        Integer level = -2;
        CoreStructurePage structurepage = (CoreStructurePage)this.getWizard().getPage(IMemoryWizard.structurepageName);
        if (this.pgmstruct == null || this.pgmstruct.length() == 0) {
            this.getStructure();
        }
        if (this.pgmstruct != null) {
            byte[] coredata;
            if (this.initMode.equals("var")) {
                TreeObject parent = this.getParent(this.initTreeObject);
                if (parent != null) {
                    level = (Integer)parent.getValue("level");
                }
                if (level < 1) {
                    parent = this.initTreeObject;
                }
                coredata = this.loadParentData(parent);
                this.structureTreeObject.setBackingdataAddress(parent.getAddress());
            } else {
                coredata = this.loadCurrentData(this.structureTreeObject);
                this.structureTreeObject.setBackingdataAddress(this.startAddr);
            }
            this.structureTreeObject.setBackingdata(ByteBuffer.wrap(coredata));
            this.structureTreeObject.setKeyword("");
            structurepage.setStructureTreeObject(this.structureTreeObject);
            structurepage.refreshViewer();
            return structurepage;
        }
        return null;
    }

    private void getStructure() {
        CoreExprStructDialog dialog = new CoreExprStructDialog(this.getShell());
        dialog.init(this.editor, this.resource, this.initProgram, this.initStructure, 0, null, this.session);
        int rc = dialog.open();
        dialog.close();
        if (rc == 0) {
            this.pgmstruct = String.valueOf(dialog.getUseProgram()) + "." + dialog.getUseStructure();
            this.structureTreeObject = dialog.getCloneTreeObject();
            this.setLayoutText();
        }
    }

    public TreeObject getParent(TreeObject child) {
        if (child == null) {
            return null;
        }
        TreeObject parent = child.getParent();
        if (parent == null) {
            return null;
        }
        Integer level = (Integer)parent.getValue("level");
        if (level < 0) {
            return null;
        }
        if (level == 1) {
            return parent;
        }
        return this.getParent(parent);
    }

    public String getTitle() {
        return String.valueOf(IMemoryWizard.CORE_WORD) + Messages.CoreDumpPage_22;
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    public void init(ListerEditor lsteditor) {
        this.editor = lsteditor;
        this.outline = lsteditor.getOutline();
        this.resource = lsteditor.getResource();
        this.progid = this.getProgid();
        this.session = (debugSession)debug.getResource((IResource)this.editor.getResource().getProject());
        Debug debug = Debug.getInstance();
        this.debugfile = (debugFile)debug.getResource(this.resource);
        this.lang = this.debugfile.getStore().getHex("gt_m_lang");
        this.initTreeObject = null;
        this.thisTitle = new decorator().decorateText(this.resource.getName(), this.resource);
        this.isEightByte = this.store.getBoolean("addrsize");
        if (this.session.isBackTraceStop(this.debugfile)) {
            this.setDescription(Messages.CoreDumpPage_112);
        } else {
            this.setDescription(" ");
        }
    }

    public void initCmd(ListerEditor lsteditor, String cmd, boolean postFlag) {
        this.init(lsteditor);
        this.thisTitle = String.valueOf(this.thisTitle) + " - " + cmd;
        this.exprCmd = cmd;
        this.enablePost = postFlag;
        if (this.initMode.length() == 0) {
            this.initMode = "cmd0";
        } else {
            this.initTreeObject = this.cmdTreeObject;
        }
    }

    public void initCmd(ListerEditor lsteditor, String cmd, boolean postFlag, CoreStructurePage page, String strProgram, String strStructure, TreeObject tree) {
        this.initProgram = strProgram;
        this.initStructure = strStructure;
        this.cmdTreeObject = tree;
        this.initMode = "cmd";
        this.initCmd(lsteditor, cmd, postFlag);
    }

    public void initVar(ListerEditor lsteditor, TreeObject treeobject, int zstmt, CoreStructurePage page) {
        this.init(lsteditor);
        this.thisTitle = String.valueOf(this.thisTitle) + " - " + this.varName;
        this.initTreeObject = treeobject;
        this.varName = treeobject.toString();
        this.startAddr = treeobject.getAddress();
        this.stmt = zstmt;
        this.initProgram = this.progid;
        this.initStructure = this.initTreeObject.getName();
        this.initMode = "var";
    }

    public boolean ok2process() {
        return true;
    }

    public void setAttribute(String key, String value) {
        if (value == null) {
            this.unsetAttribute(key);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(key, value);
        }
    }

    public boolean verifyInput(Text address) {
        String sAddressText = address.getText();
        if (sAddressText.length() == 0) {
            this.sMsg = Messages.CoreDumpPage_29;
            return false;
        }
        return true;
    }

    private String buildRequestCmd() {
        return String.format("/%s/%s/%s/%s/", this.startAddr.getAddrString(), this.offsetText.getText(), this.startAddr.getAletString(), Integer.toString(this.datalength));
    }

    private void checkWidth(Control control) {
        if (this.width == null) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            int CHAR_WIDTH = gc.getCharWidth('W');
            gc.dispose();
            this.width = new int[column_width.length];
            int j = 0;
            while (j < column_width.length) {
                this.width[j] = (int)((double)(column_width[j] * CHAR_WIDTH) * 1.2);
                ++j;
            }
        }
    }

    private void createAddressLine(Composite parent) {
        this.addrButton = new Button(parent, 16);
        this.addrButton.setText("");
        this.addrButton.setSelection(true);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.gridData.horizontalIndent = 30;
        this.addrButton.setLayoutData((Object)this.gridData);
        this.addrButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.addrButton.setSelection(true);
                CoreDumpPage.this.exprButton.setSelection(false);
                CoreDumpPage.this.varButton.setSelection(false);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.addressgroup, true);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.expressiongroup, false);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.variablegroup, false);
                CoreDumpPage.this.group.setSize(CoreDumpPage.this.group.computeSize(-1, -1));
            }
        });
        this.addressgroup = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout(7, false);
        this.addressgroup.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.addressgroup.setLayoutData((Object)this.gridData);
        Label addrLabel = new Label(this.addressgroup, 0);
        addrLabel.setText(Messages.CoreDumpPage_32);
        this.gridData = new GridData(32);
        addrLabel.setLayoutData((Object)this.gridData);
        this.addrText = new Text(this.addressgroup, 2048);
        this.addrText.setText(this.startAddr.getAddrString());
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.addrText.setTextLimit(17);
        this.addrText.setLayoutData((Object)this.gridData);
        this.addrText.addVerifyListener((VerifyListener)new verifyHexFixed());
        Label offsetLabel = new Label(this.addressgroup, 0);
        offsetLabel.setText(Messages.CoreDumpPage_33);
        this.gridData = new GridData();
        offsetLabel.setLayoutData((Object)this.gridData);
        this.offsetText = new Text(this.addressgroup, 2048);
        this.offsetText.setText("000000");
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.offsetText.setTextLimit(6);
        this.offsetText.setLayoutData((Object)this.gridData);
        this.offsetText.addVerifyListener((VerifyListener)new verifyHexFixed());
        Label aletLabel = new Label(this.addressgroup, 0);
        aletLabel.setText(Messages.CoreDumpPage_35);
        this.gridData = new GridData();
        aletLabel.setLayoutData((Object)this.gridData);
        this.aletText = new Text(this.addressgroup, 2048);
        this.aletText.setText(this.startAddr.getAletString());
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 2;
        this.aletText.setTextLimit(8);
        this.aletText.setLayoutData((Object)this.gridData);
        this.aletText.addVerifyListener((VerifyListener)new verifyHexFixed());
    }

    private void createButtonsLine(Composite parent) {
        Composite rightcolumn = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout(7, false);
        rightcolumn.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 2;
        rightcolumn.setLayoutData((Object)this.gridData);
        this.fetchPush = new Button(rightcolumn, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.fetchPush.setLayoutData((Object)this.gridData);
        this.fetchPush.setText(Messages.CoreDumpPage_36);
        this.fetchPush.setToolTipText(Messages.CoreDumpPage_37);
        this.fetchPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.doCoreRequest();
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.postPush = new Button(rightcolumn, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.postPush.setLayoutData((Object)this.gridData);
        this.postPush.setText(Messages.CoreDumpPage_38);
        this.postPush.setToolTipText(Messages.CoreDumpPage_39);
        this.postPush.setEnabled(this.enablePost);
        this.postPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.doPostRequest();
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.searchPush = new Button(rightcolumn, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.searchPush.setLayoutData((Object)this.gridData);
        this.searchPush.setText(Messages.CoreDumpPage_40);
        this.searchPush.setEnabled(false);
        this.searchPush.setToolTipText(Messages.CoreDumpPage_41);
        this.searchPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.doCoreSearch();
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.prevPush = new Button(rightcolumn, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.prevPush.setLayoutData((Object)this.gridData);
        this.prevPush.setText(Messages.CoreDumpPage_42);
        this.prevPush.setToolTipText(Messages.CoreDumpPage_43);
        this.prevPush.setEnabled(true);
        this.prevPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.doCorePrevCheck();
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.nextPush = new Button(rightcolumn, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.nextPush.setLayoutData((Object)this.gridData);
        this.nextPush.setText(Messages.CoreDumpPage_44);
        this.nextPush.setToolTipText(Messages.CoreDumpPage_45);
        this.nextPush.setEnabled(true);
        this.nextPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.doCoreNextCheck();
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.branchPush = new Button(rightcolumn, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.branchPush.setLayoutData((Object)this.gridData);
        this.branchPush.setText(Messages.CoreDumpPage_46);
        this.branchPush.setToolTipText(Messages.CoreDumpPage_47);
        this.branchPush.setEnabled(true);
        this.branchPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.doCoreBranch();
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.layoutPush = new Button(rightcolumn, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.layoutPush.setLayoutData((Object)this.gridData);
        this.layoutPush.setText(Messages.CoreDumpPage_48);
        this.layoutPush.setToolTipText(Messages.CoreDumpPage_49);
        this.layoutPush.setEnabled(true);
        this.layoutPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.getStructure();
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        new Label(rightcolumn, 0).setText(Messages.CoreDumpPage_50);
        this.layoutName = new Text(rightcolumn, 8);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 6;
        this.layoutName.setLayoutData((Object)this.gridData);
        this.setLayoutText();
    }

    private void setLayoutText() {
        if (this.initProgram.length() > 0 && this.initStructure.length() > 0) {
            TreeObject parent = null;
            if (this.initMode.equals("var")) {
                Integer level = (Integer)Attribute.getValue("level", this.initTreeObject);
                parent = level == 1 ? this.initTreeObject : this.getParent(this.initTreeObject);
                if (parent != null) {
                    this.pgmstruct = String.valueOf(this.initProgram) + "." + parent.getName();
                    this.structureTreeObject = parent;
                } else {
                    this.pgmstruct = null;
                }
            } else {
                this.pgmstruct = String.valueOf(this.initProgram) + "." + this.initStructure;
                this.structureTreeObject = this.initTreeObject;
            }
        }
        this.initProgram = "";
        this.initStructure = "";
        this.layoutName.setText(this.pgmstruct == null ? Messages.CoreDumpPage_57 : this.pgmstruct);
        this.layoutName.setSize(this.layoutName.computeSize(-1, -1));
    }

    private void createExpressionLine(Composite parent) {
        int controlwidth;
        this.exprButton = new Button(parent, 16);
        this.exprButton.setText("");
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.gridData.horizontalIndent = 30;
        this.exprButton.setLayoutData((Object)this.gridData);
        this.exprButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.addrButton.setSelection(false);
                CoreDumpPage.this.exprButton.setSelection(true);
                CoreDumpPage.this.varButton.setSelection(false);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.addressgroup, false);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.expressiongroup, true);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.variablegroup, false);
                CoreDumpPage.this.group.setSize(CoreDumpPage.this.group.computeSize(-1, -1));
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.expressiongroup = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout(7, false);
        this.expressiongroup.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.expressiongroup.setLayoutData((Object)this.gridData);
        Label exprLabel = new Label(this.expressiongroup, 0);
        exprLabel.setText(Messages.CoreDumpPage_59);
        this.gridData = new GridData(32);
        exprLabel.setLayoutData((Object)this.gridData);
        this.exprCombo = new Combo(this.expressiongroup, 516);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 5;
        this.exprCombo.setTextLimit(40);
        this.gridData.grabExcessHorizontalSpace = false;
        this.gridData.minimumWidth = controlwidth = this.convertWidthInCharsToPixels(40);
        this.gridData.widthHint = controlwidth;
        MRUList exprs = new MRUList("CORE_EXPRESSION");
        String[] stringArray = this.exprList = exprs.GetNames();
        int n = this.exprList.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.exprCombo.add(element);
            ++n2;
        }
        this.exprCombo.setLayoutData((Object)this.gridData);
        this.exprCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MRUList exprs = new MRUList("CORE_EXPRESSION");
                String cText = CoreDumpPage.this.exprCombo.getText();
                if (CoreDumpPage.this.exprCombo.indexOf(cText) < 0) {
                    CoreDumpPage.this.exprCombo.add(cText);
                    exprs.add(cText);
                    CoreDumpPage.this.exprList = CoreDumpPage.this.exprCombo.getItems();
                    Arrays.sort(CoreDumpPage.this.exprList);
                    CoreDumpPage.this.exprCombo.setItems(CoreDumpPage.this.exprList);
                }
                CoreDumpPage.this.exprCombo.setText(cText);
                CoreDumpPage.this.group.setSize(CoreDumpPage.this.group.computeSize(-1, -1));
            }

            public void widgetSelected(SelectionEvent e) {
                MRUList exprs = new MRUList("CORE_EXPRESSION");
                String cText = CoreDumpPage.this.exprCombo.getText();
                if (CoreDumpPage.this.exprCombo.indexOf(cText) < 0) {
                    CoreDumpPage.this.exprCombo.add(cText);
                    exprs.add(cText);
                    CoreDumpPage.this.exprList = CoreDumpPage.this.exprCombo.getItems();
                    Arrays.sort(CoreDumpPage.this.exprList);
                    CoreDumpPage.this.exprCombo.setItems(CoreDumpPage.this.exprList);
                }
                CoreDumpPage.this.exprCombo.setText(cText);
                CoreDumpPage.this.group.setSize(CoreDumpPage.this.group.computeSize(-1, -1));
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.builderPush = new Button(this.expressiongroup, 8);
        this.gridData = new GridData(4, 0, true, false);
        this.builderPush.setLayoutData((Object)this.gridData);
        this.builderPush.setText(Messages.CoreDumpPage_60);
        this.builderPush.setToolTipText(Messages.CoreDumpPage_61);
        this.builderPush.setEnabled(true);
        this.builderPush.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String expression;
                CoreExprDumpDialog dlg = new CoreExprDumpDialog(CoreDumpPage.this.tableViewer.getTable().getShell());
                dlg.init(CoreDumpPage.this.editor, CoreDumpPage.this.resource, CoreDumpPage.this.session.getVersion(), CoreDumpPage.this.exprCmd, 0, null, CoreDumpPage.this.session);
                int result = dlg.open();
                if (result == 0 && (expression = dlg.getExpression()).length() > 0) {
                    CoreDumpPage.this.initTreeObject = dlg.getTreeObject();
                    CoreDumpPage.this.enablePost = true;
                    if (CoreDumpPage.this.initTreeObject != null) {
                        String[] parts = CoreDumpPage.this.initTreeObject.getAlternateName().split("[.]");
                        CoreDumpPage.this.pgmstruct = CoreDumpPage.this.initTreeObject.getAlternateName();
                        CoreDumpPage.this.initProgram = parts[0];
                        CoreDumpPage.this.initStructure = parts[1];
                        CoreDumpPage.this.setLayoutText();
                    } else {
                        CoreDumpPage.this.pgmstruct = "";
                        CoreDumpPage.this.initProgram = "";
                        CoreDumpPage.this.initStructure = "";
                    }
                    CoreDumpPage.this.doCoreCmd(expression);
                    CoreDumpPage.this.getContainer().updateButtons();
                }
            }
        });
    }

    private void createRequestGroup(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setText(Messages.CoreDumpPage_66);
        GridLayout groupLayout = new GridLayout(2, false);
        this.group.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.group.setLayoutData((Object)this.gridData);
        this.createAddressLine((Composite)this.group);
        this.createExpressionLine((Composite)this.group);
        this.createVariableLine((Composite)this.group);
        this.createButtonsLine((Composite)this.group);
        this.addrButton.notifyListeners(13, new Event());
    }

    private void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        Table table = this.tableViewer.getTable();
        table.setFont(JFaceResources.getTextFont());
        int cellheight = table.getFont().getFontData()[0].getHeight() * 5;
        GridData data = new GridData(4, 4, true, true);
        table.setLayoutData((Object)data);
        this.checkWidth((Control)table);
        TableViewerFocusCellManager mgr = new TableViewerFocusCellManager(this.tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && (event.keyCode == 13 || event.character == ' ') || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, (SWTFocusCellManager)mgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        int columnIndex = 0;
        while (columnIndex < columnNames.length) {
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, styles[columnIndex]);
            switch (columnIndex) {
                case 0: {
                    column.setLabelProvider((CellLabelProvider)new CoreAddrColumnLabelProvider(columnIndex));
                    column.setEditingSupport((EditingSupport)new AddressOffsetEditingSupport((ColumnViewer)this.tableViewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 1: {
                    column.setLabelProvider((CellLabelProvider)new CoreAddrColumnLabelProvider(columnIndex));
                    column.setEditingSupport((EditingSupport)new AddressOffsetEditingSupport((ColumnViewer)this.tableViewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                case 6: {
                    column.setLabelProvider((CellLabelProvider)new CoreCharsColumnLabelProvider());
                    column.setEditingSupport((EditingSupport)new CharacterCellEditingSupport((ColumnViewer)this.tableViewer, this.session, this.debugfile, columnIndex));
                    break;
                }
                default: {
                    column.setLabelProvider((CellLabelProvider)new CoreCellsColumnLabelProvider(columnIndex));
                    column.setEditingSupport((EditingSupport)new HexCellsEditingSupport((ColumnViewer)this.tableViewer, this.session, this.debugfile, columnIndex));
                }
            }
            column.getColumn().setText(columnNames[columnIndex]);
            column.getColumn().setResizable(true);
            column.getColumn().setData(COL_WIDTH, (Object)new Integer(columnIndex));
            column.getColumn().setMoveable(false);
            column.getColumn().setWidth(this.width[columnIndex]);
            ++columnIndex;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.rowList = new CoreDumpRowList(this.resource, this.editor, this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)this.rowList);
        this.tableViewer.setColumnProperties(columnNames);
        this.setControl(this.tableViewer.getControl());
        this.tableViewer.setInput((Object)this.rowList);
        int height = this.rowList.size();
        height = height > 10 ? 10 : 5;
        table.setSize(table.computeSize(-1, height * cellheight));
    }

    private void createVariableLine(Composite parent) {
        this.varButton = new Button(parent, 16);
        this.varButton.setText("");
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 1;
        this.gridData.horizontalIndent = 30;
        this.varButton.setLayoutData((Object)this.gridData);
        this.varButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CoreDumpPage.this.addrButton.setSelection(false);
                CoreDumpPage.this.exprButton.setSelection(false);
                CoreDumpPage.this.varButton.setSelection(true);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.addressgroup, false);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.expressiongroup, false);
                CoreDumpPage.this.setEnabled(CoreDumpPage.this.variablegroup, true);
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
        this.variablegroup = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout(7, false);
        this.variablegroup.setLayout((Layout)groupLayout);
        this.gridData = new GridData(32);
        this.variablegroup.setLayoutData((Object)this.gridData);
        Label varLabel = new Label(this.variablegroup, 0);
        varLabel.setText(Messages.CoreDumpPage_68);
        this.gridData = new GridData(32);
        varLabel.setLayoutData((Object)this.gridData);
        this.varCombo = new Combo(this.variablegroup, 516);
        this.gridData = new GridData(32);
        this.gridData.horizontalSpan = 6;
        this.varCombo.setTextLimit(40);
        this.gridData.grabExcessHorizontalSpace = false;
        this.names = this.outline.getNames();
        this.keys = this.names.keySet().toArray();
        Arrays.sort(this.keys);
        Object[] objectArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            ArrayList<TreeObject> vals = this.names.get(key);
            TreeObject tree = vals.get(0);
            if (tree instanceof CobolVariable || tree instanceof PLIVariable || tree instanceof ASMVariable) {
                this.varCombo.add(key.toString());
            }
            ++n2;
        }
        this.varCombo.setLayoutData((Object)this.gridData);
        this.varCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int ptr = CoreDumpPage.this.varCombo.getSelectionIndex();
                ArrayList array = (ArrayList)CoreDumpPage.this.names.get(CoreDumpPage.this.keys[ptr]);
                for (TreeObject tree : array) {
                    CoreDumpPage.this.varName = tree.getName();
                    CoreDumpPage.this.stmt = (Integer)Attribute.getValue("statementnumber", tree);
                    CoreDumpPage.this.initTreeObject = tree;
                    CoreDumpPage.this.initStructure = CoreDumpPage.this.initTreeObject.getName();
                    CoreDumpPage.this.initMode = "var";
                    CoreDumpPage.this.initProgram = CoreDumpPage.this.getProgid();
                }
                CoreDumpPage.this.getContainer().updateButtons();
            }
        });
    }

    private void doCoreBranch() {
        try {
            ViewerCell vc = this.tableViewer.getColumnViewerEditor().getFocusCell();
            String leftNeighbor = "00000000";
            if (this.isEightByte) {
                leftNeighbor = vc.getNeighbor(4, false).getText();
            }
            this.startAddr = new MFAddress(String.valueOf(leftNeighbor) + "_" + vc.getText());
        }
        catch (Exception e) {
            this.startAddr = MFAddress.ZERO_ADDR;
            Logger.loggit(e);
        }
        this.offset = 0;
        this.exprCmd = "";
        this.addrButton.setSelection(true);
        this.exprButton.setSelection(false);
        this.varButton.setSelection(false);
        this.setEnabled(this.addressgroup, true);
        this.setEnabled(this.expressiongroup, false);
        this.setEnabled(this.variablegroup, false);
        this.addrText.setText(this.startAddr.getAddrString());
        this.offsetText.setText(HexUtil.toHex((int)this.offset));
        this.aletText.setText(this.startAddr.getAletString());
        this.doCoreRequest();
    }

    private void doCoreCmd(String cmd) {
        this.datalength = this.store.getInt("CORE_MEMLENGTH");
        this.exprCmd = cmd;
        this.exprCombo.setText(this.exprCmd);
        this.addrButton.setSelection(false);
        this.exprButton.setSelection(true);
        this.setEnabled(this.addressgroup, false);
        this.setEnabled(this.expressiongroup, true);
        this.setEnabled(this.variablegroup, false);
        this.varButton.setSelection(false);
        this.thisTitle = String.valueOf(Messages.CoreDumpPage_73) + this.exprCmd;
        this.rowList.nullTreeObject();
        this.rowList.initData(this.startAddr, this.datalength, this.offset, this.exprCmd, this.progid, this.stmt, this.varName);
        this.initFlag = this.rowList.getInitFlag();
        switch (this.initFlag) {
            case 1: {
                this.postPush.setEnabled(this.enablePost);
                this.searchPush.setEnabled(true);
                this.startAddr = this.rowList.getStartAddr();
                this.addrText.setText(this.startAddr.getAddrString());
                this.aletText.setText(this.startAddr.getAletString());
                this.tableViewer.setInput((Object)this.rowList);
                break;
            }
            case 2: {
                String[] buf = this.rowList.getTextstring();
                CoreTextDialog ctd = new CoreTextDialog(this.getShell());
                ctd.init(this.exprCmd, buf);
                ctd.open();
            }
        }
    }

    private void doCoreNext() {
        int memsize = this.store.getInt("CORE_MEMLENGTH");
        if (this.datalength < memsize) {
            this.datalength = memsize;
        } else {
            this.startAddr = this.startAddr.add((long)memsize);
        }
        this.addrText.setText(this.startAddr.getAddrString());
        this.exprCmd = "";
        this.rowList.nullTreeObject();
        this.rowList.initData(this.startAddr, this.datalength, this.offset, this.exprCmd, this.progid, this.stmt, this.varName);
        this.initFlag = this.rowList.getInitFlag();
        if (this.initFlag == 1) {
            this.searchPush.setEnabled(true);
            this.requestCmd = this.buildRequestCmd();
            this.tableViewer.setInput((Object)this.rowList);
        }
    }

    private void doCoreNextCheck() {
        if (this.ok2process()) {
            this.doCoreNext();
        }
    }

    private void doCorePrev() {
        MFAddress backaddr;
        this.datalength = this.store.getInt("CORE_MEMLENGTH");
        this.startAddr = backaddr = this.startAddr.subtract((long)this.datalength);
        this.addrText.setText(this.startAddr.getAddrString());
        int prevOffset = this.offset - this.datalength;
        if (prevOffset < 0) {
            prevOffset = 0;
        }
        this.offsetText.setText(HexUtil.toHex((int)prevOffset));
        this.exprCmd = "";
        this.rowList.nullTreeObject();
        this.rowList.initData(this.startAddr, this.datalength, this.offset, this.exprCmd, this.progid, this.stmt, this.varName);
        this.initFlag = this.rowList.getInitFlag();
        if (this.initFlag == 1) {
            this.searchPush.setEnabled(true);
            this.requestCmd = this.buildRequestCmd();
            this.tableViewer.setInput((Object)this.rowList);
        }
    }

    private void doCorePrevCheck() {
        if (this.ok2process()) {
            this.doCorePrev();
        }
    }

    private void doCoreRequest() {
        this.postPush.setEnabled(true);
        if (this.requestlength == 0) {
            this.datalength = this.store.getInt("CORE_MEMLENGTH");
        } else {
            this.datalength = this.requestlength;
            this.requestlength = 0;
        }
        if (this.addrButton.getSelection()) {
            this.processAddrButton();
        } else if (this.exprButton.getSelection()) {
            this.processExprButton();
        } else if (this.varButton.getSelection()) {
            this.processVarButton();
        } else {
            String sMsg = Messages.CoreDumpPage_76;
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)sMsg);
        }
    }

    private void doCoreSearch() {
        CoreFindDialog dlg = new CoreFindDialog(this.tableViewer.getTable().getShell());
        dlg.init();
        dlg.open();
        boolean goFlag = dlg.getGoFlag();
        if (goFlag) {
            this.rowList.initFindData(this.startAddr, this.datalength, dlg.getDirection(), dlg.getSearchString(), dlg.getRange(), dlg.getType());
            this.initFlag = this.rowList.getInitFlag();
            if (this.initFlag == 1) {
                this.searchPush.setEnabled(true);
                this.startAddr = this.rowList.getStartAddr();
                this.addrText.setText(this.startAddr.getAddrString());
                this.aletText.setText(this.startAddr.getAletString());
                this.requestCmd = this.buildRequestCmd();
                this.tableViewer.setInput((Object)this.rowList);
            }
        }
    }

    private void doCoreVar() {
        if (this.initTreeObject == null) {
            int memsize;
            this.datalength = memsize = this.store.getInt("CORE_MEMLENGTH");
        } else {
            this.datalength = 0;
            int dptyp = (Integer)Attribute.getValue("gt_dptyp", this.initTreeObject);
            if (dptyp == 4) {
                this.datalength = this.fetchDataLength(this.initTreeObject);
            }
            if (this.datalength == 0) {
                this.datalength = (Integer)Attribute.getValue("length", this.initTreeObject);
            }
        }
        this.addrButton.setSelection(false);
        this.exprButton.setSelection(false);
        this.setEnabled(this.addressgroup, false);
        this.setEnabled(this.expressiongroup, false);
        this.setEnabled(this.variablegroup, true);
        this.varButton.setSelection(true);
        this.varCombo.setText(this.varName);
        this.thisTitle = new decorator().decorateText(this.resource.getName(), this.resource);
        this.thisTitle = String.valueOf(this.thisTitle) + " - " + this.varName;
        this.rowList.initVarData(this.startAddr, this.datalength, this.offset, this.exprCmd, this.progid, this.stmt, this.varName, this.initTreeObject);
        this.initFlag = this.rowList.getInitFlag();
        if (this.initFlag == 1) {
            this.searchPush.setEnabled(true);
            this.startAddr = this.rowList.getStartAddr();
            this.addrText.setText(this.startAddr.getAddrString());
            this.aletText.setText(this.startAddr.getAletString());
            if (this.stmt > 0) {
                this.stmt = 0;
            }
            this.tableViewer.setInput((Object)this.rowList);
        }
    }

    private void doPostRequest() {
        this.postCmd = this.exprCmd;
        CoreExprNameDialog exprNameDlg = new CoreExprNameDialog(this.getShell());
        exprNameDlg.init(Messages.CoreDumpPage_79);
        if (exprNameDlg.open() == 0) {
            this.postPush.setEnabled(false);
            String nam = exprNameDlg.getExprName();
            if (nam.length() != 0) {
                String view = exprNameDlg.getView();
                this.exprName = nam;
                if (this.requestCmd.length() != 0) {
                    this.postCmd = this.requestCmd;
                }
                if (this.postCmd.length() != 0) {
                    this.treeobject = Expressions.getTree(this.exprName, "CORE_EXPRESSION");
                    this.treeobject.setKeyword(this.exprName);
                    this.treeobject.setAlternateName(this.postCmd);
                    this.treeobject.setAddress(this.startAddr);
                    Integer len = this.store.getInt("DATAVIEW_ASM_VAR_DEFAULT_LENGTH");
                    if (len == 0) {
                        len = 20;
                    }
                    this.treeobject.setBackingdata(ByteBuffer.wrap(this.rowList.getCoredata()));
                    this.treeobject.setAttribute("length", Integer.toString(len));
                    this.save_exprcmd(view);
                }
            }
        }
    }

    private void doRequestCmd(String cmd) {
        if (cmd.charAt(0) == '/') {
            String str;
            String[] parms = cmd.split("/");
            try {
                this.startAddr = new MFAddress(parms[1]);
            }
            catch (Exception e) {
                this.startAddr = MFAddress.ZERO_ADDR;
                Logger.loggit(e);
            }
            try {
                this.offset = Integer.parseInt(parms[2], 16);
            }
            catch (Exception e) {
                this.offset = 0;
                Logger.loggit(e);
            }
            try {
                this.startAddr.setAlet(Long.parseLong(parms[3], 16));
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
            if (parms.length == 5 && (str = parms[4]).length() > 0) {
                this.requestlength = Integer.valueOf(str);
            }
            this.exprCmd = "";
            this.addrButton.setSelection(true);
            this.exprButton.setSelection(false);
            this.setEnabled(this.addressgroup, true);
            this.setEnabled(this.expressiongroup, false);
            this.setEnabled(this.variablegroup, false);
            this.varButton.setSelection(false);
            this.addrText.setText(this.startAddr.getAddrString());
            this.offsetText.setText(HexUtil.toHex((int)this.offset));
            this.aletText.setText(this.startAddr.getAletString());
            this.doCoreRequest();
        }
    }

    private String getProgid() {
        return decorator.getShortName(this.resource);
    }

    private void initialChecks() {
        if (this.varName.length() != 0) {
            this.doCoreVar();
        } else if (this.exprCmd.length() != 0) {
            if (this.exprCmd.substring(0, 1).equals("/")) {
                this.doRequestCmd(this.exprCmd);
            } else {
                this.doCoreCmd(this.exprCmd);
            }
        } else if (this.requestCmd.length() != 0) {
            this.doRequestCmd(this.requestCmd);
        }
        this.varName = "";
        this.exprCmd = "";
        this.requestCmd = "";
    }

    private byte[] loadCurrentData(TreeObject structureTreeObject) {
        byte[] coredata;
        int cdDataLth;
        if (structureTreeObject == null) {
            return new byte[0];
        }
        int toDataLth = (Integer)Attribute.getValue("length", structureTreeObject);
        if (toDataLth > (cdDataLth = this.rowList.getCoredata().length)) {
            coredata = new byte[toDataLth];
            byte[] coredata0 = this.rowList.getCoredata();
            int i = 0;
            while (i < toDataLth) {
                coredata[i] = i < cdDataLth ? coredata0[i] : (byte)0;
                ++i;
            }
        } else {
            coredata = this.rowList.getCoredata();
        }
        return coredata;
    }

    private byte[] loadParentData(TreeObject structureTreeObject) {
        CoreDumpRowList tempList = new CoreDumpRowList(this.resource, this.editor, this.tableViewer);
        int tempStmt = (Integer)Attribute.getValue("statementnumber", structureTreeObject);
        int tempDataLength = (Integer)Attribute.getValue("length", structureTreeObject);
        String tempVarName = structureTreeObject.getName();
        tempList.initVarData(MFAddress.ZERO_ADDR, tempDataLength, 0, "", this.progid, tempStmt, tempVarName, structureTreeObject);
        if (tempList.getInitFlag() == 1) {
            return tempList.getCoredata();
        }
        return null;
    }

    private void processAddrButton() {
        boolean rc = this.verifyInput(this.addrText);
        if (!rc) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)this.sMsg);
        } else {
            try {
                this.startAddr = new MFAddress(this.addrText.getText());
            }
            catch (Exception e) {
                Logger.loggit(e);
                this.startAddr = MFAddress.ZERO_ADDR;
            }
            this.offset = Integer.parseInt(this.offsetText.getText(), 16);
            this.exprCmd = "";
            this.varName = "";
            this.initTreeObject = null;
            this.initStructure = "";
            this.initMode = "";
            if (this.datalength == 0) {
                this.datalength = 1200;
                this.lthText.setText("1200");
            }
            this.requestCmd = this.buildRequestCmd();
            this.rowList.nullTreeObject();
            this.rowList.initData(this.startAddr, this.datalength, this.offset, this.exprCmd, this.progid, this.stmt, this.varName);
            this.initFlag = this.rowList.getInitFlag();
            if (this.initFlag == 1) {
                this.searchPush.setEnabled(true);
                this.startAddr = this.rowList.getStartAddr();
                this.addrText.setText(this.startAddr.getAddrString());
                this.aletText.setText(this.startAddr.getAletString());
                this.thisTitle = new decorator().decorateText(this.resource.getName(), this.resource);
                this.thisTitle = String.valueOf(this.thisTitle) + Messages.CoreDumpPage_92 + this.startAddr.getAddrString();
                this.tableViewer.setInput((Object)this.rowList);
            }
        }
    }

    private void processExprButton() {
        this.startAddr = MFAddress.ZERO_ADDR;
        this.offset = 0;
        this.requestCmd = "";
        this.varName = "";
        this.initTreeObject = null;
        this.initStructure = "";
        this.initMode = "";
        this.exprCmd = this.exprCombo.getText().toUpperCase();
        this.exprCombo.setText(this.exprCmd);
        if (this.exprCmd.length() == 0) {
            this.sMsg = Messages.CoreDumpPage_97;
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)this.sMsg);
        } else {
            this.rowList.nullTreeObject();
            this.rowList.initData(this.startAddr, this.datalength, this.offset, this.exprCmd, this.progid, this.stmt, this.varName);
            this.initFlag = this.rowList.getInitFlag();
            this.thisTitle = String.valueOf(Messages.CoreDumpPage_98) + this.exprCmd;
            switch (this.initFlag) {
                case 1: {
                    this.searchPush.setEnabled(true);
                    this.startAddr = this.rowList.getStartAddr();
                    this.addrText.setText(this.startAddr.getAddrString());
                    this.aletText.setText(this.startAddr.getAletString());
                    this.tableViewer.setInput((Object)this.rowList);
                    break;
                }
                case 2: {
                    String[] buf = this.rowList.getTextstring();
                    CoreTextDialog ctd = new CoreTextDialog(this.getShell());
                    ctd.init(this.exprCmd, buf);
                    ctd.open();
                }
            }
        }
    }

    private void processVarButton() {
        String var = this.varName = this.varCombo.getText().toUpperCase();
        this.exprCmd = "";
        this.startAddr = MFAddress.ZERO_ADDR;
        if (this.varName.length() == 0) {
            this.varCombo.setText("");
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)Messages.CoreDumpPage_101);
        } else {
            ArrayList<TreeObject> namelist;
            int dot;
            if (this.lang == 16 && ((dot = var.indexOf(".")) == 2 || dot == 3) && var.substring(0, 1).equals("R") && var.length() > dot + 1) {
                String[] v = var.split("[.]");
                var = v[1];
                if (!this.session.isCICS()) {
                    this.varName = var;
                }
            }
            if ((namelist = this.names.get(var)) == null) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)(String.valueOf(Messages.CoreDumpPage_105) + var));
            } else {
                this.initTreeObject = namelist.get(0);
                this.initStructure = this.initTreeObject.getName();
                this.initMode = "var";
                this.stmt = (Integer)Attribute.getValue("statementnumber", this.initTreeObject);
                this.setLayoutText();
                this.selectCoreVar();
            }
        }
    }

    private synchronized void save_exprcmd(final String view) {
        if (this.resource != null) {
            IWorkspaceRunnable rr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        CoreDumpPage.this.setAttribute("altname", CoreDumpPage.this.postCmd);
                        CoreDumpPage.this.setAttribute("keeptype", "DATAVIEW_EXPRESSION");
                        CoreDumpPage.this.setAttribute("keyword", CoreDumpPage.this.exprName);
                        CoreDumpPage.this.setAttribute("name", CoreDumpPage.this.treeobject.getName());
                        CoreDumpPage.this.setAttribute("postview", view);
                        IMarker marker = CoreDumpPage.this.resource.createMarker("com.ca.intertest.keep");
                        if (marker != null && marker.exists()) {
                            marker.setAttributes((Map)CoreDumpPage.this.attributes);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            try {
                this.resource.getWorkspace().run(rr, (ISchedulingRule)this.resource.getProject(), 1, null);
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    private void selectCoreVar() {
        this.postPush.setEnabled(true);
        this.offset = 0;
        this.exprCmd = "";
        this.startAddr = MFAddress.ZERO_ADDR;
        this.thisTitle = new decorator().decorateText(this.resource.getName(), this.resource);
        this.thisTitle = String.valueOf(this.thisTitle) + " - " + this.varName;
        this.requestCmd = this.varName;
        if (this.session.isCICS() && this.initTreeObject instanceof ASMVariable) {
            MemoryRequest mr = new MemoryRequest(this.session, this.editor, this.progid, this.lang);
            this.requestCmd = mr.getASMVarName(this.initTreeObject, this.editor, this.varName, 0L);
        }
        this.requestCmd = "'" + this.requestCmd + "'";
        this.doCoreVar();
    }

    private void setEnabled(Composite group, boolean enabled) {
        group.setEnabled(enabled);
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    private void unsetAttribute(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    private int fetchDataLength(TreeObject initTreeObject) {
        int varLen = 0;
        TreeObject varLenTree = this.outline.getVarLenTreeobject(initTreeObject);
        if (varLenTree == null) {
            return 0;
        }
        MemoryRequest memRequest = new MemoryRequest(this.session, this.editor, this.initProgram, this.lang);
        TreeObject tree = Expressions.getTree(varLenTree.getName(), "CORE_EXPRESSION");
        tree.setKeyword(varLenTree.getName());
        String expr = "/" + varLenTree.getAddress().getAddrString() + "/0/00000000/2";
        tree.setAlternateName(expr);
        tree.setAttribute("length", Integer.toString(2));
        memRequest.sendMemoryMessage(tree);
        varLen = tree.getBackingdata().getShort() + 2;
        return varLen;
    }
}

