/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifyDSN;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.IT_ErrorDialog;
import com.ca.intertest.dialogs.MRUCombo;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.server.ServerElement;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.CalendarAttribute;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IAttribute;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MemberInfo;
import com.ca.intertest.tools.ProtsymMessage;
import com.ca.intertest.wizards.loadListings;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardResourceImportPage;

public class ImportListingPage
extends WizardResourceImportPage
implements Listener {
    private static final int SCROLL_LINES = 5;
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    ArrayList<Member> memberslist;
    private FileConnection connection = null;
    private CheckboxTableViewer viewer;
    private MRUCombo protlist;
    private Combo serverid;
    private Button refresh;
    private Button selectall;
    private Button deselectall;
    private Button overridecheck;
    private Button monitorall;
    private String DSN;
    private FileServer server;
    private debugSession session;
    IDialogSettings settings = null;
    Composite servergroup;
    private final String CONTEXT_HELP_ID = "com.ca.intertest.importListingPage";
    private static final int MEMBER_BASIC = 0;
    private static final int MEMBER_NAME = 0;
    private static final int MEMBER_LANG = 1;
    private static final int MEMBER_TIME = 2;
    private static final int MEMBER_DESC = 3;
    private static final String[] labels = new String[]{Messages.ImportListingPage_2, Messages.ImportListingPage_3, Messages.ImportListingPage_4, Messages.ImportListingPage_5};
    private static final int[] styles = new int[]{16384, 16384, 16384, 16384};
    private static final int[] order;
    private static final int[] COLUMN_WIDTHS;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        order = nArray;
        COLUMN_WIDTHS = new int[]{10, 8, 14, 25};
    }

    public ImportListingPage(String name, IStructuredSelection selection) throws ITException {
        super(name, selection);
        this.setTitle(Messages.ImportListingPage_6);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setTitle(Messages.ImportListingPage_7);
        this.setDescription(Messages.ImportListingPage_8);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.intertest.importListingPage");
    }

    protected void restoreWidgetValues() {
        if (this.settings == null) {
            this.settings = this.getDialogSettings();
        }
        if (this.settings != null) {
            if (this.settings.get("override") == null) {
                this.settings.put("override", false);
            }
            if (this.settings.get("server") == null) {
                this.settings.put("server", "");
            }
            if (this.settings.get("protsym") == null) {
                this.settings.put("protsym", "");
            }
            if (this.settings.get("monitor") == null) {
                this.settings.put("monitor", false);
            }
        }
    }

    protected void saveWidgetValues() {
        if (this.settings == null) {
            this.restoreWidgetValues();
        }
        if (this.settings != null) {
            this.settings.put("override", this.overridecheck.getSelection());
            this.settings.put("monitor", this.monitorall.getSelection());
            this.settings.put("server", this.serverid.getText());
            this.protlist.save();
            this.settings.put("protsym", this.protlist.getSelected());
        }
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    private void ErrorMessage(String text, Throwable e) {
        IT_ErrorDialog.openError(this.getShell(), this.getWizard().getWindowTitle(), text, e);
    }

    private void ErrorMessage(String text) {
        MessageDialog.openError((Shell)this.getShell(), (String)this.getWizard().getWindowTitle(), (String)text);
    }

    public boolean finish() {
        Object[] files = this.viewer.getCheckedElements();
        boolean result = false;
        this.saveWidgetValues();
        loadListings loader = new loadListings(files, this.session, this.overridecheck.getSelection(), this.monitorall.getSelection(), this.viewer, this.server);
        try {
            IWizardContainer container = this.getContainer();
            if (container != null) {
                container.run(true, true, (IRunnableWithProgress)loader);
                result = true;
            } else {
                result = false;
            }
        }
        catch (InvocationTargetException e) {
            Logger.loggit(e);
            this.ErrorMessage(HexUtil.getErrorText((Throwable)e.getCause()), e);
        }
        catch (InterruptedException e) {
            Logger.loggit(e);
            this.ErrorMessage(HexUtil.getErrorText((Throwable)e), e);
        }
        catch (Error e) {
            Logger.loggit(e.getCause());
            this.ErrorMessage(HexUtil.getErrorText((Throwable)e), e);
        }
        return result;
    }

    private String getDSN() {
        return this.protlist.getSelected();
    }

    protected void createSourceGroup(Composite parent) {
        if (this.settings == null) {
            this.restoreWidgetValues();
        }
        this.memberslist = new ArrayList();
        this.DSN = this.settings.get("protsym");
        if (this.DSN == null) {
            this.DSN = "";
        }
        String lastserver = this.settings.get("server");
        this.servergroup = new Composite(parent, 0);
        GridLayout serverlayout = new GridLayout(3, false);
        this.servergroup.setLayout((Layout)serverlayout);
        new Label(this.servergroup, 131072).setText(Messages.ImportListingPage_26);
        this.serverid = new Combo(this.servergroup, 2060);
        int iselect = -1;
        int idefault = 0;
        int i = 0;
        for (FileServer element : ServerList.getInstance().getFileServers()) {
            String id = element.getName();
            this.serverid.add(id, i);
            if (id.equals(lastserver)) {
                iselect = i;
            } else if (element.isDefaultserver()) {
                idefault = i;
            }
            ++i;
        }
        this.serverid.select(iselect < 0 ? idefault : iselect);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = 2;
        data.horizontalAlignment = 1;
        this.serverid.setLayoutData((Object)data);
        this.serverid.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileServer s1 = ServerList.getInstance().getFileServer(ImportListingPage.this.serverid.getText());
                if (ImportListingPage.this.server == null || !ImportListingPage.this.server.equals(s1)) {
                    ImportListingPage.this.server = s1;
                    if (ImportListingPage.this.memberslist.size() > 0) {
                        ImportListingPage.this.memberslist.clear();
                    }
                }
                ImportListingPage.this.viewer.refresh();
                ImportListingPage.this.getWizard().getContainer().updateButtons();
            }
        });
        new Label(this.servergroup, 131072).setText(Messages.ImportListingPage_27);
        this.protlist = new MRUCombo(this.servergroup, 2052, "PROTSYM");
        final Combo combo = this.protlist.getCombo();
        GridData griddata = (GridData)combo.getLayoutData();
        int width = Math.max(combo.getText().length(), 44);
        String[] stringArray = combo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            width = Math.max(width, item.length());
            ++n2;
        }
        griddata.widthHint = this.convertWidthInCharsToPixels(width);
        griddata.minimumWidth = this.convertWidthInCharsToPixels(width);
        combo.setSize(combo.computeSize(width, -1));
        combo.setTextLimit(44);
        combo.addVerifyListener((VerifyListener)new verifyDSN());
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String d1 = combo.getText();
                if (ImportListingPage.this.DSN == null || ImportListingPage.this.DSN.length() == 0 || !d1.equals(ImportListingPage.this.DSN)) {
                    ImportListingPage.this.DSN = d1;
                    if (ImportListingPage.this.memberslist.size() > 0) {
                        ImportListingPage.this.memberslist.clear();
                    }
                }
                ImportListingPage.this.viewer.refresh();
                ImportListingPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.refresh = new Button(this.servergroup, 8);
        this.refresh.setText(Messages.ImportListingPage_28);
        this.refresh.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                loadList loader = new loadList();
                try {
                    ImportListingPage.this.getContainer().run(false, false, (IRunnableWithProgress)loader);
                }
                catch (InvocationTargetException e1) {
                    Logger.loggit(e1);
                    ImportListingPage.this.ErrorMessage(HexUtil.getErrorText((Throwable)e1.getCause()), e1);
                }
                catch (InterruptedException interruptedException) {}
                ImportListingPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.createSpacer(parent);
        Table table = new Table(parent, 2850);
        GC gc = new GC((Drawable)table);
        int charwidth = gc.getCharWidth('W');
        gc.dispose();
        i = 0;
        while (i < labels.length) {
            TableColumn column = new TableColumn(table, styles[i]);
            column.setText(labels[i]);
            column.setWidth(COLUMN_WIDTHS[i] * charwidth);
            column.setMoveable(true);
            column.setResizable(true);
            if (labels[i].equalsIgnoreCase("Time")) {
                column.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!(ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorChronological)) {
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(128);
                            ImportListingPage.this.viewer.setComparator((ViewerComparator)new ViewComparatorChronological());
                            ImportListingPage.this.viewer.refresh();
                        } else if (ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorChronological) {
                            ViewComparatorChronological comp = (ViewComparatorChronological)ImportListingPage.this.viewer.getComparator();
                            comp.reverseDirection();
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(comp.getDirection());
                            ImportListingPage.this.viewer.refresh();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            } else if (labels[i].equalsIgnoreCase("Program")) {
                column.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!(ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorAlphabetical)) {
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(128);
                            ImportListingPage.this.viewer.setComparator((ViewerComparator)new ViewComparatorAlphabetical());
                            ImportListingPage.this.viewer.refresh();
                        } else if (ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorAlphabetical) {
                            ViewComparatorAlphabetical comp = (ViewComparatorAlphabetical)ImportListingPage.this.viewer.getComparator();
                            comp.reverseDirection();
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(comp.getDirection());
                            ImportListingPage.this.viewer.refresh();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            } else if (labels[i].equalsIgnoreCase("Language")) {
                column.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!(ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorLanguage)) {
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(128);
                            ImportListingPage.this.viewer.setComparator((ViewerComparator)new ViewComparatorLanguage());
                            ImportListingPage.this.viewer.refresh();
                        } else if (ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorLanguage) {
                            ViewComparatorLanguage comp = (ViewComparatorLanguage)ImportListingPage.this.viewer.getComparator();
                            comp.reverseDirection();
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(comp.getDirection());
                            ImportListingPage.this.viewer.refresh();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            } else if (labels[i].equalsIgnoreCase("Compiler")) {
                column.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!(ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorCompiler)) {
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(128);
                            ImportListingPage.this.viewer.setComparator((ViewerComparator)new ViewComparatorCompiler());
                            ImportListingPage.this.viewer.refresh();
                        } else if (ImportListingPage.this.viewer.getComparator() instanceof ViewComparatorCompiler) {
                            ViewComparatorCompiler comp = (ViewComparatorCompiler)ImportListingPage.this.viewer.getComparator();
                            comp.reverseDirection();
                            ImportListingPage.this.viewer.getTable().setSortColumn((TableColumn)e.widget);
                            ImportListingPage.this.viewer.getTable().setSortDirection(comp.getDirection());
                            ImportListingPage.this.viewer.refresh();
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            ++i;
        }
        data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setFont(parent.getFont());
        table.setColumnOrder(order);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setComparator((ViewerComparator)new ViewComparatorAlphabetical());
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput(new Object());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element;
                IStructuredSelection selected = (IStructuredSelection)ImportListingPage.this.viewer.getSelection();
                boolean checked = event.getChecked();
                Object checkit = event.getElement();
                Object[] list = selected.toArray();
                boolean found = false;
                Object[] objectArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    element = objectArray[n2];
                    if (element == checkit) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found && list.length > 1) {
                    objectArray = list;
                    n = list.length;
                    n2 = 0;
                    while (n2 < n) {
                        element = objectArray[n2];
                        ImportListingPage.this.viewer.setChecked(element, checked);
                        ++n2;
                    }
                }
                ImportListingPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Control control = this.viewer.getControl();
        this.layoutTopControl(control);
        GridData gridData = new GridData(4, 4, true, true, 2, 2);
        gc = new GC((Drawable)control);
        int height = gc.stringExtent((String)"W").y;
        gc.dispose();
        Point size = control.computeSize(-1, height * 5);
        control.setSize(size);
        gridData.heightHint = size.y;
        control.setLayoutData((Object)gridData);
        Composite buttongroup = new Composite(parent, 0);
        GridLayout buttonlayout = new GridLayout(3, false);
        buttongroup.setLayout((Layout)buttonlayout);
        this.selectall = new Button(buttongroup, 8);
        this.selectall.setText(Messages.ImportListingPage_30);
        this.selectall.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportListingPage.this.viewer.setAllChecked(true);
                ImportListingPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.deselectall = new Button(buttongroup, 8);
        this.deselectall.setText(Messages.ImportListingPage_31);
        this.deselectall.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportListingPage.this.viewer.setAllChecked(false);
                ImportListingPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Point p1 = parent.getSize();
        parent.setSize(p1);
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        try {
            this.getDialogSettings().getInt("DIALOG_X_ORIGIN");
        }
        catch (NumberFormatException numberFormatException) {
            spec.widthHint = 300;
            spec.heightHint = 250;
        }
        control.setLayoutData((Object)spec);
    }

    protected void displayErrorDialog(String message) {
        super.displayErrorDialog(message);
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        if (this.settings == null) {
            this.restoreWidgetValues();
        }
        GridLayout layout = new GridLayout(2, false);
        optionsGroup.setLayout((Layout)layout);
        this.overridecheck = new Button((Composite)optionsGroup, 32);
        this.overridecheck.setSelection(this.settings.getBoolean("override"));
        this.overridecheck.setText(Messages.ImportListingPage_34);
        this.monitorall = new Button((Composite)optionsGroup, 32);
        this.monitorall.setSelection(this.settings.getBoolean("monitor"));
        this.monitorall.setText(Messages.ImportListingPage_36);
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        if (!this.refresh.isEnabled()) {
            this.refresh.setEnabled(true);
            this.selectall.setEnabled(true);
            this.deselectall.setEnabled(true);
        }
        if (!this.isCurrentPage()) {
            return false;
        }
        this.DSN = this.getDSN();
        if (this.DSN == null || this.DSN.length() == 0) {
            this.setErrorMessage(Messages.ImportListingPage_63);
            this.refresh.setEnabled(false);
            this.selectall.setEnabled(false);
            this.deselectall.setEnabled(false);
            return false;
        }
        this.server = ServerList.getInstance().getFileServer(this.serverid.getText());
        if (this.memberslist == null || this.memberslist.size() == 0) {
            this.setErrorMessage(Messages.ImportListingPage_64);
            this.selectall.setEnabled(false);
            this.deselectall.setEnabled(false);
            return false;
        }
        this.selectall.setEnabled(this.memberslist.size() > 0);
        if (this.viewer.getCheckedElements().length < 1) {
            this.deselectall.setEnabled(false);
            this.setErrorMessage(Messages.ImportListingPage_65);
            return false;
        }
        this.deselectall.setEnabled(true);
        IProject project = this.getSpecifiedContainer().getProject();
        if (project == null) {
            this.setErrorMessage(Messages.ImportListingPage_66);
            return false;
        }
        this.session = Debug.getInstance().getSession((IResource)project);
        if (this.session == null) {
            this.setErrorMessage(Messages.ImportListingPage_66);
            return false;
        }
        return super.isPageComplete();
    }

    protected boolean validateSourceGroup() {
        return true;
    }

    public boolean cancel() {
        this.saveWidgetValues();
        return true;
    }

    private String getCompilerText(Member member) {
        IAttribute member_lang = Attribute.getInstance((String)"gt_m_lang", (String)"");
        IAttribute member_xa = Attribute.getInstance((String)"gt_m_xa", (String)"0");
        IAttribute member_cobol = Attribute.getInstance((String)"gt_m_cty", (String)"");
        IAttribute member_asm = Attribute.getInstance((String)"gt_m_avr", (String)"");
        IAttribute member_pl1 = Attribute.getInstance((String)"gt_m_plc", (String)"");
        String text = "";
        Integer lang = (Integer)member_lang.setValue(member.getAttribute("gt_m_lang"));
        switch (lang) {
            case 32: {
                text = member_cobol.toString(member.getAttribute("gt_m_cty"));
                break;
            }
            case 16: {
                String avr = member.getAttribute("gt_m_avr");
                if (avr == null) {
                    text = Messages.ImportListingPage_56;
                    break;
                }
                text = member_asm.toString(avr);
                break;
            }
            case 128: {
                String plc = member.getAttribute("gt_m_plc");
                text = plc == null ? Messages.ImportListingPage_56 : member_pl1.toString(plc);
            }
        }
        Boolean xa = (Boolean)member_xa.setValue(member.getAttribute("gt_m_xa"));
        if (xa.booleanValue()) {
            text = String.valueOf(text) + " XA";
        }
        return text;
    }

    protected IPath getContainerFullPath() {
        return super.getContainerFullPath();
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        super.setupSelectionsBasedOnSelectedTypes();
    }

    public class ViewComparatorAlphabetical
    extends ViewerComparator {
        public static final int ASCENDING = 0;
        public static final int DESCENDING = 1;
        private int direction;

        public int compare(Viewer viewer, Object e1, Object e2) {
            Member member1 = (Member)e1;
            Member member2 = (Member)e2;
            int result = member1.getName().compareTo(member2.getName());
            if (this.direction == 0) {
                return result;
            }
            return -result;
        }

        public void reverseDirection() {
            this.direction = this.direction == 0 ? 1 : 0;
        }

        public int getDirection() {
            if (this.direction == 0) {
                return 128;
            }
            return 1024;
        }
    }

    public class ViewComparatorChronological
    extends ViewerComparator {
        public static final int ASCENDING = 0;
        public static final int DESCENDING = 1;
        private int direction;

        public int compare(Viewer viewer, Object e1, Object e2) {
            Member member1 = (Member)e1;
            Member member2 = (Member)e2;
            int result = member1.getTimestamp().compareTo(member2.getTimestamp());
            if (this.direction == 0) {
                return result;
            }
            return -result;
        }

        public void reverseDirection() {
            this.direction = this.direction == 0 ? 1 : 0;
        }

        public int getDirection() {
            if (this.direction == 0) {
                return 128;
            }
            return 1024;
        }
    }

    public class ViewComparatorCompiler
    extends ViewerComparator {
        public static final int ASCENDING = 0;
        public static final int DESCENDING = 1;
        private int direction;

        public int compare(Viewer viewer, Object e1, Object e2) {
            Member member1 = (Member)e1;
            Member member2 = (Member)e2;
            int result = ImportListingPage.this.getCompilerText(member1).compareTo(ImportListingPage.this.getCompilerText(member2));
            if (this.direction == 0) {
                return result;
            }
            return -result;
        }

        public void reverseDirection() {
            this.direction = this.direction == 0 ? 1 : 0;
        }

        public int getDirection() {
            if (this.direction == 0) {
                return 128;
            }
            return 1024;
        }
    }

    public class ViewComparatorLanguage
    extends ViewerComparator {
        public static final int ASCENDING = 0;
        public static final int DESCENDING = 1;
        private int direction;

        public int compare(Viewer viewer, Object e1, Object e2) {
            Member member1 = (Member)e1;
            Member member2 = (Member)e2;
            int result = member1.getAttribute("gt_m_lang").compareTo(member2.getAttribute("gt_m_lang"));
            if (this.direction == 0) {
                return result;
            }
            return -result;
        }

        public void reverseDirection() {
            this.direction = this.direction == 0 ? 1 : 0;
        }

        public int getDirection() {
            if (this.direction == 0) {
                return 128;
            }
            return 1024;
        }
    }

    public class ViewContentProvider
    implements IStructuredContentProvider {
        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return ImportListingPage.this.memberslist.toArray();
        }

        public void dispose() {
        }
    }

    public class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        IAttribute member_name = Attribute.getInstance((String)"name", (String)"");
        IAttribute member_lang = Attribute.getInstance((String)"gt_m_lang", (String)"");
        CalendarAttribute member_time = (CalendarAttribute)Attribute.getInstance((String)"time", (String)"");
        IAttribute member_xa = Attribute.getInstance((String)"gt_m_xa", (String)"0");
        IAttribute member_version = Attribute.getInstance((String)"version", (String)"");
        IAttribute member_cobol = Attribute.getInstance((String)"gt_m_cty", (String)"");
        IAttribute member_asm = Attribute.getInstance((String)"gt_m_avr", (String)"");
        IAttribute member_pl1 = Attribute.getInstance((String)"gt_m_plc", (String)"");

        public String getColumnText(Object obj, int index) {
            Member member = (Member)obj;
            String text = "";
            switch (index) {
                case 0: {
                    text = this.member_name.toString(member.getAttribute("name"));
                    break;
                }
                case 1: {
                    text = this.member_lang.toString(member.getAttribute("gt_m_lang"));
                    break;
                }
                case 3: {
                    Integer lang = (Integer)this.member_lang.setValue(member.getAttribute("gt_m_lang"));
                    switch (lang) {
                        case 32: {
                            text = this.member_cobol.toString(member.getAttribute("gt_m_cty"));
                            break;
                        }
                        case 16: {
                            String avr = member.getAttribute("gt_m_avr");
                            if (avr == null) {
                                text = Messages.ImportListingPage_56;
                                break;
                            }
                            text = this.member_asm.toString(avr);
                            break;
                        }
                        case 128: {
                            String plc = member.getAttribute("gt_m_plc");
                            text = plc == null ? Messages.ImportListingPage_56 : this.member_pl1.toString(plc);
                        }
                    }
                    Boolean xa = (Boolean)this.member_xa.setValue(member.getAttribute("gt_m_xa"));
                    if (!xa.booleanValue()) break;
                    text = String.valueOf(text) + " XA";
                    break;
                }
                case 2: {
                    text = member.getAttribute("time");
                }
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    private class loadList
    implements IRunnableWithProgress {
        private loadList() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            block12: {
                monitor.beginTask(Messages.ImportListingPage_59, -1);
                int sel = ImportListingPage.this.serverid.getSelectionIndex();
                String DSN = ImportListingPage.this.getDSN();
                DebugMessage message = null;
                ServerElement element = ServerList.getInstance().getServer(ImportListingPage.this.serverid.getText());
                if (sel >= 0 && DSN != null && DSN.length() > 0) {
                    if (ImportListingPage.this.connection == null) {
                        ImportListingPage.this.connection = new FileConnection(element);
                    } else if (!ImportListingPage.this.connection.getServer().equals(element)) {
                        ImportListingPage.this.connection = new FileConnection(element);
                    }
                    try {
                        ImportListingPage.this.connection.connect(true);
                        CVMO cvmo = ImportListingPage.this.connection.getMembers(DSN);
                        if (cvmo == null) {
                            ImportListingPage.this.ErrorMessage(Messages.ImportListingPage_60);
                            break block12;
                        }
                        try {
                            message = cvmo.getMessage(1);
                            if (message.getMessageID() != 28) {
                                String text = String.format(Messages.ImportListingPage_61, DSN, IConstants.LINEFEED, ImportListingPage.this.connection.getErrorText());
                                ImportListingPage.this.ErrorMessage(text);
                            } else {
                                ImportListingPage.this.memberslist.clear();
                                for (MemberInfo member : ((ProtsymMessage)message).getMembers()) {
                                    ImportListingPage.this.memberslist.add(new Member((ProtsymMessage)message, member));
                                }
                            }
                        }
                        catch (Exception e) {
                            Logger.loggit(e);
                        }
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                        ImportListingPage.this.ErrorMessage(String.valueOf(Messages.ImportListingPage_62) + IConstants.LINEFEED + ImportListingPage.this.connection.getErrorText(), e);
                    }
                }
            }
            monitor.done();
            ImportListingPage.this.viewer.refresh();
            ImportListingPage.this.getWizard().getContainer().updateButtons();
        }
    }
}

