/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.wizards.ChannelWizard;
import com.ca.intertest.wizards.CoreDumpPage;
import com.ca.intertest.wizards.CoreStructurePage;
import com.ca.intertest.wizards.IMemoryWizard;
import com.ca.intertest.wizards.IntertestWizardDialog;
import com.ca.intertest.wizards.StorageWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class MemoryWizardDialog
extends IntertestWizardDialog {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    public static final int PrePageID = 1024;
    public static final int DumpID = 1025;
    public static final int LayoutID = 1026;

    public MemoryWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        IWizard wizard = this.getWizard();
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        if (wizard.isHelpAvailable()) {
            this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
        } else if (wizard instanceof ChannelWizard) {
            this.createButton(parent, 1024, IMemoryWizard.CHANNEL_WORD, false);
        } else if (wizard instanceof StorageWizard) {
            this.createButton(parent, 1024, IMemoryWizard.STORAGE_WORD, false);
        }
        this.createButton(parent, 1025, IMemoryWizard.CORE_WORD, false);
        this.createButton(parent, 1026, IMemoryWizard.STRUCTURE_WORD, false);
        this.createButton(parent, 1, Messages.MemoryWizardDialog_0, true);
    }

    public void updateButtons() {
        IWizardPage page = this.getCurrentPage();
        Button prepage = this.getButton(1024);
        if (page instanceof CoreStructurePage) {
            this.getButton(1026).setEnabled(false);
            this.getButton(1025).setEnabled(true);
        } else if (page instanceof CoreDumpPage) {
            this.getButton(1026).setEnabled(page.canFlipToNextPage());
            this.getButton(1025).setEnabled(false);
            if (prepage != null) {
                prepage.setEnabled(true);
            }
        } else {
            this.getButton(1025).setEnabled(page.canFlipToNextPage());
            this.getButton(1026).setEnabled(false);
            prepage.setEnabled(false);
        }
    }

    protected void buttonPressed(int buttonId) {
        IWizardPage page = null;
        switch (buttonId) {
            case 1024: {
                page = this.getWizard().getStartingPage();
                break;
            }
            case 1025: {
                page = this.getCurrentPage().getNextPage();
                break;
            }
            case 1026: {
                page = this.getCurrentPage().getNextPage();
                break;
            }
            case 1: {
                this.cancelPressed();
                return;
            }
        }
        if (page != null && page != this.getCurrentPage()) {
            this.showPage(page);
            this.updateButtons();
        }
        super.buttonPressed(buttonId);
    }
}

