/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.DummyListing;
import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.verifytoUpperCase;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.wizards.NewItemWizard;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewItemPage
extends WizardPage {
    static final String cacopyright = "Copyright \u00a9 2017 CA";
    private static final String TITLE = Messages.NewItemPage_0;
    private static final String ENTER_ITEM_NAME = Messages.NewItemPage_1;
    private static final String SPECIAL_CHARACTERS = Messages.NewItemPage_2;
    private static final String MAXIMUM_LENGTH = Messages.NewItemPage_14;
    private static final String NAME_ALREADY_EXISTS = Messages.NewItemPage_15;
    private static final String LOAD_MODULE = Messages.NewItemPage_16;
    private Text program;
    private Button monitor;
    private Button trace;
    private Button programitem;
    private Button termitem;
    private Button tranitem;
    private NewItemWizard wizard;
    private debugSession session;
    private String CONTEXT_HELP_ID = "com.ca.intertest.additem";
    private boolean isCompositeSetup = false;
    private List<String> list;
    private int maxLength = 8;
    private String regex = "\\s*(;|,|\\s)\\s*";
    private String wrongName = null;
    private String type = "program";
    private String message;
    private boolean isValid;
    private boolean finish;
    private boolean isSelected = true;

    protected NewItemPage(String pageName, boolean isCompositeSetup) {
        super(pageName);
        this.isCompositeSetup = isCompositeSetup;
    }

    private void createRadioButton(Group radio, Button btn, String message, final int length, final String itemType, boolean sel) {
        btn.setText(message);
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewItemPage.this.isSelected = ((Button)e.getSource()).getSelection();
                if (NewItemPage.this.isSelected) {
                    NewItemPage.this.maxLength = length;
                    NewItemPage.this.type = itemType;
                    NewItemPage.this.setPageComplete(NewItemPage.this.finish);
                    NewItemPage.this.isPageComplete();
                }
            }
        });
        btn.setSelection(sel);
    }

    public void createControl(Composite parent) {
        GridData gridData;
        this.wizard = (NewItemWizard)this.getWizard();
        this.session = this.wizard.getSession();
        if (this.session == null) {
            Label label = new Label(parent, 1);
            label.setText(Messages.NewItemPage_3);
            this.setControl((Control)label);
            return;
        }
        this.setTitle(String.valueOf(TITLE) + Messages.NewItemPage_4 + this.session.getName());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        if (this.session.isCICS() && !this.isCompositeSetup) {
            Group radio = new Group(composite, 0);
            radio.setText(Messages.NewItemPage_5);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            radio.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 3;
            radio.setLayout((Layout)layout);
            this.programitem = new Button((Composite)radio, 16);
            this.termitem = new Button((Composite)radio, 16);
            this.tranitem = new Button((Composite)radio, 16);
            this.createRadioButton(radio, this.programitem, Messages.NewItemPage_6, 8, "program", true);
            this.createRadioButton(radio, this.termitem, Messages.NewItemPage_7, 4, "terminal", false);
            this.createRadioButton(radio, this.tranitem, Messages.NewItemPage_8, 4, "transaction", false);
        }
        new Label(composite, 0).setText(Messages.NewItemPage_9);
        this.program = new Text(composite, 2562);
        this.program.setToolTipText(Messages.NewItemPage_10);
        this.program.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.program.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewItemPage.this.getContainer().updateButtons();
            }
        });
        GC gc = new GC((Drawable)parent);
        try {
            gc.getCharWidth('W');
        }
        finally {
            gc.dispose();
        }
        gridData = new GridData(1);
        gridData.widthHint = 500;
        gridData.heightHint = 5 * this.program.getLineHeight();
        this.program.setLayoutData((Object)gridData);
        if (!this.isCompositeSetup) {
            this.monitor = new Button(composite, 32);
            this.monitor.setText(Messages.NewItemPage_11);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            this.monitor.setLayoutData((Object)gridData);
            this.monitor.setSelection(true);
            if (this.session.isCICS()) {
                this.trace = new Button(composite, 32);
                this.trace.setText(Messages.NewItemPage_12);
                this.trace.setSelection(true);
                this.trace.setLayoutData((Object)gridData);
            }
        }
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        composite.setSize(composite.computeSize(-1, -1));
        this.program.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.CONTEXT_HELP_ID);
        this.setControl((Control)composite);
    }

    public boolean doFinish() {
        if (this.isCompositeSetup && this.session.getFile(this.program.getText().trim()) != null) {
            return true;
        }
        ArrayList<Member> member = new ArrayList<Member>();
        String itemtype = "PROGID";
        String prefix = "";
        if (this.session.isCICS() && !this.isCompositeSetup) {
            if (this.termitem.getSelection()) {
                prefix = "$TERM_";
                itemtype = "TERMID";
            } else if (this.tranitem.getSelection()) {
                prefix = "$TRAN_";
                itemtype = "TRANID";
            }
        }
        for (String s : this.list) {
            Member m = new Member();
            m.setName(s);
            member.add(m);
            String name = String.valueOf(prefix) + s.trim();
            m.setName(name);
            if (this.isCompositeSetup) {
                m.setMonitor(false);
                m.setStatementTrace(false);
            } else {
                m.setMonitor(this.monitor.getSelection());
                if (this.session.isCICS()) {
                    m.setStatementTrace(this.trace.getSelection());
                }
            }
            m.setAttribute("item_type", itemtype);
            DummyListing dummy = new DummyListing(m, this.session);
            dummy.build();
            if (dummy.getResult() != 2) {
                MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)HexUtil.getErrorText((Throwable)dummy.getInterrupt()));
                return false;
            }
            debugFile file = this.session.getFile(m.getName());
            if (file == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)TITLE, (String)Messages.NewItemPage_13);
                return false;
            }
            if (this.isCompositeSetup) {
                file.setMonitor(false);
                file.setStatementTrace(false);
                continue;
            }
            file.setMonitor(this.monitor.getSelection());
            if (!this.session.isCICS()) continue;
            file.setStatementTrace(this.trace.getSelection());
            file.setManuallyAddedProgram(true);
        }
        return true;
    }

    public boolean isPageComplete() {
        if (this.session == null) {
            return false;
        }
        this.setErrorMessage(null);
        if (this.isCompositeSetup) {
            this.setErrorMessage(Messages.NewItemPage_16);
        } else if (!this.session.isCICS() || this.termitem.getSelection() || this.tranitem.getSelection()) {
            // empty if block
        }
        this.validate();
        return this.finish;
    }

    private void validate() {
        this.finish = true;
        this.setErrorMessage(null);
        this.list = new ArrayList<String>(Arrays.asList(this.program.getText().split(this.regex)));
        for (String l : this.list) {
            if (l.length() > 0 && l.length() <= this.maxLength) {
                this.itemNameExists(l);
                if (this.isValidProgramName(l)) continue;
                this.message = MessageFormat.format(SPECIAL_CHARACTERS, l);
                this.setErrorMessage(this.message);
                this.finish = false;
                continue;
            }
            if (this.list.size() <= 1 && l.length() == 0) {
                if (this.isCompositeSetup) continue;
                this.setErrorMessage(ENTER_ITEM_NAME);
                this.finish = false;
                continue;
            }
            if (l.length() <= this.maxLength) continue;
            this.wrongName = l;
            this.message = MessageFormat.format(MAXIMUM_LENGTH, this.type, this.wrongName, this.maxLength);
            this.setErrorMessage(this.message);
            this.finish = false;
        }
        this.list.removeAll(Arrays.asList("", null));
    }

    private boolean isValidProgramName(String name) {
        String first = name.substring(0, 1);
        String rest = name.substring(1, name.length());
        Pattern firstPattern = Pattern.compile("[^A-Z@#$]");
        Matcher firstMatcher = firstPattern.matcher(first);
        Pattern restPattern = Pattern.compile("[^0-9A-Z@#$]");
        Matcher restMatcher = restPattern.matcher(rest);
        if (!firstMatcher.find() && !restMatcher.find()) {
            this.isValid = true;
        } else {
            this.isValid = false;
            this.wrongName = name;
        }
        return this.isValid;
    }

    private void itemNameExists(String item) {
        if (this.session.getFile(item) != null && !this.isCompositeSetup) {
            this.wrongName = item;
            this.finish = false;
            this.message = MessageFormat.format(NAME_ALREADY_EXISTS, this.wrongName);
            this.setErrorMessage(this.message);
        }
    }

    public String getProgramName() {
        return this.program.getText().trim();
    }
}

