/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.server.FileServer;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.SchedulingRequestMessage;
import com.ca.intertest.tools.SchedulingReturnMessage;
import com.ca.intertest.tools.SchedulingUpdateMessage;
import com.ca.intertest.tools.StatusMessage;
import com.ca.intertest.wizards.SchedulingRow;
import com.ca.testingtools.common.TTException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SchedulingData
implements IStructuredContentProvider,
IPropertyChangeListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    static int DELETE = 4;
    static int ADD = 0;
    static int CHANGE = 8;
    static int NEWROW = 12;
    private SchedulingRow[] rows;
    private ArrayList<SchedulingRow> rowlist = null;
    private CVMI cvmi;
    private Shell shell;
    private String statusMsg = "";
    private int statusRc = 0;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof SchedulingData) {
            SchedulingData rowData = (SchedulingData)inputElement;
            this.rowlist = rowData.rowlist;
        }
        if (this.rowlist == null) {
            return new SchedulingRow[0];
        }
        int rowCnt = this.rowlist.size();
        for (SchedulingRow rw : this.rowlist) {
            if (rw.getEditflag() != DELETE) continue;
            --rowCnt;
        }
        if (rowCnt < 1) {
            return new SchedulingRow[0];
        }
        this.rows = new SchedulingRow[rowCnt];
        int idx = 0;
        for (SchedulingRow rw : this.rowlist) {
            if (rw.getEditflag() == DELETE) continue;
            this.rows[idx] = rw;
            ++idx;
        }
        if (this.rows == null) {
            return new SchedulingRow[0];
        }
        return this.rows;
    }

    public void dispose() {
    }

    public boolean addRow(SchedulingRow row) {
        row.setEditflag(ADD);
        if (this.rowlist == null) {
            this.rowlist = new ArrayList();
        }
        this.rowlist.add(row);
        return true;
    }

    public boolean updateRow(SchedulingRow oldrow, SchedulingRow newrow) {
        boolean result = false;
        int idx = 0;
        for (SchedulingRow rw : this.rowlist) {
            if (rw.equals(oldrow)) {
                rw = newrow;
                rw.setEditflag(CHANGE);
                this.rowlist.set(idx, rw);
                return true;
            }
            ++idx;
        }
        return result;
    }

    public boolean deleteRow(SchedulingRow oldrow) {
        boolean result = false;
        int idx = 0;
        for (SchedulingRow rw : this.rowlist) {
            if (rw.equals(oldrow)) {
                rw.setEditflag(DELETE);
                this.rowlist.set(idx, rw);
                return true;
            }
            ++idx;
        }
        return result;
    }

    public boolean removeRow(SchedulingRow oldrow) {
        boolean result = false;
        for (SchedulingRow rw : this.rowlist) {
            if (!rw.equals(oldrow)) continue;
            this.rowlist.remove(rw);
            return true;
        }
        return result;
    }

    public ArrayList<SchedulingRow> getRowlist() {
        return this.rowlist;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public boolean sendUpdateRequest(Shell shell, boolean db2, FileServer server) {
        if (server == null) {
            return false;
        }
        try {
            if (!server.isEnabled(false)) {
                server.reportCavhconfError(false);
                return false;
            }
        }
        catch (TTException e) {
            server.reportCavhconfError(false, e);
            return false;
        }
        boolean result = false;
        this.shell = shell;
        int updateCnt = 0;
        for (SchedulingRow rw : this.rowlist) {
            if (rw.getEditflag() >= NEWROW) continue;
            ++updateCnt;
        }
        if (updateCnt == 0) {
            return false;
        }
        FileConnection connection = new FileConnection(server);
        SchedulingUpdateMessage msg = null;
        CVMO cvmo = null;
        try {
            connection.connect(false);
            if (connection.getErrorLevel() == 0) {
                this.cvmi = new CVMI();
                for (SchedulingRow rw : this.rowlist) {
                    if (rw.getEditflag() >= NEWROW) continue;
                    msg = new SchedulingUpdateMessage();
                    msg.setFunc((byte)rw.getEditflag());
                    msg.setCharslot(rw.getSeqno());
                    msg.setJobname(rw.getJobname());
                    msg.setProgram(rw.getProgram());
                    msg.setDatabase(db2 ? "D" : "I");
                    msg.setOnetime(rw.isOneTime() ? "Y" : "N");
                    msg.setUserid(server.getUser());
                    msg.setImsUserId(rw.getImsUserId());
                    msg.setImsTransaction(rw.getImsTransaction());
                    byte b0 = HexUtil.HextoBytes((String)"00")[0];
                    msg.setLast(b0);
                    this.cvmi.addMessage((DebugMessage)msg);
                }
                cvmo = connection.processTomcat(true, new HashMap<String, Object>(), this.cvmi);
            } else {
                this.statusMsg = connection.getErrorMessage();
                this.statusRc = connection.getErrorLevel();
            }
            if (cvmo != null) {
                result = this.processCVMO(cvmo);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.statusMsg = e.getMessage();
            this.statusRc = 32;
        }
        return result;
    }

    public boolean sendFetchRequest(Shell shell, boolean db2, FileServer server, boolean msgFlag) {
        if (server == null) {
            return false;
        }
        try {
            if (!server.isEnabled(false)) {
                if (msgFlag) {
                    server.reportCavhconfError(false);
                }
                return false;
            }
        }
        catch (TTException e) {
            if (msgFlag) {
                server.reportCavhconfError(false, e);
            }
            return false;
        }
        boolean result = false;
        this.shell = shell;
        FileConnection connection = new FileConnection(server);
        SchedulingRequestMessage msg = null;
        CVMO cvmo = null;
        try {
            connection.connect(false);
            if (connection.getErrorLevel() == 0) {
                this.cvmi = new CVMI();
                msg = new SchedulingRequestMessage();
                msg.setDatabase(db2 ? "D" : "I");
                this.cvmi.addMessage((DebugMessage)msg);
                cvmo = connection.processTomcat(true, new HashMap<String, Object>(), this.cvmi);
            } else {
                this.statusMsg = connection.getErrorMessage();
                this.statusRc = connection.getErrorLevel();
            }
            if (cvmo != null) {
                result = this.processCVMO(cvmo);
            }
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.statusMsg = e.getMessage();
            this.statusRc = 32;
        }
        return result;
    }

    protected boolean processCVMO(CVMO cvmo) {
        ArrayList<SchedulingRow> tempList = new ArrayList<SchedulingRow>();
        int count = 0;
        this.statusRc = 0;
        DebugMessage[] debugMessageArray = cvmo.getMessages();
        int n = debugMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugMessage message = debugMessageArray[n2];
            switch (message.getMessageID()) {
                case 46: {
                    tempList = new ArrayList();
                    SchedulingReturnMessage scmsg = (SchedulingReturnMessage)message;
                    count = scmsg.getCount();
                    ArrayList database = new ArrayList(count);
                    ArrayList onetime = new ArrayList(count);
                    ArrayList jobname = new ArrayList(count);
                    ArrayList program = new ArrayList(count);
                    ArrayList charslot = new ArrayList(count);
                    ArrayList userId = new ArrayList(count);
                    ArrayList transaction = new ArrayList(count);
                    database = scmsg.getDatabase();
                    onetime = scmsg.getOnetime();
                    jobname = scmsg.getJobname();
                    program = scmsg.getPrograms();
                    charslot = scmsg.getCharslot();
                    userId = scmsg.getUserId();
                    transaction = scmsg.getTransaction();
                    int i = 0;
                    while (i < count) {
                        boolean bOnetime = ((String)onetime.get(i)).equals("Y");
                        String sDatabase = ((String)database.get(i)).equals("I") ? "IMS" : "DB2";
                        SchedulingRow rw = new SchedulingRow((String)charslot.get(i), (String)jobname.get(i), (String)program.get(i), bOnetime, sDatabase, (String)userId.get(i), (String)transaction.get(i), NEWROW);
                        tempList.add(rw);
                        ++i;
                    }
                    break;
                }
                case 18: {
                    StatusMessage smsg = (StatusMessage)message;
                    this.statusRc = smsg.getStatus();
                    this.statusMsg = smsg.getMessage();
                    break;
                }
                default: {
                    this.shell = Display.getDefault().getActiveShell();
                    this.statusMsg = String.format(Messages.SchedulingData_14, new Object[0]);
                    this.statusRc = 32;
                }
            }
            ++n2;
        }
        if (count > 0) {
            this.rowlist = tempList;
            return true;
        }
        return false;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public int getStatusRc() {
        return this.statusRc;
    }
}

