/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Messages;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.SynchronizeMessage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class SelectSymbolicPage
extends WizardPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final int COL_SIZE = 3;
    public static final int DSN = 0;
    public static final int TIMESTAMP = 1;
    public static final int COMMENT = 2;
    public static final String DSN_TITLE = Messages.SelectSymbolicPage_0;
    public static final String TIMESTAMP_TITLE = Messages.SelectSymbolicPage_1;
    public static final String COMMENT_TITLE = "";
    private int[] width = new int[]{DSN_TITLE.length(), TIMESTAMP_TITLE.length(), "".length()};
    private static final int[] COLUMN_WIDTHS = new int[3];
    private static final int SCROLL_LINES = 5;
    private static final String CONTEXT_HELP_ID = "com.ca.intertest.selectsymbolic";
    private static String[] titles = new String[3];
    private static final int[] styles = new int[3];
    private int[] order;
    private SynchronizeMessage msg;
    private TableViewer viewer;
    private SynchronizeMessage.SynchProtsym protsym;

    public SelectSymbolicPage(String pageName) {
        super(pageName);
        SelectSymbolicPage.COLUMN_WIDTHS[0] = 12;
        SelectSymbolicPage.COLUMN_WIDTHS[1] = 15;
        SelectSymbolicPage.COLUMN_WIDTHS[2] = 10;
        SelectSymbolicPage.titles[0] = DSN_TITLE;
        SelectSymbolicPage.titles[1] = TIMESTAMP_TITLE;
        SelectSymbolicPage.titles[2] = COMMENT_TITLE;
        int i = 0;
        while (i < styles.length) {
            SelectSymbolicPage.styles[i] = 16384;
            ++i;
        }
        this.order = new int[3];
        i = 0;
        while (i < this.order.length) {
            this.order[i] = i;
            ++i;
        }
    }

    public SelectSymbolicPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        SelectSymbolicPage.COLUMN_WIDTHS[0] = 12;
        SelectSymbolicPage.COLUMN_WIDTHS[1] = 15;
        SelectSymbolicPage.COLUMN_WIDTHS[2] = 10;
        SelectSymbolicPage.titles[0] = DSN_TITLE;
        SelectSymbolicPage.titles[1] = TIMESTAMP_TITLE;
        SelectSymbolicPage.titles[2] = COMMENT_TITLE;
        int i = 0;
        while (i < styles.length) {
            SelectSymbolicPage.styles[i] = 16384;
            ++i;
        }
        this.order = new int[3];
        i = 0;
        while (i < this.order.length) {
            this.order[i] = i;
            ++i;
        }
    }

    public void createControl(Composite parent) {
        String format = Messages.SelectSymbolicPage_3;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.checkWidth(composite);
        Label label = new Label(composite, 0);
        String text = String.format(format, this.msg.getProgram(), HexUtil.TimeStampString((int)this.msg.getDate(), (int)this.msg.getTime()));
        label.setText(text);
        if (this.msg.getProtsyms().size() == 0) {
            label = new Label(composite, 1);
            label.setText(Messages.SelectSymbolicPage_4);
        } else {
            this.viewer = new TableViewer(composite, 68356);
            Table table = this.viewer.getTable();
            table.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectSymbolicPage.this.protsym = (SynchronizeMessage.SynchProtsym)e.item.getData();
                    SelectSymbolicPage.this.getContainer().updateButtons();
                }
            });
            this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    SynchronizeMessage.SynchProtsym protsym = (SynchronizeMessage.SynchProtsym)element;
                    switch (columnIndex) {
                        case 0: {
                            return protsym.getDSN();
                        }
                        case 1: {
                            return HexUtil.TimeStampString((int)protsym.getDate(), (int)protsym.getTime());
                        }
                        case 2: {
                            return protsym.getMessage();
                        }
                    }
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(table, styles[i]);
                column.setText(titles[i]);
                int pixels = this.width[i];
                column.setWidth(pixels);
                column.setMoveable(false);
                column.setResizable(true);
                ++i;
            }
            table.setColumnOrder(this.order);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            GridData gridData = new GridData(4, 4, true, true);
            table.setLayoutData((Object)gridData);
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return ((SynchronizeMessage)inputElement).getProtsyms().toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.viewer.setInput((Object)this.msg);
            int tableheight = this.convertHeightInCharsToPixels(5);
            table.setSize(table.computeSize(-1, tableheight, true));
            for (SynchronizeMessage.SynchProtsym item : this.msg.getProtsyms()) {
                if (!item.isExact() && !item.getMessage().equals("MATCH")) continue;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
                this.protsym = item;
                break;
            }
            this.viewer.getControl().setFocus();
        }
        composite.setSize(composite.computeSize(-1, -1));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.getContainer().updateButtons();
    }

    private void checkWidth(Composite parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        int charwidth = gc.getCharWidth('W');
        int widthcount = this.width.length;
        int j = 0;
        while (j < widthcount) {
            this.width[j] = COLUMN_WIDTHS[j] * charwidth;
            ++j;
        }
        gc.dispose();
    }

    public SynchronizeMessage.SynchProtsym getProtsym() {
        return this.protsym;
    }

    public void init(SynchronizeMessage msg) {
        this.msg = msg;
    }

    public boolean isPageComplete() {
        return this.getProtsym() != null;
    }
}

