/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.server.ServerList;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ServerWizardImportPage
extends WizardDataTransferPage {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String STORE_SOURCE_NAMES_ID = "destination_names";
    protected Combo sourceNameField;
    private Button sourceBrowseButton;

    protected ServerWizardImportPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ServerWizardImportPage_0);
        this.setDescription(Messages.ServerWizardImportPage_1);
    }

    protected ServerWizardImportPage() {
        super(Messages.ServerWizardImportPage_2);
    }

    public boolean cancel() {
        this.saveWidgetValues();
        return true;
    }

    public boolean finish() {
        File source = ServerList.getInstance().getPropertyFile();
        File importfile = new File(this.getSourceValue());
        try {
            FileReader fileReader = new FileReader(importfile);
            FileWriter fileWriter = new FileWriter(source);
            XMLMemento xml = XMLMemento.createReadRoot((Reader)fileReader);
            xml.save((Writer)fileWriter);
            this.saveWidgetValues();
            ServerList.load();
            ServerList.getInstance().setChanged();
            ServerList.save();
            return true;
        }
        catch (Exception e) {
            Logger.loggit(e);
            this.setErrorMessage(Messages.ServerWizardImportPage_3);
            return false;
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected void createSourceGroup(Composite parent) {
        Font parentFont = parent.getFont();
        Composite sourceSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceSelectionGroup.setLayout((Layout)layout);
        sourceSelectionGroup.setLayoutData((Object)new GridData(768));
        sourceSelectionGroup.setFont(parentFont);
        Label dest = new Label(sourceSelectionGroup, 0);
        dest.setText(Messages.ServerWizardImportPage_4);
        dest.setFont(parentFont);
        this.sourceNameField = new Combo(sourceSelectionGroup, 2052);
        this.sourceNameField.addListener(24, (Listener)this);
        this.sourceNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parentFont);
        this.sourceBrowseButton = new Button(sourceSelectionGroup, 8);
        this.sourceBrowseButton.setText(Messages.ServerWizardImportPage_5);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setFont(parentFont);
    }

    protected String getSourceValue() {
        return this.sourceNameField.getText().trim();
    }

    protected void setSourceValue(String value) {
        this.sourceNameField.setText(value);
    }

    protected void handleSourceBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), this.getFileDialogStyle());
        dialog.setText(Messages.ServerWizardImportPage_6);
        dialog.setFilterPath(this.getSourceValue());
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.setSourceValue(selectedFileName);
        }
    }

    protected int getFileDialogStyle() {
        return 4096;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setSourceValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addSourceItem(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void addSourceItem(String value) {
        this.sourceNameField.add(value);
    }

    protected void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getSourceValue());
            settings.put(STORE_SOURCE_NAMES_ID, directoryNames);
        }
    }

    protected boolean validateSourceGroup() {
        if (!this.validSource()) {
            this.setErrorMessage(this.getInvalidSourceMessage());
            return false;
        }
        return true;
    }

    private String getInvalidSourceMessage() {
        return Messages.ServerWizardImportPage_7;
    }

    protected boolean validSource() {
        File file = new File(this.getSourceValue());
        return file.exists() && !file.isDirectory();
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected void createOptionsGroup(Composite parent) {
    }
}

