/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.model;

import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.model.Edge;
import com.ca.visualdebugger.plugin.model.Node;
import com.ca.visualdebugger.plugin.model.ParagraphNode;
import com.ca.visualdebugger.plugin.parser.CobolLabel;
import com.ca.visualdebugger.plugin.parser.CobolListingReader;
import com.ca.visualdebugger.plugin.parser.CobolMetadataReader;
import com.ca.visualdebugger.plugin.parser.CobolVerb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProgramNode
extends Node {
    private Map<String, ParagraphNode> paragraphMap = new HashMap<String, ParagraphNode>();
    private Map<String, ProgramNode> externalProgramMap = new HashMap<String, ProgramNode>();
    private Map<Integer, CobolVerb> statementList;
    private CobolMetadataReader cobolReader;
    private CobolListingReader cobolListingReader;

    public ProgramNode(String name, int traceLogIndex) {
        super(traceLogIndex);
        this.setLabel(name);
        this.statementList = null;
        this.cobolReader = CobolMetadataReader.getMetadataReaderFor(GraphController.getInstance().getdebugFile(name));
        this.statementList = this.cobolReader.getVerbsByStatementNumber();
        this.cobolListingReader = CobolListingReader.getListingReaderFor(GraphController.getInstance().getdebugFile(name));
    }

    public ProgramNode(ProgramNode cloneNode, int traceLogIndex) {
        super(traceLogIndex);
        this.setLabel(cloneNode.getLabel());
        this.cobolReader = cloneNode.getCobolReader();
        this.statementList = cloneNode.getStatementList();
        this.cobolListingReader = cloneNode.getCobolListingReader();
    }

    public ParagraphNode addParagraphNode(String paragraphName, CobolLabel paragraphLabel, int traceLogIndex) {
        ParagraphNode paragraphNode = this.paragraphMap.get(paragraphName);
        if (paragraphNode != null) {
            return paragraphNode;
        }
        paragraphNode = new ParagraphNode(paragraphName, paragraphLabel, traceLogIndex);
        if (this.paragraphMap.isEmpty() && this.isFirstNode() && !paragraphNode.isFirstNode()) {
            paragraphNode.setFirstNode(true);
        }
        this.paragraphMap.put(paragraphName, paragraphNode);
        return paragraphNode;
    }

    public ProgramNode addExternalProgramNode(ProgramNode programNode, int index) {
        ProgramNode newProgramNode = this.externalProgramMap.get(programNode.getLabel());
        if (newProgramNode != null) {
            return newProgramNode;
        }
        newProgramNode = new ProgramNode(programNode, index);
        this.externalProgramMap.put(programNode.getLabel(), newProgramNode);
        return newProgramNode;
    }

    public Edge addEdge(String fromNodeName, String toNodeName, int index) {
        Edge edge;
        Node nodeFrom = this.paragraphMap.get(fromNodeName);
        Node nodeTo = this.paragraphMap.get(toNodeName);
        if (nodeFrom == null) {
            nodeFrom = this.externalProgramMap.get(fromNodeName);
        }
        if (nodeFrom == null) {
            return null;
        }
        if (nodeTo == null) {
            nodeTo = this.externalProgramMap.get(toNodeName);
        }
        if ((edge = nodeFrom.findSourceEdge(toNodeName)) == null) {
            edge = new Edge(nodeFrom, nodeTo, index);
        } else {
            edge.addTraceLogIndex(index);
        }
        return edge;
    }

    public ParagraphNode findParagraphNodeByStmnt(int stmntNumber) {
        String paragraphName;
        CobolVerb verb = this.statementList.get(stmntNumber);
        if (verb != null && (paragraphName = verb.getParagraph().getName()) != null && !paragraphName.isEmpty()) {
            return this.getParagraphNode(paragraphName);
        }
        for (ParagraphNode node : this.paragraphMap.values()) {
            if (node.getParagraphLabel() == null || node.getParagraphLabel().getStatementNumber() != stmntNumber) continue;
            return node;
        }
        return null;
    }

    public ParagraphNode findParagraphNodeByLine(int lineNumber) {
        CobolVerb verb = this.cobolReader.getVerbByLine(lineNumber);
        if (verb == null) {
            for (ParagraphNode node : this.paragraphMap.values()) {
                if (node.getParagraphLabel() == null || node.getParagraphLabel().getFirstLineNumber() != lineNumber) continue;
                return node;
            }
        } else {
            String paragraphName = verb.getParagraph().getName();
            return this.paragraphMap.get(paragraphName);
        }
        return null;
    }

    public int getProgramLineInListing() {
        return this.cobolReader.getIdDivisionLine();
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.paragraphMap.values());
        nodes.addAll(this.externalProgramMap.values());
        return nodes;
    }

    public Map<Integer, CobolVerb> getStatementList() {
        return this.statementList;
    }

    public ParagraphNode getParagraphNode(String paragraphName) {
        return this.paragraphMap.get(paragraphName);
    }

    public ProgramNode getExternalProgramNode(String programName) {
        return this.externalProgramMap.get(programName);
    }

    public CobolListingReader getCobolListingReader() {
        return this.cobolListingReader;
    }

    public CobolMetadataReader getCobolReader() {
        return this.cobolReader;
    }
}

