/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.parser;

import com.ca.intertest.debug.debugFile;
import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.dev.TraceDataProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jface.util.IPropertyChangeListener;

public class SessionFileReader {
    private ZipFile sessionFile = null;
    private String name;
    private String projectPath = "";
    private debugFile debugFile;

    public SessionFileReader(debugFile debugFile2) {
        this.debugFile = debugFile2;
        this.name = debugFile2.getName();
        debugFile2.addPropertyChangeListener((IPropertyChangeListener)GraphController.getInstance());
    }

    public SessionFileReader(String intertestProjectPath) {
        this.name = null;
        this.projectPath = intertestProjectPath;
    }

    public SessionFileReader(String name, String intertestProjectPath) {
        this.name = name;
        this.projectPath = intertestProjectPath;
    }

    public InputStream getMetadataStream() {
        return this.getStreamFromZip("metadata");
    }

    public InputStream getListingStream() {
        return this.getStreamFromZip("listing");
    }

    private InputStream getStreamFromZip(String zipEntryName) {
        ZipFile zipFile = this.getSessionFile();
        if (zipFile == null) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(zipEntryName);
        try {
            return this.getSessionFile().getInputStream(zipEntry);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ZipFile getSessionFile() {
        if (this.sessionFile == null) {
            this.sessionFile = this.openSessionFile();
        }
        return this.sessionFile;
    }

    private ZipFile openSessionFile() {
        File metadata = this.debugFile != null ? this.debugFile.getResource().getLocation().toFile() : TraceDataProvider.getInstance().getMetadata(this.name, this.projectPath);
        if (metadata == null) {
            return null;
        }
        try {
            return new ZipFile(metadata);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        try {
            this.closeSessionFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeSessionFile() throws IOException {
        if (this.sessionFile != null) {
            this.sessionFile.close();
            this.sessionFile = null;
        }
    }

    public void finalize() {
        try {
            super.finalize();
            this.closeSessionFile();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

