/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.ui.commands;

import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.model.ProgramNode;
import com.ca.visualdebugger.plugin.views.GraphicalView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class GraphCommandsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command command;
        GraphicalView graphicalView;
        block33: {
            graphicalView = GraphController.getInstance().getViewer();
            ISelection selection = graphicalView.getGraphViewer().getSelection();
            command = event.getCommand();
            if (selection == null || !(selection instanceof IStructuredSelection)) break block33;
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            for (Object object : strucSelection) {
                if (!(object instanceof ProgramNode)) continue;
                ProgramNode node = (ProgramNode)object;
                switch (event.getCommand().getId()) {
                    case "com.ca.visualdebugger.plugin.ui.goToParagraphCommand": {
                        graphicalView.switchToProgramLevel(node.getLabel());
                        graphicalView.storeSelectedProgramName(node.getLabel());
                        break;
                    }
                }
            }
        }
        switch (event.getCommand().getId()) {
            case "com.ca.visualdebugger.plugin.ui.goBluebarCommand": {
                graphicalView.switchToTransactionLevel(true);
                graphicalView.setSelectedState();
                graphicalView.storeSelectedProgramName(GraphController.getInstance().getSessionTransactionName());
                break;
            }
            case "com.ca.visualdebugger.plugin.ui.saveSessionCommand": {
                GraphController.getInstance().saveGraphData();
                break;
            }
            case "com.ca.visualdebugger.plugin.ui.loadSessionCommand": {
                GraphController.getInstance().loadGraphData();
                break;
            }
            case "com.ca.visualdebugger.plugin.ui.focusCommand": {
                graphicalView.focusOnCurrentlyExecutingNode();
                break;
            }
            case "com.ca.visualdebugger.plugin.ui.ToggleSynchronizeCommand": {
                State state = command.getState("org.eclipse.ui.commands.toggleState");
                HandlerUtil.toggleCommandState((Command)command);
                GraphController.getInstance().setSyncToggle((Boolean)state.getValue());
                break;
            }
            case "com.ca.visualdebugger.plugin.ui.backToCommand": {
                graphicalView.backToPreviousProgram();
                break;
            }
            case "com.ca.visualdebugger.plugin.ui.forwardToCommand": {
                graphicalView.forwardToNextVisitedProgram();
                break;
            }
        }
        System.out.println(event.getCommand().getId());
        return null;
    }
}

