/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.Abend;
import com.ca.symdump.BuildDocument;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.batch.SymBatAbend;
import com.ca.symdump.batch.SymBatDumpTreeNode;
import com.ca.symdump.views.tree.DumpTreeView;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymDataset;
import com.ca.testingtools.protsym.ProtsymImportJob;
import com.ca.testingtools.protsym.ProtsymProfileNode;
import com.ca.testingtools.protsym.ui.lister.ListerEditor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;

public class BatchOpenSymbolicHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String SYMBOLIC_INFORMATION_RETRIEVED_FROM = " SYMBOLIC INFORMATION RETRIEVED FROM ";
    private static final String SHOWREPORT = "com.ca.symdump.commands.showreport";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public synchronized Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        ISelection selection;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof DumpTreeView && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && !selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof SymBatDumpTreeNode) {
            Member member;
            SymBatDumpTreeNode node = (SymBatDumpTreeNode)((Object)obj);
            if (!node.isSymbolicNode()) {
                return null;
            }
            IWorkbenchPage page = part.getSite().getPage();
            Object object = node.getObject("content");
            if (object instanceof IEditorInput) {
                try {
                    IEditorPart editor = page.openEditor((IEditorInput)object, "com.ca.testingtools.protsym.lister");
                    if (editor instanceof ListerEditor) {
                        ((ListerEditor)editor).setMemoryManager(node.getAbend().getMemoryManager());
                    }
                    return null;
                }
                catch (PartInitException e) {
                    this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
                    node.setObject("content", null);
                    object = null;
                }
            }
            if ((member = this.openSource(node, page, part)) != null) {
                SymBatAbend abend = (SymBatAbend)node.getAbend();
                abend.addMember(member);
                ProtsymImportJob job = new ProtsymImportJob(member);
                job.schedule();
                page.activate(part);
            } else {
                return null;
            }
        }
        return null;
    }

    private Member openSource(final SymBatDumpTreeNode node, IWorkbenchPage page, IWorkbenchPart part) {
        int end;
        int index;
        String program;
        String string;
        int span;
        int lastoffset;
        int firstoffset;
        int lastline;
        int firstline;
        boolean notExact;
        SymBatDumpTreeNode prognode;
        String offset;
        Document document;
        block25: {
            block24: {
                document = this.buildDoc(node);
                if (document == null) {
                    return null;
                }
                offset = "0";
                prognode = null;
                notExact = false;
                firstline = node.getStartLine();
                lastline = node.getEndLine();
                firstoffset = document.getLineOffset(firstline);
                lastoffset = lastline == 0 ? document.getLength() : document.getLineOffset(lastline) - 1;
                span = lastoffset - firstoffset;
                string = document.get(firstoffset, span).replaceAll(HexUtil.LF, " ");
                if (string.indexOf("CAPD112W") == -1) break block24;
                return null;
            }
            notExact = string.indexOf("CAPD113W") != -1;
            String find = " PROGRAM:";
            program = "";
            index = string.indexOf(find);
            if (index != -1) {
                index += find.length();
                while (index < string.length() && string.charAt(index) == ' ') {
                    ++index;
                }
                end = index;
                while (end < string.length() && string.charAt(end) != ' ') {
                    ++end;
                }
                program = string.substring(index, end);
                index = string.indexOf(" OFFSET:", end) + 8;
                if (index != -1) {
                    while (index < string.length() && string.charAt(index) == ' ') {
                        ++index;
                    }
                    end = index;
                    while (end < string.length() && string.charAt(end) != ' ') {
                        ++end;
                    }
                    offset = string.substring(index, end);
                    String nodename = String.format("Program %s", program);
                    for (DumpTreeNode itemnode : DumpTreeNode.getChain((DumpTreeNode)node.getRoot())) {
                        if (!itemnode.getTitle().equalsIgnoreCase(nodename)) continue;
                        prognode = (SymBatDumpTreeNode)itemnode;
                        break;
                    }
                }
            }
            if (prognode != null) break block25;
            node.setNoListing(true);
            UIJob job = new UIJob("Open Listing"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    String message = "A request to open program did not find a program and statment offset";
                    MessageDialog.openWarning(null, (String)node.getTitle(), (String)message);
                    return new Status(0, "com.ca.testingtools.protsym", 0, "done", null);
                }
            };
            job.schedule();
            this.openReport();
            return null;
        }
        try {
            if (prognode != null) {
                firstline = prognode.getStartLine();
                lastline = prognode.getEndLine();
                firstoffset = document.getLineOffset(firstline);
                string = document.get(firstoffset, span = (lastoffset = lastline == 0 ? document.getLength() : document.getLineOffset(lastline) - 1) - firstoffset).replaceAll(HexUtil.LF, " ");
                if (string.charAt(index = string.indexOf(SYMBOLIC_INFORMATION_RETRIEVED_FROM) + SYMBOLIC_INFORMATION_RETRIEVED_FROM.length()) == ':') {
                    ++index;
                }
                while (index < string.length() && string.charAt(index) == ' ') {
                    ++index;
                }
                end = index;
                while (end < string.length() && string.charAt(end) != ' ') {
                    ++end;
                }
                String dsn = string.substring(index, end);
                index = string.indexOf("MEMBER:", end) + 7;
                while (index < string.length() && string.charAt(index) == ' ') {
                    ++index;
                }
                end = index;
                while (end < string.length() && string.charAt(end) != ' ') {
                    ++end;
                }
                program = string.substring(index, end);
                index = string.indexOf("DATE:", end) + 5;
                while (index < string.length() && string.charAt(index) == ' ') {
                    ++index;
                }
                end = index;
                end = string.indexOf("TIME:", index);
                String date = string.substring(index, end).trim();
                index = end + 5;
                while (index < string.length() && string.charAt(index) == ' ') {
                    ++index;
                }
                end = index;
                while (end < string.length() && string.charAt(end) != ' ') {
                    ++end;
                }
                String time = string.substring(index, end).replace('.', ':');
                String year = date.substring(date.length() - 4);
                index = date.indexOf(32);
                String day = date.substring(0, index);
                end = date.indexOf(44, index);
                String month = date.substring(index, end).trim();
                int monthix = HexUtil.toMonthNumber((String)month) + 1;
                String fullDate = String.format("%s/%02d/%s %s", year, monthix, day, time);
                Dataset dataset = null;
                for (Dataset set : node.getAbend().getProtsyms()) {
                    if (!dsn.equals(set.getName())) continue;
                    dataset = set;
                    break;
                }
                if (dataset == null) {
                    ServerTreeModel model = ServerTreeModel.getInstance();
                    TT_TreeItem profile = node.getAbend().getDataset().getParent().getParent(Profile.class);
                    profile.getAllChildren(ProtsymProfileNode.class);
                    TT_TreeItem nodeItem = (TT_TreeItem)profile.getAllChildren(ProtsymProfileNode.class).get(0);
                    Element nodeElement = nodeItem.getElement();
                    Element datasetElement = model.addNodeChild(nodeElement, dsn);
                    TT_TreeItem datasetItem = model.insertNodeChild(nodeItem, datasetElement);
                    dataset = (Dataset)datasetItem.getValue();
                }
                final Member member = new Member();
                member.setAttribute("name", program);
                member.setAttribute("member", program);
                member.setAttribute("dsn", dsn);
                member.setAttribute("time", fullDate);
                member.setAttribute("offset", offset);
                member.setDataset((ProtsymDataset)dataset);
                member.setMemoryManager(node.getAbend().getMemoryManager());
                if (notExact) {
                    UIJob job = new UIJob("Open Listing"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            String message = String.format("A request to open program %s\ndid not find a member with a matching time and date", member.getDsn(), member.getName());
                            MessageDialog.openWarning(null, (String)node.getTitle(), (String)message);
                            return new Status(0, "com.ca.testingtools.protsym", 0, "done", null);
                        }
                    };
                    job.schedule();
                }
                return member;
            }
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        return null;
    }

    private Document buildDoc(DumpTreeNode node) {
        Abend abend;
        XMLRequest xml;
        Document doc = node.getAbend().getDocument();
        if (doc.getLength() == 0 && (xml = (abend = node.getAbend()).getReport(node)).getErrorLevel() == 0) {
            try {
                doc.replace(0, 0, BuildDocument.buildDocument((XMLRequest)xml).get());
            }
            catch (BadLocationException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        return doc;
    }

    private void openReport() {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            service.executeCommand(SHOWREPORT, null);
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, e.getClass().getSimpleName(), e);
        }
    }
}

