/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.RunGetTrace;
import com.ca.symdump.SymdumpHeaderMap;
import com.ca.symdump.batch.Activator;
import com.ca.symdump.batch.BatchMemory2;
import com.ca.symdump.batch.BatchProfileNode;
import com.ca.symdump.batch.BuildData;
import com.ca.symdump.batch.BuildReport;
import com.ca.symdump.batch.SymBatDumpTreeNode;
import com.ca.symdump.batch.SymBatIndexMaintenance;
import com.ca.symdump.batch.SymBatTreeBuild;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymUtil;
import com.ca.testingtools.protsym.ui.lister.ListerEditor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;

public class SymBatAbend
extends Abend {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    public static final String SYMD = "BAT";
    protected static final String keyFormat = "%-10s%-10s%-10s%-9s%-8s%-12s%-7s%-8s";
    XMLRequest xml = null;
    private Image JobnameImage;
    private BuildData buildData;
    private MFAddress.Amode amode = MFAddress.Amode.UNDEFINED;
    private ArrayList<Member> members = null;

    public SymBatAbend(Element element, ArrayList<SymdumpHeaderMap> headerMap) {
        super(element);
        this.ObjectAddr = element.getAttribute("OBJADDR");
        String lineRecord = XMLFile.getStr((Element)element);
        this.setValues(headerMap, lineRecord);
    }

    public String getColumn(int column) {
        switch (column) {
            case 0: {
                return this.getColumn("JobName");
            }
            case 10: {
                return this.getColumn("Step/Tsk");
            }
            case 1: {
                return this.getColumn("Program");
            }
            case 2: {
                return this.getColumn("Offset");
            }
            case 3: {
                return this.getColumn("Comp");
            }
            case 4: {
                return this.getColumn("Date");
            }
            case 5: {
                return this.getColumn("Time");
            }
            case 100: {
                String time = this.getColumn("Time").replace('.', ':');
                return String.valueOf(time) + ":00";
            }
            case 6: {
                return this.getColumn("UserId");
            }
            case 7: {
                return this.getColumn("Lock");
            }
            case 8: {
                return this.getColumn("System");
            }
            case 103: {
                String time = String.valueOf(this.getColumn("Date")) + " ";
                time = String.valueOf(time) + this.getColumn("Time").replace('.', ':');
                return String.valueOf(time) + ":00";
            }
        }
        return "";
    }

    public DumpTreeNode getDumpTree(boolean force) throws TTException {
        if (!this.isEnabled()) {
            this.closeDump(true);
            return null;
        }
        if (this.dumpTreeNode == null && force) {
            this.dumpTreeNode = new SymBatTreeBuild().getTree(this);
        }
        return this.dumpTreeNode;
    }

    public String getSysd() {
        return SYMD;
    }

    public XMLRequest getReport(DumpTreeNode node) {
        this.xml = new BuildReport().buildReport(this, node, this.xml);
        return this.xml;
    }

    public XMLRequest deleteDump() throws TTException, MalformedURLException {
        if (!this.isEnabled()) {
            return null;
        }
        XMLRequest returnXML = new SymBatIndexMaintenance().deleteDump(this);
        return returnXML;
    }

    public XMLRequest lockDump() throws TTException, MalformedURLException {
        if (!this.isEnabled()) {
            return null;
        }
        XMLRequest returnXML = new SymBatIndexMaintenance().lockDump(this);
        return returnXML;
    }

    public XMLRequest unlockDump() throws TTException, MalformedURLException {
        if (!this.isEnabled()) {
            return null;
        }
        XMLRequest returnXML = new SymBatIndexMaintenance().unlockDump(this);
        return returnXML;
    }

    public String getKey() {
        return String.format(keyFormat, this.getColumn("Program"), this.getColumn("JobName"), this.getColumn("Step/Tsk"), this.getColumn("Offset"), this.getColumn("Comp"), this.getColumn("Date"), this.getColumn("Time"), this.getColumn("UserId"));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            ImageDescriptor tempImage;
            if (this.JobnameImage == null && (tempImage = Activator.getDefault().getImageRegistry().getDescriptor("com.ca.symdump.batch.icon")) != null) {
                this.JobnameImage = tempImage.createImage(true);
            }
            return this.JobnameImage;
        }
        return null;
    }

    protected void doClose() {
        ServerConnect connect = new ServerConnect(this.server, "symdump/server");
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("uuid", this.getUuid());
        try {
            connect.connect("term", map, false);
        }
        catch (Exception exception) {}
    }

    public Data getData(DumpTreeNode node) {
        this.getMemoryManager().init();
        return node.getData();
    }

    public Data getDataItem(DumpTreeNode node) {
        if (this.buildData == null) {
            this.buildData = new BuildData(this);
        }
        return this.buildData.getData((SymBatDumpTreeNode)node);
    }

    public IWatchData getMapData(DumpTreeNode node, IWorkbenchPart part) {
        Display display;
        Data data;
        if (this.buildData == null) {
            this.buildData = new BuildData(this);
        }
        if ((data = this.buildData.getData((SymBatDumpTreeNode)node)) != null && !data.isEmpty() && (display = Display.getCurrent()) != null) {
            MessageDialog.openWarning((Shell)display.getActiveShell(), (String)"Add Mapped data to Watch View", (String)String.format("Mapping information is not available for %s\nUnmapped data will be shown.", node.getText()));
        }
        return data;
    }

    public MFAddress.Amode getAmode() {
        return this.amode;
    }

    public void setAmode(MFAddress.Amode amode) {
        this.amode = amode;
    }

    public String getSymDumpName() {
        return "CA SymDump Batch";
    }

    public IMemoryManager getMemoryManager() {
        if (this.dumpTreeNode == null) {
            this.memoryManager = null;
        } else if (this.memoryManager == null) {
            this.memoryManager = new BatchMemory2(this.dumpTreeNode);
        }
        return this.memoryManager;
    }

    public void closeDump(boolean closeViews) {
        super.closeDump(closeViews);
        this.xml = null;
        this.buildData = null;
        if (this.members != null) {
            IWorkbenchWindow watchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = watchWindow.getActivePage();
            if (page != null) {
                IEditorReference[] references;
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    IEditorPart editor = reference.getEditor(false);
                    if (editor instanceof ListerEditor && this.members.size() > 0) {
                        ListerEditor lister = (ListerEditor)editor;
                        Iterator<Member> it = this.members.iterator();
                        while (it.hasNext()) {
                            Member member = it.next();
                            IFile file = ProtsymUtil.getProtsym((Member)member);
                            if (file == null) continue;
                            try {
                                IFile inputfile;
                                IEditorInput input = reference.getEditorInput();
                                if (!(input instanceof FileEditorInput) || !file.equals((Object)(inputfile = ((FileEditorInput)input).getFile()))) continue;
                                page.closeEditor((IEditorPart)lister, false);
                                it.remove();
                            }
                            catch (PartInitException e) {
                                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                            }
                        }
                    }
                    ++n2;
                }
            }
            this.members.clear();
        }
    }

    public Data getData(MFAddress address) {
        return null;
    }

    public RunGetTrace getGetTrace(DumpTreeNode node) {
        return null;
    }

    public void addMember(Member member) {
        if (this.members == null) {
            this.members = new ArrayList();
        }
        if (!this.members.contains(member)) {
            this.members.add(member);
        }
    }

    public boolean isEnabled() {
        BatchProfileNode batchNode = (BatchProfileNode)this.getDataset().getParent().getParent(BatchProfileNode.class).getValue();
        try {
            if (!batchNode.isEnabled()) {
                batchNode.reportCavhconfError();
                return false;
            }
        }
        catch (TTException e) {
            batchNode.reportCavhconfError(e);
            return false;
        }
        return true;
    }
}

