/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.BuildDocument;
import com.ca.symdump.cics.SymCicsDataset;
import com.ca.symdump.views.options.OptionsView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.views.profile.ProfileView;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.NodeList;

public class DisplayCICSOptsHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private XMLRequest xml = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TT_TreeItem item;
        Object obj;
        ISelection sel;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof ProfileView && (sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && !sel.isEmpty() && (obj = ((IStructuredSelection)sel).getFirstElement()) instanceof TT_TreeItem && (obj = (item = (TT_TreeItem)obj).getValue()) instanceof SymCicsDataset) {
            SymCicsDataset dataset = (SymCicsDataset)((Object)obj);
            if (!dataset.isEnabled()) {
                return null;
            }
            TTServer server = item.getServer();
            IWorkbenchPage page = part.getSite().getPage();
            String secondaryID = String.format("%d%s", server.hashCode(), item.getName());
            IViewReference viewRef = page.findViewReference("com.ca.symdump.ui.views.optionsview", secondaryID);
            IViewPart viewPart = null;
            boolean done = false;
            if (viewRef != null) {
                viewPart = viewRef.getView(true);
                if (viewPart instanceof OptionsView) {
                    done = true;
                } else {
                    this.log.log(Level.FINE, "view not right class");
                    done = true;
                }
            }
            if (!done) {
                GetOptions runner = new GetOptions(dataset, server);
                BusyIndicator.showWhile((Display)part.getSite().getShell().getDisplay(), (Runnable)runner);
                XMLRequest xml = runner.getXml();
                int result = xml.getErrorLevel();
                String title = "Request Failed for " + server.getText();
                if (result == 0) {
                    NodeList nodes = xml.getCommand().getElementsByTagName("Line");
                    if (nodes.getLength() == 0) {
                        MessageDialog.openWarning(null, (String)title, (String)"Empty report - check security settings on dataset");
                        return null;
                    }
                } else {
                    if (result < 8) {
                        MessageDialog.openWarning(null, (String)title, (String)xml.getErrorMessage());
                    } else {
                        TT_ErrorDialog.openError(null, (String)title, (String)xml.getErrorMessage());
                    }
                    return null;
                }
                viewPart = this.buildView(page, xml, secondaryID, String.format("%s - %s Options in effect", server.getName(), item.getName().trim().toUpperCase()));
            }
            page.activate((IWorkbenchPart)viewPart);
            page.activate(part);
        }
        return null;
    }

    private IViewPart buildView(IWorkbenchPage page, XMLRequest xml, String secondaryID, String title) {
        try {
            IViewPart viewPart = page.showView("com.ca.symdump.ui.views.optionsview", secondaryID, 1);
            if (viewPart instanceof OptionsView) {
                OptionsView viewer = (OptionsView)viewPart;
                Document document = BuildDocument.buildDocument((XMLRequest)xml);
                viewer.setContent(document, title);
                return viewPart;
            }
        }
        catch (PartInitException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        return null;
    }

    public class GetOptions
    implements Runnable {
        static final String cacopyright = "Copyright \ufffd 2017 CA";
        Logger log = Logger.getLogger(this.getClass().getName());
        private SymCicsDataset dataset;
        private TTServer server;

        public GetOptions(SymCicsDataset dataset, TTServer server) {
            this.dataset = dataset;
            this.server = server;
        }

        @Override
        public void run() {
            ServerConnect connection = new ServerConnect(this.server, "symdump/server");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("indx", this.dataset.getName());
            map.put("symd", "cic");
            try {
                DisplayCICSOptsHandler.this.xml = connection.connect("opts", map, true);
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }

        public XMLRequest getXml() {
            return DisplayCICSOptsHandler.this.xml;
        }
    }
}

