/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.RunGetTrace;
import com.ca.symdump.SymdumpHeaderMap;
import com.ca.symdump.cics.Activator;
import com.ca.symdump.cics.CicsMemory;
import com.ca.symdump.cics.GetCICSDisplay;
import com.ca.symdump.cics.SymCicsGetData;
import com.ca.symdump.cics.SymCicsIndexMaintenance;
import com.ca.symdump.cics.SymCicsRunGetTrace;
import com.ca.symdump.cics.SymCicsTreeBuild;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymUtil;
import com.ca.testingtools.protsym.ui.lister.ListerEditor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;

public class SymCicsAbend
extends Abend {
    public static final String SYSD = "CIC";
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    static final String CICSTOKEN = "cicstoken";
    private String CICSToken;
    private String CICSVersion = "";
    private Image JobnameImage;
    private ArrayList<Member> members = null;

    public SymCicsAbend(Element element, ArrayList<SymdumpHeaderMap> headerMap) {
        super(element);
        this.ObjectAddr = XMLFile.getAddr((Element)element);
        String lineRecord = XMLFile.getStr((Element)element);
        this.CICSToken = XMLFile.getCICSToken((Element)element);
        this.setValues(headerMap, lineRecord);
    }

    public String getColumn(int column) {
        switch (column) {
            case 0: {
                return this.getColumn("Task");
            }
            case 1: {
                return this.getColumn("Program");
            }
            case 2: {
                return this.getColumn("Offs");
            }
            case 3: {
                return this.getColumn("Comp");
            }
            case 4: {
                return this.getColumn("Date");
            }
            case 5: 
            case 100: {
                return this.getColumn("Time");
            }
            case 8: {
                return this.getColumn("Region");
            }
            case 7: {
                return this.getColumn("Lock");
            }
            case 6: {
                return this.getColumn("UserId");
            }
            case 103: {
                String time = String.valueOf(this.getColumn("Date")) + " ";
                time = String.valueOf(time) + this.getColumn("Time");
                return time;
            }
        }
        return "";
    }

    public DumpTreeNode getDumpTree(boolean force) throws TTException {
        if (!this.isEnabled()) {
            this.closeDump(true);
            return null;
        }
        if (this.dumpTreeNode == null && force) {
            this.dumpTreeNode = new SymCicsTreeBuild().getTree(this);
        }
        return this.dumpTreeNode;
    }

    public String getSysd() {
        return SYSD;
    }

    public XMLRequest getReport(DumpTreeNode node) {
        if (!this.isEnabled()) {
            return null;
        }
        try {
            return GetCICSDisplay.getDisplay((SymCicsAbend)node.getAbend(), node);
        }
        catch (TTException e) {
            this.log.log(Level.WARNING, ((Object)((Object)e)).getClass().getSimpleName(), e);
            XMLRequest xml = new XMLRequest();
            xml.setCommand("disp");
            xml.setStatus(16, HexUtil.getErrorText((Throwable)e));
            return xml;
        }
    }

    public String getCICSToken() {
        return this.CICSToken;
    }

    public XMLRequest deleteDump() throws TTException, MalformedURLException {
        if (!this.isEnabled()) {
            return null;
        }
        XMLRequest returnXML = new SymCicsIndexMaintenance().deleteDump(this);
        return returnXML;
    }

    public XMLRequest lockDump() throws TTException, MalformedURLException {
        if (!this.isEnabled()) {
            return null;
        }
        XMLRequest returnXML = new SymCicsIndexMaintenance().lockDump(this);
        return returnXML;
    }

    public XMLRequest unlockDump() throws TTException, MalformedURLException {
        if (!this.isEnabled()) {
            return null;
        }
        XMLRequest returnXML = new SymCicsIndexMaintenance().unlockDump(this);
        return returnXML;
    }

    public String getKey() {
        return this.getCICSToken();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            ImageDescriptor tempImage;
            if (this.JobnameImage == null && (tempImage = Activator.getDefault().getImageRegistry().getDescriptor("com.ca.symdump.cics.icon")) != null) {
                this.JobnameImage = tempImage.createImage(true);
            }
            return this.JobnameImage;
        }
        return null;
    }

    protected void doClose() {
        ServerConnect connect = new ServerConnect(this.server, "symdump/server");
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("uuid", this.getUuid());
        map.put(CICSTOKEN, this.getCICSToken());
        try {
            connect.connect("term", map, false);
        }
        catch (Exception exception) {}
    }

    public Data getData(DumpTreeNode node) {
        if (!this.isEnabled()) {
            return null;
        }
        return new SymCicsGetData().getData(node);
    }

    public IWatchData getMapData(DumpTreeNode node, IWorkbenchPart part) {
        if (!this.isEnabled()) {
            return null;
        }
        return new SymCicsGetData().getMapData(node);
    }

    public String getSymDumpName() {
        return "CA SymDump for CICS";
    }

    public IMemoryManager getMemoryManager() {
        if (this.dumpTreeNode == null) {
            this.memoryManager = null;
        } else if (this.memoryManager == null) {
            this.memoryManager = new CicsMemory(this.dumpTreeNode);
        }
        return this.memoryManager;
    }

    public String getCICSVersion() {
        return this.CICSVersion;
    }

    public void setCICSVersion(String CICSVersion) {
        this.CICSVersion = CICSVersion == null ? "" : CICSVersion;
    }

    public Data getData(MFAddress address) {
        return null;
    }

    public RunGetTrace getGetTrace(DumpTreeNode node) {
        if (!this.isEnabled()) {
            return null;
        }
        return new SymCicsRunGetTrace(node);
    }

    public void closeDump(boolean closeViews) {
        super.closeDump(closeViews);
        if (this.members != null) {
            IWorkbenchWindow watchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = watchWindow.getActivePage();
            if (page != null) {
                IEditorReference[] references;
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference reference = iEditorReferenceArray[n2];
                    IEditorPart editor = reference.getEditor(false);
                    if (editor instanceof ListerEditor && this.members.size() > 0) {
                        ListerEditor lister = (ListerEditor)editor;
                        Iterator<Member> it = this.members.iterator();
                        while (it.hasNext()) {
                            Member member = it.next();
                            IFile file = ProtsymUtil.getProtsym((Member)member);
                            if (file == null) continue;
                            try {
                                IFile inputfile;
                                IEditorInput input = reference.getEditorInput();
                                if (!(input instanceof FileEditorInput) || !file.equals((Object)(inputfile = ((FileEditorInput)input).getFile()))) continue;
                                page.closeEditor((IEditorPart)lister, false);
                                it.remove();
                            }
                            catch (PartInitException e) {
                                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                            }
                        }
                    }
                    ++n2;
                }
            }
            this.members.clear();
        }
    }

    public void addMember(Member member) {
        if (this.members == null) {
            this.members = new ArrayList();
        }
        if (!this.members.contains(member)) {
            this.members.add(member);
        }
    }

    public boolean isEnabled() {
        return this.getDataset().isEnabled();
    }
}

