/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump;

import com.ca.symdump.Abend;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IWatchData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public abstract class DumpTreeNode {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected static final String FLOWERBOX = "************************\n* %-20s *\n************************\n";
    protected String objectAddr;
    protected String title;
    protected String miscData;
    protected int level = 0;
    protected int nodeNumber = 0;
    protected int startLine = 0;
    protected int endLine = 0;
    protected String tooltipText = null;
    private HashMap<String, Object> objectMap = null;
    protected ArrayList<DumpTreeNode> children = new ArrayList();
    protected DumpTreeNode parent;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private boolean failed = false;

    public DumpTreeNode(String objectAddr, String title, String miscData) {
        this.setObjectAddr(objectAddr);
        this.setTitle(title);
        this.setMiscData(miscData);
    }

    public String getObjectAddr() {
        return this.objectAddr;
    }

    public String getText() {
        if (this.miscData != null && this.miscData.length() > 0) {
            String format = this.parent == null ? "%s %s" : "%s (%s)";
            return String.format(format, this.title, this.miscData);
        }
        return this.getTitle();
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public DumpTreeNode getParent() {
        return this.parent;
    }

    public void setObjectAddr(String objectAddr) {
        this.objectAddr = objectAddr;
    }

    public void setParent(DumpTreeNode parent) {
        this.parent = parent;
    }

    public DumpTreeNode[] getChildren() {
        return this.children.toArray(new DumpTreeNode[this.children.size()]);
    }

    public boolean addChild(DumpTreeNode child) {
        if (this.children.contains(child)) {
            return false;
        }
        child.setParent(this);
        return this.children.add(child);
    }

    public void removeChild(DumpTreeNode child) {
        Iterator<DumpTreeNode> it = this.children.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(child)) continue;
            it.remove();
            return;
        }
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public String getMiscData() {
        return this.miscData == null ? "" : this.miscData;
    }

    public void setMiscData(String miscData) {
        this.miscData = miscData;
    }

    public void setTitle(String title) {
        this.title = title.startsWith("-") ? title.substring(1) : title;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[title=" + this.title + ", objectAddr=" + this.objectAddr + ", miscData=" + this.miscData + ", children=" + this.children.size() + "]";
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public DumpTreeNode getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public Object getObject(String key) {
        return this.objectMap == null ? null : this.objectMap.get(key);
    }

    public void setObject(String key, Object value) {
        if (this.objectMap == null) {
            if (value == null) {
                return;
            }
            this.objectMap = new HashMap();
        }
        if (value == null) {
            this.objectMap.remove(key);
        } else {
            this.objectMap.put(key, value);
        }
    }

    public abstract boolean isSymbolicNode();

    public boolean isLeaf() {
        if (this.failed) {
            return false;
        }
        if (this.isSymbolicNode()) {
            return false;
        }
        if (this.hasChildren()) {
            return this.hasReport();
        }
        int objaddr = 0;
        try {
            objaddr = Integer.decode(this.objectAddr);
        }
        catch (NumberFormatException numberFormatException) {
            objaddr = 0;
        }
        return objaddr > 0;
    }

    public Abend getAbend() {
        Object object = this.getRoot().getObject(Abend.class.getName());
        return object instanceof Abend ? (Abend)object : null;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public String getTooltipText() {
        return this.tooltipText == null ? this.getTitle() : this.tooltipText;
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    public String getFullTooltipText() {
        if (this.parent == null) {
            return this.getTooltipText();
        }
        return String.valueOf(this.parent.getFullTooltipText()) + " " + this.getTooltipText().trim();
    }

    public void setMappedData(IWatchData data) {
        Abend abend;
        if (data != null && (abend = this.getAbend()) != null) {
            data.setOwner(abend.hashCode());
        }
        this.setObject(IWatchData.class.getName(), data);
    }

    public IWatchData getMappedData() {
        return (IWatchData)this.getObject(IWatchData.class.getName());
    }

    public void setData(Data data) {
        Abend abend;
        if (data != null && (abend = this.getAbend()) != null) {
            data.setOwner(abend.hashCode());
        }
        this.setObject(Data.class.getName(), data);
    }

    public Data getData() {
        return (Data)this.getObject(Data.class.getName());
    }

    public boolean hasData() {
        return this.objectMap.containsKey(Data.class.getName());
    }

    public boolean hasReport() {
        return this.startLine != this.endLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public void pushDown(int lines) {
        this.startLine += lines;
        this.endLine += lines;
    }

    public void setParentTitle() {
        if (this.hasReport()) {
            return;
        }
        if (this.hasChildren()) {
            if (this.parent == null) {
                String title = String.format("%s\n\n", this.getText());
                this.insertReport(new Document(title), false);
            } else {
                String title = this.getTitle().trim();
                Document document = this.decorate(new Document(), title, this.getText());
                this.insertReport(document, false);
            }
        }
    }

    private Document decorate(Document document, String search, String title) {
        return this.decorate(document, search, title.split("\\n"));
    }

    private Document decorate(Document document, String search, String[] titles) {
        boolean found;
        String[] searches = search == null ? new String[]{} : search.split(" +");
        int ix = 0;
        while (ix < searches.length) {
            searches[ix] = String.format(" %s ", searches[ix]);
            ++ix;
        }
        boolean bl = found = document.getLength() != 0;
        if (found) {
            FindReplaceDocumentAdapter find = new FindReplaceDocumentAdapter((IDocument)document);
            int index = 0;
            while (index < searches.length && found) {
                try {
                    IRegion region = find.find(0, searches[index], true, false, false, true);
                    if (region == null || region.getOffset() > 250) {
                        found = false;
                        break;
                    }
                    if ((region = find.find(region.getOffset(), "\\*\\*\\*\\*", true, false, false, true)) == null || region.getOffset() > 250) {
                        found = false;
                        break;
                    }
                }
                catch (BadLocationException e) {
                    this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                }
                ++index;
            }
        }
        if (!found) {
            int width = 0;
            String[] stringArray = titles;
            int n = titles.length;
            int e = 0;
            while (e < n) {
                String title = stringArray[e];
                width = Math.max(width, title.length());
                ++e;
            }
            String format = String.format("* %%-%ds *\n", width);
            StringBuilder string = new StringBuilder((width + 5) * (2 + titles.length));
            char[] stars = new char[width + 4];
            Arrays.fill(stars, '*');
            string.append(new String(stars));
            string.append(HexUtil.LF);
            String[] stringArray2 = titles;
            int n2 = titles.length;
            int n3 = 0;
            while (n3 < n2) {
                String item = stringArray2[n3];
                string.append(String.format(format, item));
                ++n3;
            }
            string.append(new String(stars));
            string.append(HexUtil.LF);
            try {
                document.replace(0, 0, string.toString());
            }
            catch (BadLocationException e2) {
                this.log.log(Level.WARNING, ((Object)((Object)e2)).getClass().getSimpleName(), e2);
            }
        }
        return document;
    }

    public IRegion getRegion() {
        try {
            Document document = this.getAbend().getDocument();
            IRegion start = document.getLineInformation(this.startLine);
            IRegion end = document.getLineInformation(this.endLine);
            int length = end.getOffset() - start.getOffset() + end.getLength();
            return new Region(start.getOffset(), length);
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            return new Region(0, 0);
        }
    }

    public void insertReport(Document newDoc, boolean decorate) {
        if (this.parent != null) {
            this.parent.setParentTitle();
        }
        ArrayList<DumpTreeNode> chain = DumpTreeNode.getChain(this.getRoot());
        int index = chain.indexOf(this);
        if (decorate) {
            String title = this.getTitle().trim();
            this.decorate(newDoc, title, this.getText());
        }
        Document document = this.getAbend().getDocument();
        try {
            IRegion region = document.getLineInformation(this.startLine);
            int lines = newDoc.getNumberOfLines() - 1;
            document.replace(region.getOffset(), 0, newDoc.get());
            ++index;
            this.endLine += lines;
            while (index < chain.size()) {
                chain.get(index).pushDown(lines);
                ++index;
            }
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public static ArrayList<DumpTreeNode> getChain(DumpTreeNode treeNode) {
        DumpTreeNode[] children = treeNode.getChildren();
        ArrayList<DumpTreeNode> list = new ArrayList<DumpTreeNode>(children.length + 1);
        list.add(treeNode);
        DumpTreeNode[] dumpTreeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            DumpTreeNode child = dumpTreeNodeArray[n2];
            list.addAll(DumpTreeNode.getChain(child));
            ++n2;
        }
        return list;
    }

    public void setFailed(boolean failed) {
        if (this.failed != failed) {
            this.failed = failed;
            if (failed && !this.hasReport()) {
                Document document = this.decorate(new Document(), this.getTitle(), new String[]{this.getText(), "Not Available"});
                this.insertReport(document, false);
            }
        }
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public void setNodeNumber(int nodeNumber) {
        this.nodeNumber = nodeNumber;
    }
}

