/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.CICSTrace;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.RunGetTrace;
import com.ca.symdump.views.cicstrace.CicsTraceView;
import com.ca.symdump.views.tree.DumpTreeView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractCicsTracehandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        ISelection selection;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        boolean done = false;
        if (part instanceof DumpTreeView && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && !selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof DumpTreeNode) {
            DumpTreeNode node = (DumpTreeNode)obj;
            if (!node.isLeaf()) {
                return this.noReport(node);
            }
            String title = node.getTitle().trim().toLowerCase();
            if (!title.equals("trace")) {
                return this.noReport(node);
            }
            IWorkbenchPage page = part.getSite().getPage();
            IViewReference viewRef = page.findViewReference("com.ca.symdump.ui.views.cicstraceview", node.getAbend().getID());
            IViewPart viewPart = null;
            if (viewRef != null) {
                viewPart = viewRef.getView(true);
                if (viewPart instanceof CicsTraceView) {
                    done = true;
                    page.activate((IWorkbenchPart)viewPart);
                    page.activate(part);
                } else {
                    this.log.log(Level.FINE, "view not right class");
                    done = true;
                }
            }
            if (!done) {
                CICSTrace[] records = node.getAbend().getCICSTraceRecords();
                if (records == null) {
                    RunGetTrace getTrace = node.getAbend().getGetTrace(node);
                    getTrace.setSite(part.getSite());
                    getTrace.schedule();
                } else {
                    try {
                        viewPart = part.getSite().getPage().showView("com.ca.symdump.ui.views.cicstraceview", node.getAbend().getID(), 1);
                        if (viewPart instanceof CicsTraceView) {
                            CicsTraceView viewer = (CicsTraceView)viewPart;
                            viewer.setContent(records, node);
                        }
                    }
                    catch (PartInitException e) {
                        this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                    }
                }
            }
        }
        return null;
    }

    protected Object noReport(DumpTreeNode node) {
        String message = node == null ? "The request to open a CICS Trace is not available" : String.format("The request to open a CICS Trace for %s is not possible", node.getTitle());
        MessageDialog.openWarning(null, (String)"Request CICS Trace", (String)message);
        return null;
    }

    protected void buildView(IWorkbenchPage page, DumpTreeNode node) {
        try {
            IViewPart viewPart = page.showView("com.ca.symdump.ui.views.cicstraceview", node.getAbend().getID(), 1);
            if (viewPart instanceof CicsTraceView) {
                CicsTraceView viewer = (CicsTraceView)viewPart;
                viewer.setContent(node.getAbend().getCICSTraceRecords(), node);
            }
        }
        catch (PartInitException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }
}

