/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.views.report.ReportView;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AddAddresstoWatch
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static ScopedPreferenceStore store = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof ReportView) {
            block9: {
                TextSelection selector;
                String addr;
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                if (selection instanceof TextSelection && !selection.isEmpty() && (addr = (selector = (TextSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).getText()) != null) {
                    if (addr.matches("[0-9A-Fa-f _]+")) {
                        ReportView reportView = (ReportView)part;
                        IMemoryManager manager = reportView.getAbend().getMemoryManager();
                        try {
                            MFAddress mfaddress = new MFAddress(addr);
                            Data data = manager.getMemory(mfaddress, this.getChunk());
                            if (data == null || data.isEmpty()) {
                                MessageDialog.openWarning((Shell)part.getSite().getShell(), (String)"Add data to Watch View", (String)String.format("Data for %s is not available", addr));
                                break block9;
                            }
                            data.setTitle(addr);
                            data.setStride(32);
                            data.setOwner(reportView.getAbend().hashCode());
                            IWorkbenchPage page = part.getSite().getPage();
                            IViewPart viewPart = page.showView("com.ca.testingtools.ui.views.watchdataview");
                            if (viewPart instanceof WatchData) {
                                WatchData viewer = (WatchData)viewPart;
                                viewer.addContent((IWatchData[])new Data[]{data});
                            }
                            page.activate((IWorkbenchPart)viewPart);
                            page.bringToTop((IWorkbenchPart)viewPart);
                        }
                        catch (PartInitException e) {
                            this.log.log(Level.WARNING, "Unexpected failure", e);
                        }
                        catch (Exception e) {
                            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
                        }
                    } else {
                        String message = String.format("The request to view address %s is not available ", addr);
                        MessageDialog.openWarning(null, (String)"Request Address", (String)message);
                    }
                }
            }
            return null;
        }
        return null;
    }

    private int getChunk() {
        if (store == null) {
            store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.testingtools");
        }
        int size = store.getInt("chunksize");
        return size;
    }
}

