/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.BuildDocument;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.RunGetReport;
import com.ca.symdump.views.report.ReportView;
import com.ca.symdump.views.tree.DumpTreeView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class CICSAddReportViewHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String TRACEREPORT = "com.ca.symdump.command.showtraceview";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public synchronized Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        ISelection selection;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        boolean done = false;
        if (part instanceof DumpTreeView && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && !selection.isEmpty() && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof DumpTreeNode) {
            DumpTreeNode node = (DumpTreeNode)obj;
            if (!node.isLeaf()) {
                return this.noReport(node);
            }
            String title = node.getTitle().trim().toLowerCase();
            if (title.equals("trace")) {
                return this.doTrace(event);
            }
            IWorkbenchPage page = part.getSite().getPage();
            IViewReference viewRef = page.findViewReference("com.ca.symdump.ui.views.reportsview", node.getAbend().getID());
            IViewPart viewPart = null;
            if (viewRef != null) {
                viewPart = viewRef.getView(true);
                if (viewPart instanceof ReportView) {
                    if (node.hasReport()) {
                        ReportView viewer = (ReportView)viewPart;
                        viewer.goTop(node);
                        done = true;
                    }
                } else {
                    this.log.log(Level.FINE, "view not right class");
                    done = true;
                }
            }
            if (!done) {
                XMLRequest xml;
                if (!node.hasReport()) {
                    RunGetReport runner = new RunGetReport(node);
                    BusyIndicator.showWhile((Display)part.getSite().getShell().getDisplay(), (Runnable)runner);
                    xml = runner.getXml();
                    int result = xml.getErrorLevel();
                    if (result != 0) {
                        title = "Request Failed for " + node.getText();
                        if (result < 8) {
                            MessageDialog.openWarning(null, (String)title, (String)xml.getErrorMessage());
                        } else {
                            TT_ErrorDialog.openError(null, (String)title, (String)xml.getErrorMessage());
                        }
                        node.setFailed(true);
                        ((DumpTreeView)part).getViewer().refresh((Object)node, true);
                        return null;
                    }
                } else {
                    xml = null;
                }
                viewPart = this.buildView(page, xml, node);
            }
            page.activate((IWorkbenchPart)viewPart);
        }
        return null;
    }

    protected Object noReport(DumpTreeNode node) {
        String message = node == null ? "The request to open a report is not available" : String.format("The request to open a report for %s is not possible", node.getTitle());
        MessageDialog.openWarning(null, (String)"Request Report", (String)message);
        return null;
    }

    protected IViewPart buildView(IWorkbenchPage page, XMLRequest xml, DumpTreeNode node) {
        try {
            IViewPart viewPart = page.showView("com.ca.symdump.ui.views.reportsview", node.getAbend().getID(), 1);
            if (viewPart instanceof ReportView) {
                ReportView viewer = (ReportView)viewPart;
                if (!node.hasReport()) {
                    Document document = BuildDocument.buildDocument(xml);
                    node.insertReport(document, true);
                }
                viewer.setContent(node.getAbend().getDocument(), node);
                return viewPart;
            }
        }
        catch (PartInitException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        return null;
    }

    private Object doTrace(ExecutionEvent event) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            return service.executeCommand(TRACEREPORT, null);
        }
        catch (Exception e) {
            this.log.log(Level.FINE, TRACEREPORT, e);
            return null;
        }
    }
}

