/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.views.tree.DumpTreeView;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CloseDumpTreeNode
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof DumpTreeView) {
            DumpTreeView viewer = (DumpTreeView)part;
            ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)sel;
                ArrayList<Abend> alist = new ArrayList<Abend>(selection.size());
                for (Object object : selection) {
                    Abend selected;
                    if (!(object instanceof DumpTreeNode) || alist.contains(selected = ((DumpTreeNode)object).getAbend())) continue;
                    alist.add(selected);
                }
                if (alist.size() == 0) {
                    return null;
                }
                ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.testingtools");
                String key = "CLOSING_VALUE";
                boolean showDiag = !store.getBoolean(key);
                boolean remove = false;
                if (showDiag) {
                    String message = alist.size() > 1 ? String.format("Are you sure you want to close the selected %d dumps?", alist.size()) : "Are you sure you want to close the dump?";
                    String toggleMessage = "Always close dumps without this prompt";
                    MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Close", (String)message, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)key);
                    int returncode = result.getReturnCode();
                    boolean bl = remove = returncode == 0 || returncode == 2;
                    if (remove) {
                        store.setValue(key, result.getToggleState());
                    }
                } else {
                    remove = true;
                }
                if (remove) {
                    for (Abend item : alist) {
                        viewer.removeContent(item);
                    }
                }
            }
        }
        return null;
    }
}

