/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.ui.wizards;

import com.ca.symdump.CICSTraceLine;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.ui.verifyHex;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class WatchWizardPage
extends WizardPage
implements ModifyListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String sourceClass = WatchWizardPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    Data returnData = null;
    private IWatchData selectedData = null;
    private CICSTraceLine selectedTrace = null;
    private final String NEW_CONTEXT_HELP_ID = "com.ca.symdump.help.addtowatch";
    private boolean newdata = true;
    private StyledText address;
    private MFAddress mfaddress;
    private ScopedPreferenceStore store;
    IMemoryManager manager;

    public WatchWizardPage(IWatchData data, boolean newItem, String title) {
        super("Add to Watch", title, null);
        this.setDescription("Specify Address to add to the Watch Data view");
        this.selectedData = data;
    }

    public WatchWizardPage(CICSTraceLine data, boolean newItem, String title) {
        super("Add to Watch", title, null);
        this.setDescription("Specify Address to add to the Watch Data view");
        this.selectedTrace = data;
    }

    public void createControl(Composite parent) {
        this.store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.testingtools");
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite two_col = new Composite(top, 0);
        two_col.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(two_col, 0);
        label.setText("Address");
        label.setAlignment(131072);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 3;
        label.setLayoutData((Object)data);
        this.address = new StyledText(two_col, 2052);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.address.setLayoutData((Object)data);
        this.address.addModifyListener((ModifyListener)this);
        if (this.selectedData != null) {
            this.address.setText(this.selectedData.getHexText());
        } else {
            this.address.setText(this.selectedTrace.getLine());
        }
        this.address.setWordWrap(false);
        this.address.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.equals(WatchWizardPage.this.address)) {
                    WatchWizardPage.this.getWizard().getContainer().updateButtons();
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.address.addVerifyListener((VerifyListener)new verifyHex());
        if (this.newdata) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.symdump.help.addtowatch");
        }
        this.setControl((Control)top);
    }

    public void modifyText(ModifyEvent e) {
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        if (!this.address.isEnabled()) {
            return true;
        }
        String testdata = this.address.getSelectionText().trim();
        if (testdata.isEmpty()) {
            testdata = this.address.getText().trim();
        }
        if (testdata.isEmpty()) {
            this.setErrorMessage("Missing Address");
            return false;
        }
        if (testdata.matches("[0-9A-Fa-f _]+") && testdata.length() < 9) {
            try {
                this.mfaddress = new MFAddress(testdata);
            }
            catch (Exception exception) {
                this.setErrorMessage("Address is invalid");
                return false;
            }
            this.setMessage(String.format("About to add %s to the Watch Data view", testdata));
            return true;
        }
        return false;
    }

    public boolean doFinish() {
        this.manager = this.selectedData != null ? this.selectedData.getMemoryManager() : this.selectedTrace.getMemoryManager();
        this.returnData = this.manager == null ? null : this.manager.getMemory(this.mfaddress, this.getChunk());
        if (this.returnData == null) {
            this.setErrorMessage(String.format("Address %s is not available in dump storage.", this.mfaddress.toString()));
        } else {
            this.returnData.setStride(32);
            if (this.selectedData != null) {
                this.returnData.setOwner(this.selectedData.getOwner());
            }
        }
        return this.returnData != null && !this.returnData.isEmpty();
    }

    public Data getData() {
        return this.returnData;
    }

    private int getChunk() {
        int size = this.store.getInt("chunksize");
        return size;
    }
}

