/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.views.cicstrace;

import com.ca.symdump.Abend;
import com.ca.symdump.CICSTrace;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.views.cicstrace.CICSTraceTypeFilter;
import com.ca.symdump.views.cicstrace.CicsTraceViewContentProvider;
import com.ca.symdump.views.cicstrace.CicsTraceViewFilter;
import com.ca.symdump.views.cicstrace.DataColumnlabelProvider;
import com.ca.symdump.views.cicstrace.IdColumnlabelProvider;
import com.ca.symdump.views.cicstrace.TraceItemDoubleClickListener;
import com.ca.testingtools.core.IMemoryManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class CicsTraceView
extends ViewPart
implements ISelectionListener,
ISelectionChangedListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public static final String ID = "com.ca.symdump.ui.views.cicstraceview";
    private static final String DESCRIPTION_TEXT = "CICS Trace";
    private static final String CONTEXT_HELP_ID = "com.ca.symdump.help.cicstraceview";
    private TableViewer viewer;
    private Abend abend;
    private DataColumnlabelProvider labelProvider;
    private CicsTraceViewFilter filter = new CicsTraceViewFilter();
    private int fullCount = 0;
    private int filteredCount = 0;
    private CICSTrace[] cicsTraceRecords;
    private TableColumn textColumn;
    public IMemoryManager manager;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68352);
        this.viewer.setContentProvider((IContentProvider)new CicsTraceViewContentProvider());
        Control control = this.viewer.getControl();
        control.setFont(JFaceResources.getTextFont());
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int CHAR_WIDTH = gc.getCharWidth('W');
        gc.dispose();
        gc = null;
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0x1000008);
        tableColumn.setText("Record");
        tableColumn.setWidth(10 * CHAR_WIDTH);
        tableColumn.setMoveable(false);
        tableColumn.setResizable(true);
        tableColumn.setAlignment(131072);
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, tableColumn);
        viewerColumn.setLabelProvider((CellLabelProvider)new IdColumnlabelProvider());
        this.textColumn = new TableColumn(table, 16384);
        this.textColumn.setText("Text");
        this.textColumn.setWidth(152 * CHAR_WIDTH);
        this.textColumn.setMoveable(false);
        this.textColumn.setResizable(true);
        this.labelProvider = new DataColumnlabelProvider();
        viewerColumn = new TableViewerColumn(this.viewer, this.textColumn);
        viewerColumn.setLabelProvider((CellLabelProvider)this.labelProvider);
        this.viewer.setInput(null);
        this.hookDoubleClickAction();
        CICSTraceTypeFilter typefilter = new CICSTraceTypeFilter(this);
        this.viewer.addFilter((ViewerFilter)typefilter);
        parent.pack();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)1);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        menu.addMenuListener(new MenuListener(){
            private boolean buttonShown = true;

            public void menuShown(MenuEvent e) {
                if (this.buttonShown) {
                    Menu menu = (Menu)e.getSource();
                    HashMap<String, MenuItem> menuMap = new HashMap<String, MenuItem>();
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        if (menuMap.put(item.getText(), item) != null) {
                            item.dispose();
                        }
                        ++n2;
                    }
                    this.buttonShown = false;
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new TraceItemDoubleClickListener());
    }

    public void setContent(CICSTrace[] cicsTraceRecords, DumpTreeNode node) {
        this.abend = node.getAbend();
        DumpTreeNode rootNode = node.getRoot();
        String partName = rootNode.getText();
        String toolTip = rootNode.getText();
        this.setTitleToolTip(toolTip);
        this.setContentDescription(partName);
        this.abend.addView(this);
        this.filteredCount = this.fullCount = cicsTraceRecords.length;
        this.filter.clear();
        this.filter.setFiltersw(true);
        this.cicsTraceRecords = cicsTraceRecords;
        this.refresh();
    }

    public void setType(int type) {
        Object object = this.viewer.getInput();
        if (object instanceof CICSTrace[]) {
            CICSTrace[] cICSTraceArray = (CICSTrace[])object;
            int n = cICSTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CICSTrace element = cICSTraceArray[n2];
                element.setShowLevel(type);
                ++n2;
            }
        }
    }

    public DataColumnlabelProvider getlabelProvider() {
        return this.labelProvider;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public CicsTraceViewFilter getFilter() {
        return this.filter;
    }

    public void refresh() {
        String columnformat = "Count %1$d";
        CICSTrace[] CICSTraceArray = this.cicsTraceRecords;
        if (this.filter.getFiltersw().booleanValue() && !this.filter.isNofilters().booleanValue()) {
            ArrayList<CICSTrace> list = new ArrayList<CICSTrace>(this.fullCount);
            CICSTrace[] cICSTraceArray = CICSTraceArray;
            int n = CICSTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CICSTrace item = cICSTraceArray[n2];
                if (this.filter.select((Viewer)this.viewer, null, item)) {
                    list.add(item);
                }
                ++n2;
            }
            this.filteredCount = list.size();
            if (this.filteredCount != this.fullCount) {
                columnformat = "Filtered %2$d of %1$d";
                CICSTraceArray = list.toArray(new CICSTrace[this.filteredCount]);
            }
        }
        this.textColumn.setText(String.format(columnformat, this.fullCount, this.filteredCount));
        this.viewer.setInput((Object)CICSTraceArray);
        this.viewer.refresh(true);
    }

    public void setFocus() {
        Object object;
        ISelection selected = this.viewer.getSelection();
        if ((selected == null || selected.isEmpty()) && (object = this.viewer.getElementAt(0)) != null) {
            selected = new StructuredSelection(object);
            this.viewer.setSelection(selected, true);
        }
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public int getSize() {
        Object object = this.viewer.getInput();
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        return 0;
    }

    public int getFilteredSize() {
        if (!this.filter.getFiltersw().booleanValue()) {
            return this.getSize();
        }
        Object object = this.viewer.getInput();
        int count = 0;
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                boolean result = this.filter.select((Viewer)this.viewer, null, item);
                if (result) {
                    ++count;
                }
                ++n2;
            }
        }
        return count;
    }

    public int getFullCount() {
        return this.fullCount;
    }

    public int getFilteredCount() {
        return this.filteredCount;
    }

    public Abend getAbend() {
        return this.abend;
    }

    public void setMemoryManager(IMemoryManager manager) {
        this.manager = manager;
    }
}

