/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.views.cicstrace;

import com.ca.symdump.CICSTrace;
import com.ca.symdump.CICSTraceLine;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CicsTraceViewFilter
extends ViewerFilter {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String EMPTY = "";
    private String task = "";
    private String tcb = "";
    private String domain = "";
    private String traceid = "";
    private String mod = "";
    private String finddata = "";
    private Boolean filtersw = true;
    private Boolean nofilters = true;
    private String taskFilter;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.filtersw.booleanValue()) {
            return true;
        }
        if (this.nofilters.booleanValue()) {
            return true;
        }
        CICSTrace trace = element instanceof CICSTraceLine ? ((CICSTraceLine)element).getTraceRecord() : (CICSTrace)element;
        String record = trace.getFullRecord();
        String shortrecord = trace.getShortRecord();
        return this.checkTask(record) && this.checkTcb(record) && this.checkDomain(shortrecord) && this.checkTraceid(shortrecord) && this.checkMod(shortrecord) && this.checkFinddata(trace, shortrecord, record);
    }

    public boolean checkTask(String record) {
        if (this.task.isEmpty()) {
            return true;
        }
        return record.contains(this.taskFilter);
    }

    public boolean checkTcb(String record) {
        if (this.tcb.isEmpty()) {
            return true;
        }
        return record.contains("TCB-" + this.tcb);
    }

    public boolean checkDomain(String record) {
        if (this.domain.isEmpty()) {
            return true;
        }
        String recdomain = record.substring(12, 14);
        return recdomain.indexOf(this.domain) != -1;
    }

    public boolean checkTraceid(String record) {
        if (this.traceid.isEmpty()) {
            return true;
        }
        String rectraceid = record.substring(15, 19);
        return rectraceid.indexOf(this.traceid) != -1;
    }

    public boolean checkMod(String record) {
        if (this.mod.isEmpty()) {
            return true;
        }
        String recmod = record.substring(20, 25);
        return recmod.indexOf(this.mod) != -1;
    }

    public boolean checkFinddata(CICSTrace trace, String shortrecord, String record) {
        String findrecord;
        if (this.finddata.isEmpty()) {
            return true;
        }
        int type = trace.getShowLevel();
        switch (type) {
            case 1: {
                findrecord = trace.getAbrevRecord();
                break;
            }
            case 2: {
                findrecord = shortrecord;
                break;
            }
            case 3: {
                findrecord = record;
                break;
            }
            default: {
                return false;
            }
        }
        return findrecord.contains(this.finddata);
    }

    public void setTask(String string) {
        this.task = string;
        this.taskFilter = EMPTY;
        if (!this.task.equals(EMPTY)) {
            try {
                int t = Integer.parseInt(this.task);
                this.taskFilter = String.format("TASK-%05d", t);
            }
            catch (NumberFormatException numberFormatException) {
                this.taskFilter = String.format("TASK-" + this.task, new Object[0]);
            }
        }
        this.setNoFilters();
    }

    public void setTcb(String itcb) {
        this.tcb = itcb;
        this.setNoFilters();
    }

    public void setDomain(String idomain) {
        this.domain = idomain;
        this.setNoFilters();
    }

    public void setTraceid(String itraceid) {
        this.traceid = itraceid;
        this.setNoFilters();
    }

    public void setMod(String imod) {
        this.mod = imod;
        this.setNoFilters();
    }

    public void setFinddata(String ifinddata) {
        this.finddata = ifinddata;
        this.setNoFilters();
    }

    public void setFiltersw(Boolean filsw) {
        this.filtersw = filsw;
        this.setNoFilters();
    }

    public String getTask() {
        return this.task;
    }

    public String getTcb() {
        return this.tcb;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getTraceid() {
        return this.traceid;
    }

    public String getMod() {
        return this.mod;
    }

    public String getFinddata() {
        return this.finddata;
    }

    public Boolean getFiltersw() {
        return this.filtersw;
    }

    public void clear() {
        this.task = EMPTY;
        this.tcb = EMPTY;
        this.domain = EMPTY;
        this.traceid = EMPTY;
        this.mod = EMPTY;
        this.finddata = EMPTY;
        this.nofilters = true;
        this.filtersw = true;
    }

    private void setNoFilters() {
        this.nofilters = this.task.equals(EMPTY) && this.tcb.equals(EMPTY) && this.domain.equals(EMPTY) && this.traceid.equals(EMPTY) && this.mod.equals(EMPTY) && this.finddata.equals(EMPTY);
    }

    public Boolean isNofilters() {
        return this.nofilters;
    }
}

