/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.views.options;

import com.ca.testingtools.core.ProfileNode;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class OptionsView
extends ViewPart {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String sourceClass = OptionsView.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    public static final String ID = "com.ca.symdump.ui.views.optionsview";
    private static final String CONTEXT_HELP_ID = "com.ca.symdump.help.optionsview";
    private TextViewer optionsViewer;
    private String secondary;
    private boolean firstTime = true;

    public void createPartControl(Composite parent) {
        this.secondary = this.getViewSite().getSecondaryId();
        this.buildOptionsViewer(parent);
        this.log.log(Level.FINE, "view {0}:{1} created", new Object[]{ID, this.secondary});
    }

    private void buildOptionsViewer(Composite parent) {
        this.optionsViewer = new TextViewer(parent, 2818);
        this.optionsViewer.setEditable(false);
        this.optionsViewer.canDoOperation(4);
        this.optionsViewer.canDoOperation(5);
        this.optionsViewer.enableOperation(4, true);
        this.optionsViewer.enableOperation(10, true);
        this.getSite().setSelectionProvider((ISelectionProvider)this.optionsViewer);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.optionsViewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.optionsViewer);
        Control control = this.optionsViewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.optionsViewer.getControl().setFont(JFaceResources.getTextFont());
        this.optionsViewer.setInput((Object)new Document(""));
    }

    public void setContent(Document document, String title) {
        if (this.firstTime) {
            this.firstTime = false;
            this.setTitleToolTip(title);
            this.setContentDescription(title);
            this.setPartName(title);
        }
        this.optionsViewer.setInput((Object)document);
    }

    public void setFocus() {
        this.optionsViewer.getControl().setFocus();
    }

    public void goTop(ProfileNode node2) {
        int line = node2.getStartLine();
        this.optionsViewer.setTopIndex(line);
        this.optionsViewer.setTopIndex(line);
    }
}

